/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.hsqldb.gui.tables;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.hsqldb.OrbadaHSqlDbPlugin;
import pl.mpak.orbada.hsqldb.Sql;
import pl.mpak.orbada.hsqldb.gui.wizards.RenameTableColumnWizard;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.orbada.universal.gui.wizards.AlterTableNullWizardPanel;
import pl.mpak.orbada.universal.gui.wizards.CreateConstraintCheckWizardPanel;
import pl.mpak.orbada.universal.gui.wizards.CreateConstraintForeignKeyWizardPanel;
import pl.mpak.orbada.universal.gui.wizards.CreateConstraintPrimaryKeyWizardPanel;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.timer.Timer;
import pl.mpak.util.variant.Variant;

public class TableColumnsPanel
extends JPanel
implements ITabObjectInfo {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaHSqlDbPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName = "";
    private String currentTableName = "";
    private boolean requestRefresh = false;
    private SqlFilter filter;
    private Timer timer;
    private ToolButton buttonActions;
    private ToolButton buttonColumnNotNull;
    private ToolButton buttonCreateConstraintCheck;
    private ToolButton buttonDropColumn;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private Action cmColumnNotNull;
    private Action cmCreateConstraintCheck;
    private Action cmCreateConstraintFK;
    private Action cmCreateConstraintPK;
    private Action cmDropColumn;
    private Action cmFilter;
    private Action cmRefresh;
    private Action cmRenameColumn;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JSeparator jSeparator4;
    private JToolBar.Separator jSeparator5;
    private JSeparator jSeparator6;
    private JPopupMenu menuActions;
    private JMenuItem menuColumnNotNull;
    private JMenuItem menuCreateConstraintCheck;
    private JMenuItem menuDropColumn;
    private JMenuItem menuRenameColumn;
    private QueryTableStatusBar statusBarColumns;
    private ViewTable tableColumns;
    private JToolBar toolBarColumns;
    private ToolButton toolButton1;
    private ToolButton toolButton2;
    private ToolButton toolButton3;

    public TableColumnsPanel(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.timer = new Timer(250L){
            {
                this.setEnabled(false);
            }

            public void run() {
                this.setEnabled(false);
                TableColumnsPanel.this.refresh();
            }
        };
        OrbadaHSqlDbPlugin.getRefreshQueue().add(this.timer);
        this.tableColumns.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int rowIndex = TableColumnsPanel.this.tableColumns.getSelectedRow();
                if (rowIndex >= 0 && TableColumnsPanel.this.tableColumns.getQuery().isActive()) {
                    try {
                        TableColumnsPanel.this.tableColumns.getQuery().getRecord(rowIndex);
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                }
            }
        });
        this.tableColumns.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableColumns.addColumn((TableColumn)new QueryTableColumn("ordinal_position", this.stringManager.getString("pos"), 30));
            this.tableColumns.addColumn((TableColumn)new QueryTableColumn("column_name", this.stringManager.getString("column-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableColumns.addColumn((TableColumn)new QueryTableColumn("display_type", this.stringManager.getString("display-type"), 120, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.GREEN)));
            this.tableColumns.addColumn((TableColumn)new QueryTableColumn("column_def", this.stringManager.getString("default-value"), 200));
            this.tableColumns.addColumn((TableColumn)new QueryTableColumn("is_nullable", "Null?", 40));
            this.tableColumns.addColumn((TableColumn)new QueryTableColumn("pk_column", this.stringManager.getString("pk-column"), 40));
            this.tableColumns.addColumn((TableColumn)new QueryTableColumn("remarks", this.stringManager.getString("comment"), 300));
            SqlFilterDef def = new SqlFilterDef();
            def.add(new SqlFilterDefComponent("cols.column_name", this.stringManager.getString("column-name"), (String[])null));
            def.add(new SqlFilterDefComponent("cols.type_name", this.stringManager.getString("column-type"), new String[]{"", "'VARCHAR%'", "'NUMERIC%'", "'INTEGER%'", "'TIMESTAMP%'"}));
            def.add(new SqlFilterDefComponent("cols.column_def", this.stringManager.getString("default-value"), (String[])null));
            def.add(new SqlFilterDefComponent("cols.is_nullable = 'NO'", "NOT NULL"));
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "hsqldb-table-columns-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableColumns, (JButton)this.buttonActions, this.menuActions, "hsqldb-table-columns-actions");
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public String getTitle() {
        return this.stringManager.getString("TableColumnsPanel-title");
    }

    public void refresh() {
        try {
            String columnName = null;
            this.requestRefresh = false;
            if (this.tableColumns.getQuery().isActive() && this.tableColumns.getSelectedRow() >= 0) {
                this.tableColumns.getQuery().getRecord(this.tableColumns.getSelectedRow());
                columnName = this.tableColumns.getQuery().fieldByName("COLUMN_NAME").getString();
            }
            this.tableColumns.getQuery().close();
            this.tableColumns.getQuery().setSqlText(Sql.getColumnList(this.filter.getSqlText()));
            this.tableColumns.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
            this.tableColumns.getQuery().paramByName("table_name").setString(this.currentTableName);
            this.tableColumns.getQuery().open();
            if (!this.tableColumns.getQuery().isEmpty()) {
                if (columnName != null && this.tableColumns.getQuery().locate("column_name", new Variant(columnName))) {
                    this.tableColumns.changeSelection(this.tableColumns.getQuery().getCurrentRecord().getIndex(), 0);
                } else {
                    this.tableColumns.changeSelection(0, 0);
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public void refresh(String catalogName, String schemaName, String objectName) {
        if (!this.currentSchemaName.equals(schemaName) || !this.currentTableName.equals(objectName) || this.requestRefresh) {
            this.currentSchemaName = schemaName;
            this.currentTableName = objectName;
            if (this.isVisible()) {
                this.timer.restart();
            } else {
                this.requestRefresh = true;
            }
        }
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.timer.cancel();
        this.tableColumns.getQuery().close();
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.cmColumnNotNull = new Action();
        this.cmCreateConstraintCheck = new Action();
        this.cmDropColumn = new Action();
        this.menuActions = new JPopupMenu();
        this.menuColumnNotNull = new JMenuItem();
        this.menuCreateConstraintCheck = new JMenuItem();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.jSeparator6 = new JSeparator();
        this.menuRenameColumn = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.menuDropColumn = new JMenuItem();
        this.cmRenameColumn = new Action();
        this.cmCreateConstraintFK = new Action();
        this.cmCreateConstraintPK = new Action();
        this.jScrollPane1 = new JScrollPane();
        this.tableColumns = new ViewTable();
        this.statusBarColumns = new QueryTableStatusBar();
        this.jPanel1 = new JPanel();
        this.toolBarColumns = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator5 = new JToolBar.Separator();
        this.toolButton1 = new ToolButton();
        this.jSeparator1 = new JSeparator();
        this.buttonColumnNotNull = new ToolButton();
        this.buttonCreateConstraintCheck = new ToolButton();
        this.toolButton2 = new ToolButton();
        this.toolButton3 = new ToolButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.buttonDropColumn = new ToolButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableColumnsPanel.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableColumnsPanel.this.cmFilterActionPerformed(evt);
            }
        });
        this.cmColumnNotNull.setActionCommandKey("cmColumnNotNull");
        this.cmColumnNotNull.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/lock16.gif"));
        this.cmColumnNotNull.setText(this.stringManager.getString("cmColumnNotNull-text"));
        this.cmColumnNotNull.setTooltip(this.stringManager.getString("cmColumnNotNull-hint"));
        this.cmColumnNotNull.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableColumnsPanel.this.cmColumnNotNullActionPerformed(evt);
            }
        });
        this.cmCreateConstraintCheck.setActionCommandKey("cmCreateConstraintCheck");
        this.cmCreateConstraintCheck.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/verify_document_16.gif"));
        this.cmCreateConstraintCheck.setText(this.stringManager.getString("cmCreateConstraintCheck-text"));
        this.cmCreateConstraintCheck.setTooltip(this.stringManager.getString("cmCreateConstraintCheck-hint"));
        this.cmCreateConstraintCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableColumnsPanel.this.cmCreateConstraintCheckActionPerformed(evt);
            }
        });
        this.cmDropColumn.setActionCommandKey("cmDropColumn");
        this.cmDropColumn.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDropColumn.setText(this.stringManager.getString("cmDropColumn-text"));
        this.cmDropColumn.setTooltip(this.stringManager.getString("cmDropColumn-hint"));
        this.cmDropColumn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableColumnsPanel.this.cmDropColumnActionPerformed(evt);
            }
        });
        this.menuColumnNotNull.setAction((javax.swing.Action)this.cmColumnNotNull);
        this.menuActions.add(this.menuColumnNotNull);
        this.menuCreateConstraintCheck.setAction((javax.swing.Action)this.cmCreateConstraintCheck);
        this.menuActions.add(this.menuCreateConstraintCheck);
        this.jMenuItem1.setAction((javax.swing.Action)this.cmCreateConstraintFK);
        this.menuActions.add(this.jMenuItem1);
        this.jMenuItem2.setAction((javax.swing.Action)this.cmCreateConstraintPK);
        this.menuActions.add(this.jMenuItem2);
        this.menuActions.add(this.jSeparator6);
        this.menuRenameColumn.setAction((javax.swing.Action)this.cmRenameColumn);
        this.menuActions.add(this.menuRenameColumn);
        this.menuActions.add(this.jSeparator4);
        this.menuDropColumn.setAction((javax.swing.Action)this.cmRenameColumn);
        this.menuActions.add(this.menuDropColumn);
        this.cmRenameColumn.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/rename.gif"));
        this.cmRenameColumn.setText(this.stringManager.getString("cmRenameColumn-text"));
        this.cmRenameColumn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableColumnsPanel.this.cmRenameColumnActionPerformed(evt);
            }
        });
        this.cmCreateConstraintFK.setActionCommandKey("cmCreateConstraintFK");
        this.cmCreateConstraintFK.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/foreign_key16.gif"));
        this.cmCreateConstraintFK.setText(this.stringManager.getString("cmCreateConstraintFK-text"));
        this.cmCreateConstraintFK.setTooltip(this.stringManager.getString("cmCreateConstraintFK-hint"));
        this.cmCreateConstraintFK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableColumnsPanel.this.cmCreateConstraintFKActionPerformed(evt);
            }
        });
        this.cmCreateConstraintPK.setActionCommandKey("cmCreateConstraintPK");
        this.cmCreateConstraintPK.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/primary_key16.gif"));
        this.cmCreateConstraintPK.setText(this.stringManager.getString("cmCreateConstraintPK-text"));
        this.cmCreateConstraintPK.setTooltip(this.stringManager.getString("cmCreateConstraintPK-hint"));
        this.cmCreateConstraintPK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableColumnsPanel.this.cmCreateConstraintPKActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                TableColumnsPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableColumns);
        this.add((Component)this.jScrollPane1, "Center");
        this.statusBarColumns.setShowFieldType(false);
        this.statusBarColumns.setShowOpenTime(false);
        this.statusBarColumns.setTable((QueryTable)this.tableColumns);
        this.add((Component)this.statusBarColumns, "Last");
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarColumns.setFloatable(false);
        this.toolBarColumns.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.buttonRefresh);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.buttonFilter);
        this.toolBarColumns.add(this.jSeparator5);
        this.toolButton1.setAction((javax.swing.Action)this.cmRenameColumn);
        this.toolButton1.setHorizontalTextPosition(0);
        this.toolButton1.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.toolButton1);
        this.jSeparator1.setOrientation(1);
        this.toolBarColumns.add(this.jSeparator1);
        this.buttonColumnNotNull.setAction((javax.swing.Action)this.cmColumnNotNull);
        this.buttonColumnNotNull.setHorizontalTextPosition(0);
        this.buttonColumnNotNull.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.buttonColumnNotNull);
        this.buttonCreateConstraintCheck.setAction((javax.swing.Action)this.cmCreateConstraintCheck);
        this.buttonCreateConstraintCheck.setHorizontalTextPosition(0);
        this.buttonCreateConstraintCheck.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.buttonCreateConstraintCheck);
        this.toolButton2.setAction((javax.swing.Action)this.cmCreateConstraintFK);
        this.toolButton2.setHorizontalTextPosition(0);
        this.toolButton2.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.toolButton2);
        this.toolButton3.setAction((javax.swing.Action)this.cmCreateConstraintPK);
        this.toolButton3.setHorizontalTextPosition(0);
        this.toolButton3.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.toolButton3);
        this.toolBarColumns.add(this.jSeparator2);
        this.buttonDropColumn.setAction((javax.swing.Action)this.cmDropColumn);
        this.buttonDropColumn.setHorizontalTextPosition(0);
        this.buttonDropColumn.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.buttonDropColumn);
        this.toolBarColumns.add(this.jSeparator3);
        this.toolBarColumns.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBarColumns);
        this.add((Component)this.jPanel1, "North");
    }

    private void cmCreateConstraintCheckActionPerformed(ActionEvent evt) {
        if (this.tableColumns.getSelectedRow() >= 0) {
            try {
                this.tableColumns.getQuery().getRecord(this.tableColumns.getSelectedRow());
                String columnName = this.tableColumns.getQuery().fieldByName("COLUMN_NAME").getString();
                SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateConstraintCheckWizardPanel(this.getDatabase(), this.currentSchemaName, this.currentTableName), (boolean)true);
                this.refresh();
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    private void cmColumnNotNullActionPerformed(ActionEvent evt) {
        if (this.tableColumns.getSelectedRow() >= 0) {
            try {
                this.tableColumns.getQuery().getRecord(this.tableColumns.getSelectedRow());
                String columnName = this.tableColumns.getQuery().fieldByName("COLUMN_NAME").getString();
                SqlCodeWizardDialog.show((SqlCodeWizardPanel)new AlterTableNullWizardPanel(this.getDatabase(), this.currentSchemaName, this.currentTableName, columnName, "ALTER COLUMN", "SET"), (boolean)true);
                this.refresh();
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void formComponentShown(ComponentEvent evt) {
        this.refresh(null, this.currentSchemaName, this.currentTableName);
    }

    private void cmDropColumnActionPerformed(ActionEvent evt) {
        if (this.tableColumns.getSelectionModel().getLeadSelectionIndex() >= 0) {
            try {
                this.tableColumns.getQuery().getRecord(this.tableColumns.getSelectionModel().getLeadSelectionIndex());
                String objectName = SQLUtil.createSqlName((String)this.currentSchemaName, (String)this.tableColumns.getQuery().fieldByName("column_name").getString(), (Database)this.getDatabase());
                String tableName = SQLUtil.createSqlName((String)this.currentSchemaName, (String)this.currentTableName, (Database)this.getDatabase());
                if (MessageBox.show((Component)this, (String)this.stringManager.getString("deleting"), (String)String.format(this.stringManager.getString("TableColumnsPanel-drop-column-q"), objectName, tableName), (int[])ModalResult.YESNO) == 5) {
                    this.getDatabase().createCommand("alter table " + tableName + " drop column " + objectName, true);
                    this.timer.restart();
                }
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    private void cmRenameColumnActionPerformed(ActionEvent evt) {
        if (this.tableColumns.getSelectedRow() >= 0) {
            try {
                this.tableColumns.getQuery().getRecord(this.tableColumns.getSelectedRow());
                String columnName = this.tableColumns.getQuery().fieldByName("COLUMN_NAME").getString();
                SqlCodeWizardDialog.show((SqlCodeWizardPanel)new RenameTableColumnWizard(this.getDatabase(), this.currentSchemaName, this.currentTableName, columnName), (boolean)true);
                this.refresh();
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    private void cmCreateConstraintFKActionPerformed(ActionEvent evt) {
        try {
            this.tableColumns.getQuery().getRecord(this.tableColumns.getSelectedRow());
            String columnName = this.tableColumns.getQuery().fieldByName("COLUMN_NAME").getString();
            SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateConstraintForeignKeyWizardPanel(this.getDatabase(), this.currentSchemaName, this.currentTableName, columnName), (boolean)true);
            this.refresh();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmCreateConstraintPKActionPerformed(ActionEvent evt) {
        try {
            this.tableColumns.getQuery().getRecord(this.tableColumns.getSelectedRow());
            String columnName = this.tableColumns.getQuery().fieldByName("COLUMN_NAME").getString();
            SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateConstraintPrimaryKeyWizardPanel(this.getDatabase(), this.currentSchemaName, this.currentTableName, columnName), (boolean)true);
            this.refresh();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }
}

