/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.hsqldb.gui.tables;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.hsqldb.OrbadaHSqlDbPlugin;
import pl.mpak.orbada.hsqldb.Sql;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.orbada.universal.gui.wizards.CreateIndexWizardPanel;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.timer.Timer;

public class TableIndexesPanel
extends JPanel
implements ITabObjectInfo {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaHSqlDbPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName = "";
    private String currentTableName = "";
    private boolean requestRefresh = false;
    private SqlFilter filter;
    private Timer timer;
    private ToolButton buttonActions;
    private ToolButton buttonCreateIndex;
    private ToolButton buttonDtopIndex;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private Action cmCreateIndex;
    private Action cmDropIndex;
    private Action cmFilter;
    private Action cmRefresh;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JPopupMenu menuActions;
    private QueryTableStatusBar statusBarIndexes;
    private ViewTable tableIndexes;
    private JToolBar toolBarIndexes;

    public TableIndexesPanel(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.timer = new Timer(250L){
            {
                this.setEnabled(false);
            }

            public void run() {
                this.setEnabled(false);
                TableIndexesPanel.this.refresh();
            }
        };
        OrbadaHSqlDbPlugin.getRefreshQueue().add(this.timer);
        this.tableIndexes.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int rowIndex = TableIndexesPanel.this.tableIndexes.getSelectedRow();
                if (rowIndex >= 0 && TableIndexesPanel.this.tableIndexes.getQuery().isActive()) {
                    try {
                        TableIndexesPanel.this.tableIndexes.getQuery().getRecord(rowIndex);
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                }
            }
        });
        this.tableIndexes.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("ordinal_position", this.stringManager.getString("pos"), 30));
            this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("index_name", this.stringManager.getString("index-name"), 200, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("column_name", this.stringManager.getString("column-name"), 150));
            this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("pk_index", this.stringManager.getString("pk-index"), 50));
            this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("unique_index", this.stringManager.getString("unique"), 50));
            this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("index_type", this.stringManager.getString("index-type"), 70));
            SqlFilterDef def = new SqlFilterDef();
            def.add(new SqlFilterDefComponent("idx.index_name", this.stringManager.getString("index-name"), (String[])null));
            def.add(new SqlFilterDefComponent("idx.column_name", this.stringManager.getString("column-name"), (String[])null));
            def.add(new SqlFilterDefComponent("idx.non_unique = 'YES'", this.stringManager.getString("uniquiness")));
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "hsqldb-table-indexes-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableIndexes, (JButton)this.buttonActions, this.menuActions, "hsqldb-table-indexes-actions");
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public String getTitle() {
        return this.stringManager.getString("TableIndexesPanel-title");
    }

    public void refresh() {
        try {
            this.requestRefresh = false;
            this.tableIndexes.getQuery().close();
            this.tableIndexes.getQuery().setSqlText(Sql.getIndexList(this.filter.getSqlText()));
            this.tableIndexes.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
            this.tableIndexes.getQuery().paramByName("table_name").setString(this.currentTableName);
            this.tableIndexes.getQuery().open();
            if (!this.tableIndexes.getQuery().isEmpty()) {
                this.tableIndexes.changeSelection(0, 0);
            }
        }
        catch (Exception ex) {
            MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public void refresh(String catalogName, String schemaName, String objectName) {
        if (!this.currentSchemaName.equals(schemaName) || !this.currentTableName.equals(objectName) || this.requestRefresh) {
            this.currentSchemaName = schemaName;
            this.currentTableName = objectName;
            if (this.isVisible()) {
                this.timer.restart();
            } else {
                this.requestRefresh = true;
            }
        }
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.timer.cancel();
        this.tableIndexes.getQuery().close();
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.cmDropIndex = new Action();
        this.cmCreateIndex = new Action();
        this.menuActions = new JPopupMenu();
        this.jScrollPane1 = new JScrollPane();
        this.tableIndexes = new ViewTable();
        this.statusBarIndexes = new QueryTableStatusBar();
        this.jPanel1 = new JPanel();
        this.toolBarIndexes = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator2 = new JSeparator();
        this.buttonCreateIndex = new ToolButton();
        this.jSeparator1 = new JSeparator();
        this.buttonDtopIndex = new ToolButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableIndexesPanel.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableIndexesPanel.this.cmFilterActionPerformed(evt);
            }
        });
        this.cmDropIndex.setActionCommandKey("cmDropIndex");
        this.cmDropIndex.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDropIndex.setText(this.stringManager.getString("cmDropIndex-text"));
        this.cmDropIndex.setTooltip(this.stringManager.getString("cmDropIndex-hint"));
        this.cmDropIndex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableIndexesPanel.this.cmDropIndexActionPerformed(evt);
            }
        });
        this.cmCreateIndex.setActionCommandKey("cmCreateIndex");
        this.cmCreateIndex.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/create_index16.gif"));
        this.cmCreateIndex.setText(this.stringManager.getString("cmCreateIndex-text"));
        this.cmCreateIndex.setTooltip(this.stringManager.getString("cmCreateIndex-hint"));
        this.cmCreateIndex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableIndexesPanel.this.cmCreateIndexActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                TableIndexesPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableIndexes);
        this.add((Component)this.jScrollPane1, "Center");
        this.statusBarIndexes.setShowFieldType(false);
        this.statusBarIndexes.setShowOpenTime(false);
        this.statusBarIndexes.setTable((QueryTable)this.tableIndexes);
        this.add((Component)this.statusBarIndexes, "Last");
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarIndexes.setFloatable(false);
        this.toolBarIndexes.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarIndexes.add((Component)this.buttonRefresh);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarIndexes.add((Component)this.buttonFilter);
        this.jSeparator2.setOrientation(1);
        this.toolBarIndexes.add(this.jSeparator2);
        this.buttonCreateIndex.setAction((javax.swing.Action)this.cmCreateIndex);
        this.buttonCreateIndex.setHorizontalTextPosition(0);
        this.buttonCreateIndex.setVerticalTextPosition(3);
        this.toolBarIndexes.add((Component)this.buttonCreateIndex);
        this.jSeparator1.setOrientation(1);
        this.toolBarIndexes.add(this.jSeparator1);
        this.buttonDtopIndex.setAction((javax.swing.Action)this.cmDropIndex);
        this.buttonDtopIndex.setHorizontalTextPosition(0);
        this.buttonDtopIndex.setVerticalTextPosition(3);
        this.toolBarIndexes.add((Component)this.buttonDtopIndex);
        this.toolBarIndexes.add(this.jSeparator3);
        this.toolBarIndexes.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBarIndexes);
        this.add((Component)this.jPanel1, "North");
    }

    private void cmCreateIndexActionPerformed(ActionEvent evt) {
        SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateIndexWizardPanel(this.getDatabase(), this.currentSchemaName, this.currentTableName), (boolean)true);
        this.timer.restart();
    }

    private void cmDropIndexActionPerformed(ActionEvent evt) {
        if (this.tableIndexes.getSelectionModel().getLeadSelectionIndex() >= 0) {
            try {
                this.tableIndexes.getQuery().getRecord(this.tableIndexes.getSelectionModel().getLeadSelectionIndex());
                String objectName = SQLUtil.createSqlName((String)this.currentSchemaName, (String)this.tableIndexes.getQuery().fieldByName("index_name").getString(), (Database)this.getDatabase());
                if (MessageBox.show((Component)null, (String)this.stringManager.getString("deleting"), (String)String.format(this.stringManager.getString("TableIndexesPanel-drop-index-q"), objectName), (int[])ModalResult.YESNO) == 5) {
                    this.getDatabase().createCommand("drop index " + objectName, true);
                    this.timer.restart();
                }
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void formComponentShown(ComponentEvent evt) {
        this.refresh(null, this.currentSchemaName, this.currentTableName);
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }
}

