/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.hsqldb.gui.tables;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.hsqldb.OrbadaHSqlDbPlugin;
import pl.mpak.orbada.hsqldb.Sql;
import pl.mpak.orbada.hsqldb.services.HSqlDbInfoProvider;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.timer.Timer;

public class TableTriggersPanel
extends JPanel
implements ITabObjectInfo {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaHSqlDbPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName = "";
    private String currentTableName = "";
    private boolean requestRefresh = false;
    private SqlFilter filter;
    private Timer timer;
    private ToolButton buttonActions;
    private ToolButton buttonDropTrigger;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private Action cmDropTrigger;
    private Action cmFilter;
    private Action cmRefresh;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JSeparator jSeparator2;
    private JPopupMenu menuActions;
    private QueryTableStatusBar statusBarTriggers;
    private OrbadaSyntaxTextArea syntaxTrigger;
    private ViewTable tableTriggers;
    private JToolBar toolBarTriggers;

    public TableTriggersPanel(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.timer = new Timer(250L){
            {
                this.setEnabled(false);
            }

            public void run() {
                this.setEnabled(false);
                TableTriggersPanel.this.refresh();
            }
        };
        OrbadaHSqlDbPlugin.getRefreshQueue().add(this.timer);
        this.syntaxTrigger.setDatabase(this.getDatabase());
        this.syntaxTrigger.setEditable(false);
        this.tableTriggers.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int rowIndex = TableTriggersPanel.this.tableTriggers.getSelectedRow();
                if (rowIndex >= 0 && TableTriggersPanel.this.tableTriggers.getQuery().isActive()) {
                    try {
                        TableTriggersPanel.this.tableTriggers.getQuery().getRecord(rowIndex);
                        TableTriggersPanel.this.updateTriggerBody();
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                } else {
                    TableTriggersPanel.this.syntaxTrigger.setText("");
                }
            }
        });
        this.tableTriggers.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("trigger_name", this.stringManager.getString("trigger-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("trigger_type", this.stringManager.getString("when"), 120));
            this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("triggering_event", this.stringManager.getString("event"), 80));
            if (HSqlDbInfoProvider.getVersionTest(this.getDatabase()) == 108) {
                this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("status", this.stringManager.getString("status"), 80));
            }
            SqlFilterDef def = new SqlFilterDef();
            def.add(new SqlFilterDefComponent("trigger_name", this.stringManager.getString("trigger-name"), (String[])null));
            if (HSqlDbInfoProvider.getVersionTest(this.getDatabase()) == 108) {
                def.add(new SqlFilterDefComponent("status = 'DISABLED'", this.stringManager.getString("disabled")));
            }
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "derbydb-table-triggers-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableTriggers, (JButton)this.buttonActions, this.menuActions, "hsqldb-table-triggers-actions");
    }

    public void refresh() {
        try {
            this.requestRefresh = false;
            this.tableTriggers.getQuery().close();
            this.tableTriggers.getQuery().setSqlText(Sql.getTriggerList(this.filter.getSqlText(), HSqlDbInfoProvider.getVersionTest(this.getDatabase())));
            this.tableTriggers.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
            this.tableTriggers.getQuery().paramByName("table_name").setString(this.currentTableName);
            this.tableTriggers.getQuery().open();
            if (!this.tableTriggers.getQuery().isEmpty()) {
                this.tableTriggers.changeSelection(0, 0);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void updateTriggerBody() {
        try {
            this.syntaxTrigger.setText(this.tableTriggers.getQuery().fieldByName("source").getString());
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public String getTitle() {
        return this.stringManager.getString("TableTriggersPanel-title");
    }

    public void refresh(String catalogName, String schemaName, String objectName) {
        if (!this.currentSchemaName.equals(schemaName) || !this.currentTableName.equals(objectName) || this.requestRefresh) {
            this.currentSchemaName = schemaName;
            this.currentTableName = objectName;
            if (this.isVisible()) {
                this.timer.restart();
            } else {
                this.requestRefresh = true;
            }
        }
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.timer.cancel();
        this.tableTriggers.getQuery().close();
        this.syntaxTrigger.setDatabase(null);
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.cmDropTrigger = new Action();
        this.menuActions = new JPopupMenu();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableTriggers = new ViewTable();
        this.statusBarTriggers = new QueryTableStatusBar();
        this.syntaxTrigger = new OrbadaSyntaxTextArea();
        this.jPanel2 = new JPanel();
        this.toolBarTriggers = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator2 = new JSeparator();
        this.buttonDropTrigger = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableTriggersPanel.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableTriggersPanel.this.cmFilterActionPerformed(evt);
            }
        });
        this.cmDropTrigger.setActionCommandKey("cmDropTrigger");
        this.cmDropTrigger.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDropTrigger.setText(this.stringManager.getString("cmDropTrigger-text"));
        this.cmDropTrigger.setTooltip(this.stringManager.getString("cmDropTrigger-hint"));
        this.cmDropTrigger.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableTriggersPanel.this.cmDropTriggerActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                TableTriggersPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableTriggers);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.statusBarTriggers.setShowFieldType(false);
        this.statusBarTriggers.setShowOpenTime(false);
        this.statusBarTriggers.setTable((QueryTable)this.tableTriggers);
        this.jPanel1.add((Component)this.statusBarTriggers, "South");
        this.add((Component)this.jPanel1, "Center");
        this.syntaxTrigger.setPreferredSize(new Dimension(81, 150));
        this.add((Component)this.syntaxTrigger, "South");
        this.jPanel2.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarTriggers.setFloatable(false);
        this.toolBarTriggers.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.buttonRefresh);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.buttonFilter);
        this.jSeparator2.setOrientation(1);
        this.toolBarTriggers.add(this.jSeparator2);
        this.buttonDropTrigger.setAction((javax.swing.Action)this.cmDropTrigger);
        this.buttonDropTrigger.setHorizontalTextPosition(0);
        this.buttonDropTrigger.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.buttonDropTrigger);
        this.toolBarTriggers.add(this.jSeparator1);
        this.toolBarTriggers.add((Component)this.buttonActions);
        this.jPanel2.add(this.toolBarTriggers);
        this.add((Component)this.jPanel2, "North");
    }

    private void cmDropTriggerActionPerformed(ActionEvent evt) {
        if (this.tableTriggers.getSelectionModel().getLeadSelectionIndex() >= 0) {
            try {
                this.tableTriggers.getQuery().getRecord(this.tableTriggers.getSelectionModel().getLeadSelectionIndex());
                String objectName = SQLUtil.createSqlName((String)this.currentSchemaName, (String)this.tableTriggers.getQuery().fieldByName("trigger_name").getString(), (Database)this.getDatabase());
                String tableName = SQLUtil.createSqlName((String)this.currentSchemaName, (String)this.currentTableName, (Database)this.getDatabase());
                if (MessageBox.show((Component)null, (String)this.stringManager.getString("deleting"), (String)String.format(this.stringManager.getString("TableTriggersPanel-drop-trigger-q"), objectName, tableName), (int[])ModalResult.YESNO) == 5) {
                    this.getDatabase().createCommand("drop trigger " + objectName, true);
                    this.timer.restart();
                }
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void formComponentShown(ComponentEvent evt) {
        this.refresh(null, this.currentSchemaName, this.currentTableName);
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }
}

