/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.hsqldb.gui.triggers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.gui.util.SimpleSelectDialog;
import pl.mpak.orbada.hsqldb.OrbadaHSqlDbPlugin;
import pl.mpak.orbada.hsqldb.Sql;
import pl.mpak.orbada.hsqldb.services.HSqlDbInfoProvider;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.QueryUtil;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class TriggersPanelView
extends JPanel
implements IRootTabObjectInfo {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaHSqlDbPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName;
    private String tabTitle;
    private SqlFilter filter;
    private boolean viewClosing = false;
    private ToolButton buttonActions;
    private ToolButton buttonDropTrigger;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private ToolButton buttonSelectSchema;
    private Action cmDropTrigger;
    private Action cmFilter;
    private Action cmRefresh;
    private Action cmSelectSchema;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JSeparator jSeparator2;
    private JPopupMenu menuActions;
    private QueryTableStatusBar statusBarTriggers;
    private OrbadaSyntaxTextArea syntaxTrigger;
    private ViewTable tableTriggers;
    private JToolBar toolBarTriggers;

    public TriggersPanelView(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.tabTitle = this.accesibilities.getTabTitle();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.currentSchemaName = HSqlDbInfoProvider.getCurrentSchema(this.getDatabase());
        this.syntaxTrigger.setDatabase(this.getDatabase());
        this.syntaxTrigger.setEditable(false);
        this.tableTriggers.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int rowIndex = TriggersPanelView.this.tableTriggers.getSelectedRow();
                if (rowIndex >= 0 && TriggersPanelView.this.tableTriggers.getQuery().isActive()) {
                    try {
                        TriggersPanelView.this.tableTriggers.getQuery().getRecord(rowIndex);
                        TriggersPanelView.this.updateTriggerBody();
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                } else {
                    TriggersPanelView.this.syntaxTrigger.setText("");
                }
            }
        });
        this.tableTriggers.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("trigger_name", this.stringManager.getString("trigger-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("trigger_type", this.stringManager.getString("when"), 120));
            this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("triggering_event", this.stringManager.getString("event"), 80));
            this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("table_schema", this.stringManager.getString("table-schema"), 120));
            this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("object_type", this.stringManager.getString("object-type"), 100));
            this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("table_name", this.stringManager.getString("table-name"), 120));
            if (HSqlDbInfoProvider.getVersionTest(this.getDatabase()) == 108) {
                this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("status", this.stringManager.getString("status"), 80));
            }
            SqlFilterDef def = new SqlFilterDef();
            def.add(new SqlFilterDefComponent("trigger_name", this.stringManager.getString("trigger-name"), (String[])null));
            def.add(new SqlFilterDefComponent("table_schema", this.stringManager.getString("table-schema"), (String[])null));
            def.add(new SqlFilterDefComponent("object_type", this.stringManager.getString("object-type"), (String[])null));
            def.add(new SqlFilterDefComponent("table_name", this.stringManager.getString("table-name"), (String[])null));
            if (HSqlDbInfoProvider.getVersionTest(this.getDatabase()) == 108) {
                def.add(new SqlFilterDefComponent("status = 'DISABLED'", this.stringManager.getString("disabled")));
            }
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "derbydb-triggers-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableTriggers, (JButton)this.buttonActions, this.menuActions, "hsqldb-triggers-actions");
    }

    public void setCurrentSchemaName(String schemaName) {
        if (!this.currentSchemaName.equals(schemaName)) {
            this.currentSchemaName = schemaName;
            if (!this.currentSchemaName.equalsIgnoreCase(HSqlDbInfoProvider.getCurrentSchema(this.getDatabase()))) {
                this.accesibilities.setTabTitle(this.tabTitle + " (" + this.currentSchemaName + ")");
            } else {
                this.accesibilities.setTabTitle(this.tabTitle);
            }
        }
    }

    public void refresh() {
        if (!this.isVisible() || this.viewClosing) {
            return;
        }
        try {
            String triggerName = null;
            if (this.tableTriggers.getQuery().isActive() && this.tableTriggers.getSelectedRow() >= 0) {
                this.tableTriggers.getQuery().getRecord(this.tableTriggers.getSelectedRow());
                triggerName = this.tableTriggers.getQuery().fieldByName("TRIGGER_NAME").getString();
            }
            this.refresh(triggerName);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public void refresh(String objectName) {
        try {
            int index = Math.max(0, this.tableTriggers.getSelectedRow());
            this.tableTriggers.getQuery().close();
            this.tableTriggers.getQuery().setSqlText(Sql.getTriggerList(this.filter.getSqlText(), HSqlDbInfoProvider.getVersionTest(this.getDatabase())));
            this.tableTriggers.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
            this.tableTriggers.getQuery().open();
            if (objectName != null && this.tableTriggers.getQuery().locate("TRIGGER_NAME", new Variant(objectName))) {
                this.tableTriggers.changeSelection(this.tableTriggers.getQuery().getCurrentRecord().getIndex(), this.tableTriggers.getSelectedColumn());
            } else if (!this.tableTriggers.getQuery().isEmpty()) {
                this.tableTriggers.changeSelection(Math.min(index, this.tableTriggers.getRowCount() - 1), this.tableTriggers.getSelectedColumn());
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void updateTriggerBody() {
        try {
            this.syntaxTrigger.setText(this.tableTriggers.getQuery().fieldByName("source").getString());
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.viewClosing = true;
        this.tableTriggers.getQuery().close();
        this.syntaxTrigger.setDatabase(null);
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.cmDropTrigger = new Action();
        this.cmSelectSchema = new Action();
        this.menuActions = new JPopupMenu();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableTriggers = new ViewTable();
        this.statusBarTriggers = new QueryTableStatusBar();
        this.syntaxTrigger = new OrbadaSyntaxTextArea();
        this.jPanel2 = new JPanel();
        this.toolBarTriggers = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonSelectSchema = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator2 = new JSeparator();
        this.buttonDropTrigger = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TriggersPanelView.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TriggersPanelView.this.cmFilterActionPerformed(evt);
            }
        });
        this.cmDropTrigger.setActionCommandKey("cmDropTrigger");
        this.cmDropTrigger.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDropTrigger.setText(this.stringManager.getString("cmDropTrigger-text"));
        this.cmDropTrigger.setTooltip(this.stringManager.getString("cmDropTrigger-hint"));
        this.cmDropTrigger.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TriggersPanelView.this.cmDropTriggerActionPerformed(evt);
            }
        });
        this.cmSelectSchema.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/users16.gif"));
        this.cmSelectSchema.setText(this.stringManager.getString("cmSelectSchema-text"));
        this.cmSelectSchema.setTooltip(this.stringManager.getString("cmSelectSchema-hint"));
        this.cmSelectSchema.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TriggersPanelView.this.cmSelectSchemaActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                TriggersPanelView.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableTriggers);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.statusBarTriggers.setShowFieldType(false);
        this.statusBarTriggers.setShowOpenTime(false);
        this.statusBarTriggers.setTable((QueryTable)this.tableTriggers);
        this.jPanel1.add((Component)this.statusBarTriggers, "South");
        this.add((Component)this.jPanel1, "Center");
        this.syntaxTrigger.setPreferredSize(new Dimension(81, 150));
        this.add((Component)this.syntaxTrigger, "South");
        this.jPanel2.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarTriggers.setFloatable(false);
        this.toolBarTriggers.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.buttonRefresh);
        this.buttonSelectSchema.setAction((javax.swing.Action)this.cmSelectSchema);
        this.buttonSelectSchema.setHorizontalTextPosition(0);
        this.buttonSelectSchema.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.buttonSelectSchema);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.buttonFilter);
        this.jSeparator2.setOrientation(1);
        this.toolBarTriggers.add(this.jSeparator2);
        this.buttonDropTrigger.setAction((javax.swing.Action)this.cmDropTrigger);
        this.buttonDropTrigger.setHorizontalTextPosition(0);
        this.buttonDropTrigger.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.buttonDropTrigger);
        this.toolBarTriggers.add(this.jSeparator1);
        this.toolBarTriggers.add((Component)this.buttonActions);
        this.jPanel2.add(this.toolBarTriggers);
        this.add((Component)this.jPanel2, "North");
    }

    private void cmDropTriggerActionPerformed(ActionEvent evt) {
        if (this.tableTriggers.getSelectionModel().getLeadSelectionIndex() >= 0) {
            try {
                this.tableTriggers.getQuery().getRecord(this.tableTriggers.getSelectionModel().getLeadSelectionIndex());
                String objectName = SQLUtil.createSqlName((String)this.currentSchemaName, (String)this.tableTriggers.getQuery().fieldByName("trigger_name").getString(), (Database)this.getDatabase());
                String tableName = SQLUtil.createSqlName((String)this.tableTriggers.getQuery().fieldByName("table_schema").getString(), (String)this.tableTriggers.getQuery().fieldByName("table_name").getString(), (Database)this.getDatabase());
                if (MessageBox.show((Component)null, (String)this.stringManager.getString("deleting"), (String)String.format(this.stringManager.getString("TriggersPanelView-drop-trigger-q"), objectName, tableName), (int[])ModalResult.YESNO) == 5) {
                    this.getDatabase().createCommand("drop trigger " + objectName, true);
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void formComponentShown(ComponentEvent evt) {
        if (!this.tableTriggers.getQuery().isActive()) {
            this.refresh();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmSelectSchemaActionPerformed(ActionEvent evt) {
        Query query = this.getDatabase().createQuery();
        try {
            query.open(Sql.getSchemaList());
            Vector vl = QueryUtil.staticData((String)"{schema_name}", (Query)query);
            Point point = this.buttonSelectSchema.getLocationOnScreen();
            point.y += this.buttonSelectSchema.getHeight();
            SimpleSelectDialog.select((Window)SwingUtil.getWindowComponent((Component)this), (int)point.x, (int)point.y, (Vector)vl, (int)vl.indexOf(this.currentSchemaName), (SimpleSelectDialog.CallBack)new SimpleSelectDialog.CallBack(){

                public void selected(Object o) {
                    TriggersPanelView.this.setCurrentSchemaName(o.toString());
                    TriggersPanelView.this.refresh();
                }
            });
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
    }
}

