/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.hsqldb.gui.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.hsqldb.OrbadaHSqlDbPlugin;
import pl.mpak.orbada.hsqldb.Sql;
import pl.mpak.orbada.hsqldb.services.HSqlDbInfoProvider;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.script.SQLScript;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.timer.Timer;

public class ViewSourcePanel
extends JPanel
implements ITabObjectInfo {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaHSqlDbPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName = "";
    private String currentViewName = "";
    private boolean requestRefresh = false;
    private Timer timer;
    private ToolButton buttonActions;
    private ToolButton buttonCompile;
    private ToolButton buttonRefresh;
    private Action cmCompileView;
    private Action cmRefreshSource;
    private JToolBar.Separator jSeparator1;
    private JPopupMenu menuActions;
    private OrbadaSyntaxTextArea syntaxViewSource;
    private JToolBar toolBarContent;

    public ViewSourcePanel(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    private void setEditorText(final String text) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ViewSourcePanel.this.syntaxViewSource.setText(text);
            }
        });
    }

    private void init() {
        this.timer = new Timer(250L){
            {
                this.setEnabled(false);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                this.setEnabled(false);
                ViewSourcePanel.this.requestRefresh = false;
                Query query = ViewSourcePanel.this.getDatabase().createQuery();
                try {
                    query.setSqlText(Sql.getViewSource(HSqlDbInfoProvider.getVersionTest(ViewSourcePanel.this.getDatabase())));
                    query.paramByName("schema_name").setString(ViewSourcePanel.this.currentSchemaName);
                    query.paramByName("view_name").setString(ViewSourcePanel.this.currentViewName);
                    query.open();
                    if (!query.eof()) {
                        ViewSourcePanel.this.setEditorText("drop view " + SQLUtil.createSqlName((String)ViewSourcePanel.this.currentSchemaName, (String)ViewSourcePanel.this.currentViewName) + "\n/\n" + "create view " + SQLUtil.createSqlName((String)ViewSourcePanel.this.currentSchemaName, (String)ViewSourcePanel.this.currentViewName) + " as\n" + query.fieldByName("view_definition").getString() + "\n/");
                    } else {
                        ViewSourcePanel.this.setEditorText("");
                    }
                    ViewSourcePanel.this.syntaxViewSource.getStatusBar().getPanel("view-status").setText(" ");
                }
                catch (Exception ex) {
                    ExceptionUtil.processException((Throwable)ex);
                }
                finally {
                    query.close();
                }
            }
        };
        SwingUtil.addAction((JComponent)this.syntaxViewSource.getEditorArea(), (javax.swing.Action)this.cmCompileView);
        this.syntaxViewSource.getStatusBar().addPanel("view-status").setText(" ");
        this.syntaxViewSource.setDatabase(this.getDatabase());
        OrbadaHSqlDbPlugin.getRefreshQueue().add(this.timer);
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.syntaxViewSource.getEditorArea(), (JButton)this.buttonActions, this.menuActions, "hsqldb-view-source-actions");
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public String getTitle() {
        return this.stringManager.getString("ViewSourcePanel-title");
    }

    public void refresh() {
        this.refresh(null, this.currentSchemaName, this.currentViewName);
    }

    public void refresh(String catalogName, String schemaName, String objectName) {
        if (!this.currentSchemaName.equals(schemaName) || !this.currentViewName.equals(objectName) || this.requestRefresh) {
            this.currentSchemaName = schemaName;
            this.currentViewName = objectName;
            if (this.isVisible()) {
                this.timer.restart();
            } else {
                this.requestRefresh = true;
                this.setEditorText("");
            }
        }
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.timer.cancel();
        this.syntaxViewSource.setDatabase(null);
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefreshSource = new Action();
        this.cmCompileView = new Action();
        this.menuActions = new JPopupMenu();
        this.toolBarContent = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonCompile = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.syntaxViewSource = new OrbadaSyntaxTextArea();
        this.cmRefreshSource.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefreshSource.setText(this.stringManager.getString("cmRefreshSource-text"));
        this.cmRefreshSource.setTooltip(this.stringManager.getString("cmRefreshSource-hint"));
        this.cmRefreshSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewSourcePanel.this.cmRefreshSourceActionPerformed(evt);
            }
        });
        this.cmCompileView.setShortCut(KeyStroke.getKeyStroke(10, 2));
        this.cmCompileView.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/execute_script16.gif"));
        this.cmCompileView.setText(this.stringManager.getString("cmCompileView-text"));
        this.cmCompileView.setTooltip(this.stringManager.getString("cmCompileView-hint"));
        this.cmCompileView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewSourcePanel.this.cmCompileViewActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                ViewSourcePanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.toolBarContent.setFloatable(false);
        this.toolBarContent.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefreshSource);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarContent.add((Component)this.buttonRefresh);
        this.buttonCompile.setAction((javax.swing.Action)this.cmCompileView);
        this.buttonCompile.setHorizontalTextPosition(0);
        this.buttonCompile.setVerticalTextPosition(3);
        this.toolBarContent.add((Component)this.buttonCompile);
        this.toolBarContent.add(this.jSeparator1);
        this.toolBarContent.add((Component)this.buttonActions);
        this.add((Component)this.toolBarContent, "First");
        this.add((Component)this.syntaxViewSource, "Center");
    }

    private void cmCompileViewActionPerformed(ActionEvent evt) {
        if (MessageBox.show((Component)null, (String)this.stringManager.getString("script"), (String)this.stringManager.getString("ViewSourcePanel-exec-script-q"), (int[])ModalResult.YESNO) != 5) {
            return;
        }
        try {
            this.getDatabase().executeScript(this.syntaxViewSource.getText());
            SQLScript script = new SQLScript(this.getDatabase());
            this.syntaxViewSource.getStatusBar().getPanel("view-status").setText(this.stringManager.getString("executed-correctly"));
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            this.syntaxViewSource.getStatusBar().getPanel("view-status").setText(ex.getMessage());
        }
    }

    private void formComponentShown(ComponentEvent evt) {
        this.refresh(null, this.currentSchemaName, this.currentViewName);
    }

    private void cmRefreshSourceActionPerformed(ActionEvent evt) {
        this.timer.restart();
    }
}

