/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.hsqldb.gui.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.Closeable;
import java.io.IOException;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.ContentPanel;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.gui.util.SimpleSelectDialog;
import pl.mpak.orbada.hsqldb.OrbadaHSqlDbPlugin;
import pl.mpak.orbada.hsqldb.Sql;
import pl.mpak.orbada.hsqldb.gui.views.ViewColumnPrivilegesPanel;
import pl.mpak.orbada.hsqldb.gui.views.ViewColumnUsagePanel;
import pl.mpak.orbada.hsqldb.gui.views.ViewColumnsPanel;
import pl.mpak.orbada.hsqldb.gui.views.ViewPrivilegesPanel;
import pl.mpak.orbada.hsqldb.gui.views.ViewRoutineUsagePanel;
import pl.mpak.orbada.hsqldb.gui.views.ViewSourcePanel;
import pl.mpak.orbada.hsqldb.services.HSqlDbInfoProvider;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.TabCloseComponent;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.QueryUtil;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.Titleable;
import pl.mpak.util.variant.Variant;

public class ViewsPanelView
extends JPanel
implements IRootTabObjectInfo {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaHSqlDbPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName;
    private String tabTitle;
    private SqlFilter filter;
    private boolean viewClosing = false;
    private ToolButton buttonActions;
    private ToolButton buttonDtopTable;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private ToolButton buttonSelectSchema;
    private Action cmDropView;
    private Action cmFilter;
    private Action cmRefresh;
    private Action cmSelectSchema;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JPopupMenu menuActions;
    private JPanel panelTables;
    private JSplitPane splinPane;
    private QueryTableStatusBar statusBarTables;
    private JTabbedPane tabbedTableInfo;
    private ViewTable tableViews;
    private JToolBar toolBarTables;

    public ViewsPanelView(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.tabTitle = this.accesibilities.getTabTitle();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.currentSchemaName = HSqlDbInfoProvider.getCurrentSchema(this.getDatabase());
        this.tableViews.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                String tableName = "";
                int rowIndex = ViewsPanelView.this.tableViews.getSelectedRow();
                if (rowIndex >= 0 && ViewsPanelView.this.tableViews.getQuery().isActive()) {
                    try {
                        ViewsPanelView.this.tableViews.getQuery().getRecord(rowIndex);
                        tableName = ViewsPanelView.this.tableViews.getQuery().fieldByName("view_name").getString();
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                }
                for (int i = 0; i < ViewsPanelView.this.tabbedTableInfo.getTabCount(); ++i) {
                    Component c = ViewsPanelView.this.tabbedTableInfo.getComponentAt(i);
                    if (!(c instanceof ITabObjectInfo)) continue;
                    ((ITabObjectInfo)c).refresh(null, ViewsPanelView.this.currentSchemaName, tableName);
                }
            }
        });
        this.addInfoPanel(new ViewColumnsPanel(this.accesibilities));
        this.addInfoPanel(new ViewSourcePanel(this.accesibilities));
        this.addInfoPanel(new ViewColumnUsagePanel(this.accesibilities));
        this.addInfoPanel(new ViewRoutineUsagePanel(this.accesibilities));
        this.addInfoPanel(new ViewPrivilegesPanel(this.accesibilities));
        this.addInfoPanel(new ViewColumnPrivilegesPanel(this.accesibilities));
        this.addInfoPanel((JPanel)new ContentPanel(this.accesibilities));
        this.tableViews.getQuery().setDatabase(this.getDatabase());
        this.tableViews.addColumn((TableColumn)new QueryTableColumn("view_name", this.stringManager.getString("view-name"), 130, (TableCellRenderer)new QueryTableCellRenderer(1)));
        if (HSqlDbInfoProvider.getVersionTest(this.getDatabase()) == 108) {
            this.tableViews.addColumn((TableColumn)new QueryTableColumn("status", this.stringManager.getString("status"), 80));
        }
        this.tableViews.addColumn((TableColumn)new QueryTableColumn("is_updatable", this.stringManager.getString("is-updatable"), 50));
        this.tableViews.addColumn((TableColumn)new QueryTableColumn("check_option", this.stringManager.getString("check-option"), 70));
        SqlFilterDef def = new SqlFilterDef();
        def.add(new SqlFilterDefComponent("v.table_name", this.stringManager.getString("view-name"), (String[])null));
        def.add(new SqlFilterDefComponent("not v.valid", this.stringManager.getString("not-valid")));
        this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "hsqldb-views-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableViews, (JButton)this.buttonActions, this.menuActions, "hsqldb-views-actions");
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ViewsPanelView.this.tableViews.requestFocusInWindow();
            }
        });
    }

    public void setCurrentSchemaName(String schemaName) {
        if (!this.currentSchemaName.equals(schemaName)) {
            this.currentSchemaName = schemaName;
            if (!this.currentSchemaName.equalsIgnoreCase(HSqlDbInfoProvider.getCurrentSchema(this.getDatabase()))) {
                this.accesibilities.setTabTitle(this.tabTitle + " (" + this.currentSchemaName + ")");
            } else {
                this.accesibilities.setTabTitle(this.tabTitle);
            }
        }
    }

    public void refresh() {
        if (!this.isVisible() || this.viewClosing) {
            return;
        }
        try {
            String tableName = null;
            if (this.tableViews.getQuery().isActive() && this.tableViews.getSelectedRow() >= 0) {
                this.tableViews.getQuery().getRecord(this.tableViews.getSelectedRow());
                tableName = this.tableViews.getQuery().fieldByName("VIEW_NAME").getString();
            }
            this.refresh(tableName);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public void refresh(String objectName) {
        try {
            int index = Math.max(0, this.tableViews.getSelectedRow());
            this.tableViews.getQuery().close();
            this.tableViews.getQuery().setSqlText(Sql.getViewList(this.filter.getSqlText(), HSqlDbInfoProvider.getVersionTest(this.getDatabase())));
            this.tableViews.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
            this.tableViews.getQuery().open();
            if (objectName != null && this.tableViews.getQuery().locate("VIEW_NAME", new Variant(objectName))) {
                this.tableViews.changeSelection(this.tableViews.getQuery().getCurrentRecord().getIndex(), this.tableViews.getSelectedColumn());
            } else if (!this.tableViews.getQuery().isEmpty()) {
                this.tableViews.changeSelection(Math.min(index, this.tableViews.getRowCount() - 1), this.tableViews.getSelectedColumn());
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void addInfoPanel(JPanel panel) {
        this.tabbedTableInfo.addTab(((Titleable)panel).getTitle(), panel);
        this.tabbedTableInfo.setTabComponentAt(this.tabbedTableInfo.indexOfComponent(panel), (Component)new TabCloseComponent(((Titleable)panel).getTitle()));
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.viewClosing = true;
        int i = 0;
        while (i < this.tabbedTableInfo.getTabCount()) {
            Component c = this.tabbedTableInfo.getComponentAt(i);
            if (c instanceof Closeable) {
                try {
                    ((Closeable)((Object)c)).close();
                }
                catch (IOException iOException) {}
            } else {
                ++i;
            }
            this.tabbedTableInfo.remove(c);
        }
        this.tableViews.getQuery().close();
        this.accesibilities = null;
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmSelectSchema = new Action();
        this.cmFilter = new Action();
        this.cmDropView = new Action();
        this.menuActions = new JPopupMenu();
        this.splinPane = new JSplitPane();
        this.panelTables = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableViews = new ViewTable();
        this.statusBarTables = new QueryTableStatusBar();
        this.jPanel1 = new JPanel();
        this.toolBarTables = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonSelectSchema = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator1 = new JSeparator();
        this.buttonDtopTable = new ToolButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.tabbedTableInfo = new JTabbedPane();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewsPanelView.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmSelectSchema.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/users16.gif"));
        this.cmSelectSchema.setText(this.stringManager.getString("cmSelectSchema-text"));
        this.cmSelectSchema.setTooltip(this.stringManager.getString("cmSelectSchema-hint"));
        this.cmSelectSchema.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewsPanelView.this.cmSelectSchemaActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/filter16.gif"));
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewsPanelView.this.cmFilterActionPerformed(evt);
            }
        });
        this.cmDropView.setActionCommandKey("cmDropView");
        this.cmDropView.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDropView.setText(this.stringManager.getString("cmDropView-text"));
        this.cmDropView.setTooltip(this.stringManager.getString("cmDropView-hint"));
        this.cmDropView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewsPanelView.this.cmDropViewActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                ViewsPanelView.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.splinPane.setBorder(null);
        this.splinPane.setDividerLocation(200);
        this.splinPane.setContinuousLayout(true);
        this.splinPane.setOneTouchExpandable(true);
        this.panelTables.setPreferredSize(new Dimension(250, 100));
        this.panelTables.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableViews);
        this.panelTables.add((Component)this.jScrollPane1, "Center");
        this.statusBarTables.setShowFieldType(false);
        this.statusBarTables.setShowFieldValue(false);
        this.statusBarTables.setShowOpenTime(false);
        this.statusBarTables.setTable((QueryTable)this.tableViews);
        this.panelTables.add((Component)this.statusBarTables, "Last");
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarTables.setFloatable(false);
        this.toolBarTables.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonRefresh);
        this.buttonSelectSchema.setAction((javax.swing.Action)this.cmSelectSchema);
        this.buttonSelectSchema.setHorizontalTextPosition(0);
        this.buttonSelectSchema.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonSelectSchema);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonFilter);
        this.jSeparator1.setOrientation(1);
        this.toolBarTables.add(this.jSeparator1);
        this.buttonDtopTable.setAction((javax.swing.Action)this.cmDropView);
        this.buttonDtopTable.setHorizontalTextPosition(0);
        this.buttonDtopTable.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonDtopTable);
        this.toolBarTables.add(this.jSeparator2);
        this.toolBarTables.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBarTables);
        this.panelTables.add((Component)this.jPanel1, "North");
        this.splinPane.setLeftComponent(this.panelTables);
        this.tabbedTableInfo.setFocusable(false);
        this.splinPane.setRightComponent(this.tabbedTableInfo);
        this.add((Component)this.splinPane, "Center");
    }

    private void cmDropViewActionPerformed(ActionEvent evt) {
        if (this.tableViews.getSelectionModel().getLeadSelectionIndex() >= 0) {
            try {
                this.tableViews.getQuery().getRecord(this.tableViews.getSelectionModel().getLeadSelectionIndex());
                String objectName = SQLUtil.createSqlName((String)this.currentSchemaName, (String)this.tableViews.getQuery().fieldByName("view_name").getString(), (Database)this.getDatabase());
                if (MessageBox.show((Component)this, (String)this.stringManager.getString("deleting"), (String)String.format(this.stringManager.getString("ViewsPanelView-drop-view-q"), objectName), (int[])ModalResult.YESNO, (int)3) == 5) {
                    this.getDatabase().createCommand("drop view " + objectName, true);
                    this.refresh(null);
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    private void formComponentShown(ComponentEvent evt) {
        if (!this.tableViews.getQuery().isActive()) {
            this.refresh();
        }
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmSelectSchemaActionPerformed(ActionEvent evt) {
        Query query = this.getDatabase().createQuery();
        try {
            query.open(Sql.getSchemaList());
            Vector vl = QueryUtil.staticData((String)"{schema_name}", (Query)query);
            Point point = this.buttonSelectSchema.getLocationOnScreen();
            point.y += this.buttonSelectSchema.getHeight();
            SimpleSelectDialog.select((Window)SwingUtil.getWindowComponent((Component)this), (int)point.x, (int)point.y, (Vector)vl, (int)vl.indexOf(this.currentSchemaName), (SimpleSelectDialog.CallBack)new SimpleSelectDialog.CallBack(){

                public void selected(Object o) {
                    ViewsPanelView.this.setCurrentSchemaName(o.toString());
                    ViewsPanelView.this.refresh();
                }
            });
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }
}

