/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.hsqldb.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.hsqldb.OrbadaHSqlDbPlugin;
import pl.mpak.orbada.universal.gui.util.SchemaComboBoxModel;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class AlterUserSchemaWizardPanel
extends SqlCodeWizardPanel {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaHSqlDbPlugin.class);
    private Database database;
    private String schemaName;
    private String userName;
    private JComboBox comboSchemas;
    private JLabel jLabel2;

    public AlterUserSchemaWizardPanel(Database database, String schemaName) {
        this.database = database;
        this.schemaName = schemaName;
        this.initComponents();
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Query query = this.database.createQuery();
        try {
            query.open("select user() user_name from dual");
            this.userName = query.fieldByName("user_name").getString();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
        this.comboSchemas.setModel(new SchemaComboBoxModel(this.database));
    }

    public void wizardShow() {
        ((SchemaComboBoxModel)this.comboSchemas.getModel()).change();
        ((SchemaComboBoxModel)this.comboSchemas.getModel()).select(this.schemaName, this.comboSchemas);
    }

    public String getDialogTitle() {
        return this.stringManager.getString("AlterUserSchemaWizardPanel-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("AlterUserSchemaWizardPanel-tab-title");
    }

    public String getSqlCode() {
        return "ALTER USER \"" + this.userName + "\" SET INITIAL SCHEMA " + SQLUtil.createSqlName((String)this.comboSchemas.getSelectedItem().toString());
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.comboSchemas = new JComboBox();
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("schema-dd"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboSchemas, 0, 246, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.comboSchemas, -2, 22, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

