/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.hsqldb.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.hsqldb.OrbadaHSqlDbPlugin;
import pl.mpak.orbada.universal.gui.util.SchemaComboBoxModel;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class RevokeClassWizardPanel
extends SqlCodeWizardPanel {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaHSqlDbPlugin.class);
    private Database database;
    private String schemaName;
    private JComboBox comboClass;
    private JComboBox comboSchemas;
    private JLabel jLabel2;
    private JLabel jLabel3;

    public RevokeClassWizardPanel(Database database, String schemaName) {
        this.database = database;
        this.schemaName = schemaName;
        this.initComponents();
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Query query = this.database.createQuery();
        try {
            ArrayList<String> list = new ArrayList<String>();
            query.setSqlText("select distinct procedure_name object_name from information_schema.SYSTEM_PROCEDURES\n where origin <> 'ALIAS'\n   and procedure_schem = :SCHEMA_NAME\nunion\nselect distinct object_name from information_schema.SYSTEM_ALIASES\n where object_type = 'ROUTINE'\n   and object_schem = :SCHEMA_NAME\n order by object_name");
            query.paramByName("schema_name").setString(this.schemaName);
            query.open();
            while (!query.eof()) {
                String clazz = query.fieldByName("object_name").getString();
                if (list.indexOf(clazz = clazz.substring(0, clazz.lastIndexOf(46))) == -1) {
                    list.add(clazz);
                }
                query.next();
            }
            for (String item : list) {
                this.comboClass.addItem(item);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
        this.comboSchemas.setModel(new SchemaComboBoxModel(this.database));
    }

    public void wizardShow() {
        ((SchemaComboBoxModel)this.comboSchemas.getModel()).change();
        ((SchemaComboBoxModel)this.comboSchemas.getModel()).select(this.schemaName, this.comboSchemas);
    }

    public String getDialogTitle() {
        return this.stringManager.getString("RevokeClassWizardPanel-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("RevokeClassWizardPanel-tab-title");
    }

    public String getSqlCode() {
        return "REVOKE ALL ON CLASS \"" + this.comboClass.getSelectedItem().toString() + "\" FROM " + SQLUtil.createSqlName((String)this.comboSchemas.getSelectedItem().toString());
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.comboClass = new JComboBox();
        this.jLabel2 = new JLabel();
        this.comboSchemas = new JComboBox();
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("class-dd"));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("schema-dd"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboClass, 0, 246, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboSchemas, 0, 246, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.comboClass, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.comboSchemas, -2, 22, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

