/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.hsqldb.services;

import java.awt.Component;
import java.sql.SQLException;
import java.util.EventObject;
import java.util.HashMap;
import pl.mpak.orbada.hsqldb.OrbadaHSqlDbPlugin;
import pl.mpak.orbada.hsqldb.Sql;
import pl.mpak.orbada.hsqldb.dbinfo.HSqlDatabaseInfo;
import pl.mpak.orbada.plugins.dbinfo.DbDatabaseInfo;
import pl.mpak.orbada.plugins.dbinfo.DbObjectContainer;
import pl.mpak.orbada.plugins.providers.DatabaseInfoProvider;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.DatabaseListener;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.id.VersionID;

public class HSqlDbInfoProvider
extends DatabaseInfoProvider {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaHSqlDbPlugin.class);
    public static HSqlDbInfoProvider instance;
    private HashMap<String, DbDatabaseInfo> databaseInfoList;
    public static final int hsqlDbVerMultipier = 100;
    public static final int hsqlDb18 = 108;
    public static final int hsqlDb20 = 200;

    public HSqlDbInfoProvider() {
        instance = this;
    }

    public String getDescription() {
        return this.stringManager.getString("HSqlDbInfoProvider-description");
    }

    public boolean isForDatabase(Database database) {
        if (database == null) {
            return false;
        }
        return "HSQLDB".equals(database.getDriverType());
    }

    private String getUniqueName(Database database) {
        return database.getUniqueID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCurrentSchema(Database database) {
        Query query = database.createQuery();
        try {
            query.open(Sql.getCurrentSchema(HSqlDbInfoProvider.getVersionTest(database)));
            String string = query.fieldByName("schema_name").getString();
            return string;
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            String string = "";
            return string;
        }
        finally {
            query.close();
        }
    }

    public static int getVersionTest(Database database) {
        VersionID vid = new VersionID(database.getUserProperties().getProperty("version", "0"));
        return vid.getMajor() * 100 + vid.getMinor();
    }

    public void resetDatabaseInfo(Database database) {
        this.databaseInfoList.remove(this.getUniqueName(database));
    }

    public String[] getKeywords(Database database) {
        try {
            String[] list = new String[]{"ALLOCATE", "ALTER", "ANY", "ARE", "ASC", "ASSERTION", "ADD", "AT", "AUTHORIZATION", "BEGIN", "BIT", "BOTH", "BY", "CALL", "CASCADE", "CASCADED", "CASE", "CAST", "CHECK", "CLOSE", "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMIT", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONTINUE", "CONVERT", "CORRESPONDING", "CREATE", "CURRENT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DEALLOCATE", "DEC", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DESC", "DESCRIBE", "DIAGNOSTICS", "DISCONNECT", "DISTINCT", "DROP", "ELSE", "END", "ESCAPE", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXPLAIN", "EXTERNAL", "FALSE", "FETCH", "FIRST", "FOR", "FOREIGN", "FOUND", "FROM", "FULL", "FUNCTION", "GET", "GETCURRENTCONNECTION", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "HAVING", "HOUR", "IDENTITY", "IMMEDIATE", "INDICATOR", "INITIALLY", "INNER", "INOUT", "INPUT", "INSENSITIVE", "INSERT", "INT", "INDEX", "INTERSECT", "INTO", "IS", "ISOLATION", "JOIN", "KEY", "LAST", "LEFT", "MATCH", "NATIONAL", "NATURAL", "NEXT", "NO", "NULL", "OF", "ON", "ONLY", "OPEN", "OPTION", "ORDER", "OUTER", "OUTPUT", "OVERLAPS", "PAD", "PARTIAL", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURE", "PUBLIC", "READ", "REAL", "REFERENCES", "RELATIVE", "RESTRICT", "REVOKE", "RIGHT", "ROLLBACK", "ROWS", "RTRIM", "SCHEMA", "SCROLL", "SECOND", "SELECT", "SESSION_USER", "SET", "SMALLINT", "SOME", "SPACE", "SQL", "SQLCODE", "SQLERROR", "SQLSTATE", "SUBSTR", "SUBSTRING", "SYSTEM_USER", "TABLE", "TEMPORARY", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRANSACTION", "TRANSLATE", "TRANSLATION", "TRUE", "UNION", "UNIQUE", "UNKNOWN", "UPDATE", "USING", "VALUES", "VARYING", "VIEW", "WHENEVER", "WHERE", "WITH", "WHEN", "WORK", "WRITE", "XML", "XMLEXISTS", "XMLPARSE", "XMLQUERY", "XMLSERIALIZE", "TRIGGER", "AFTER", "BEFORE", "REFERENCING", "EACH", "ROW", "MODE", "DB2SQL", "THEN", "OUT", "LANGUAGE", "JAVA", "PARAMETER", "STYLE", "READS", "NAME", "RESULT", "SETS", "DYNAMIC", "ROLE", "SHUTDOWN", "COMPACT", "CLASS", "SEQUENCE", "SCRIPT", "AS", "AND", "OR"};
            StringUtil.unionList((String[])list, (String[])StringUtil.tokenizeList((String)database.getMetaData().getSQLKeywords(), (String)", "));
            return list;
        }
        catch (SQLException ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public String[] getOperators(Database database) {
        String[] list = new String[]{"ALL", "ANY", "BETWEEN", "IN", "IS", "LIKE", "NOT", "EXISTS"};
        return list;
    }

    public String[] getContainerList(DbObjectContainer list) {
        if (list != null) {
            return list.namesArray();
        }
        return new String[0];
    }

    public String[] getUserTables(Database database) {
        String[] tableList = this.getContainerList((DbObjectContainer)this.getDatabaseInfo(database).getObjectInfo("/SCHEMAS/" + HSqlDbInfoProvider.getCurrentSchema(database) + "/TABLES"));
        String[] viewList = this.getContainerList((DbObjectContainer)this.getDatabaseInfo(database).getObjectInfo("/SCHEMAS/" + HSqlDbInfoProvider.getCurrentSchema(database) + "/VIEWS"));
        return StringUtil.unionList((String[])tableList, (String[])viewList);
    }

    public String[] getExceptions(Database database) {
        return null;
    }

    public String[] getSqlFunctions(Database database) {
        try {
            String[] list = new String[]{"AVG", "ABS", "ABSVAL", "ACOS", "ASIN", "ATAN", "CAST", "CEIL", "CEILING", "COUNT", "COS", "NULLIF", "CASE", "CURRENT_DATE", "CURRENT", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "DATE", "DAY", "DEGREES", "DOUBLE", "EXP", "FLOOR", "HOUR", "IDENTITY_VAL_LOCAL", "LENGTH", "LN", "LOG", "LOG10", "LOCATE", "LCASE", "LOWER", "LTRIM", "MINUTE", "MOD", "MONTH", "PI", "RADIANS", "RTRIM", "SECOND", "SESSION_USER", "SIN", "SMALLINT", "SQRT", "SUBSTR", "TAN", "UCASE", "UPPER", "USER", "YEAR", "MAX", "MIN"};
            list = StringUtil.unionList((String[])list, (String[])StringUtil.tokenizeList((String)database.getMetaData().getStringFunctions(), (String)", "));
            list = StringUtil.unionList((String[])list, (String[])StringUtil.tokenizeList((String)database.getMetaData().getTimeDateFunctions(), (String)", "));
            list = StringUtil.unionList((String[])list, (String[])StringUtil.tokenizeList((String)database.getMetaData().getNumericFunctions(), (String)", "));
            list = StringUtil.unionList((String[])list, (String[])StringUtil.tokenizeList((String)database.getMetaData().getSystemFunctions(), (String)", "));
            return list;
        }
        catch (SQLException ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public String[] getUserFunctions(Database database) {
        String[] funcList = null;
        if (HSqlDbInfoProvider.getVersionTest(database) == 108) {
            funcList = this.getContainerList((DbObjectContainer)this.getDatabaseInfo(database).getObjectInfo("/SCHEMAS/" + HSqlDbInfoProvider.getCurrentSchema(database) + "/ALIASES"));
        }
        return funcList;
    }

    public String[] getPublicTables(Database database) {
        String[] tableList = this.getContainerList((DbObjectContainer)this.getDatabaseInfo(database).getObjectInfo("/SCHEMAS/INFORMATION_SCHEMA/TABLES"));
        String[] viewList = this.getContainerList((DbObjectContainer)this.getDatabaseInfo(database).getObjectInfo("/SCHEMAS/INFORMATION_SCHEMA/VIEWS"));
        return StringUtil.unionList((String[])tableList, (String[])viewList);
    }

    public String[] getDataTypes(Database database) {
        String[] types = this.getContainerList((DbObjectContainer)this.getDatabaseInfo(database).getObjectInfo("/TYPES"));
        return types;
    }

    public String[] getSchemas(Database database) {
        String[] schemas = this.getContainerList((DbObjectContainer)this.getDatabaseInfo(database).getObjectInfo("/SCHEMAS"));
        return schemas;
    }

    public String[] getTableTypes(Database database) {
        String[] tableTypes = this.getContainerList((DbObjectContainer)this.getDatabaseInfo(database).getObjectInfo("/TABLE TYPES"));
        return tableTypes;
    }

    public Component[] getExtendedPanelInfo(Database database) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbDatabaseInfo getDatabaseInfo(final Database database) {
        HSqlDbInfoProvider hSqlDbInfoProvider = this;
        synchronized (hSqlDbInfoProvider) {
            DbDatabaseInfo info;
            if (this.databaseInfoList == null) {
                this.databaseInfoList = new HashMap();
            }
            if ((info = this.databaseInfoList.get(this.getUniqueName(database))) == null) {
                info = new HSqlDatabaseInfo(database);
                this.databaseInfoList.put(this.getUniqueName(database), info);
                database.addDatabaseListener(new DatabaseListener(){

                    public void beforeConnect(EventObject e) {
                    }

                    public void afterConnect(EventObject e) {
                    }

                    public void beforeDisconnect(EventObject e) {
                    }

                    public void afterDisconnect(EventObject e) {
                        HSqlDbInfoProvider.this.databaseInfoList.remove(HSqlDbInfoProvider.this.getUniqueName(database));
                    }
                });
            }
            return info;
        }
    }

    public String getGroupName() {
        return "HSQLDB";
    }
}

