/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.hsqldb.services;

import pl.mpak.orbada.hsqldb.OrbadaHSqlDbPlugin;
import pl.mpak.orbada.hsqldb.services.HSqlDbInfoProvider;
import pl.mpak.orbada.plugins.providers.DatabaseProvider;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class HsqlDbDatabaseProvider
extends DatabaseProvider {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaHSqlDbPlugin.class);

    public boolean isForDatabase(Database database) {
        if (database == null) {
            return false;
        }
        return "HSQLDB".equals(database.getDriverType());
    }

    public void afterConnection(Database database) {
        database.getUserProperties().put("session-admin-role", "true");
        String version = HSqlDbInfoProvider.instance.getDatabaseInfo(database).getVersion();
        database.getUserProperties().put("version", version);
        database.getUserProperties().put("HSQLDB2.0+", HSqlDbInfoProvider.getVersionTest(database) >= 200 ? "true" : "false");
        database.getUserProperties().put("HSQLDB1.8+", HSqlDbInfoProvider.getVersionTest(database) >= 108 ? "true" : "false");
    }

    public void beforeDisconnect(Database database) {
    }

    public String getDescription() {
        return this.stringManager.getString("HsqlDbDatabaseProvider-description");
    }

    public String getGroupName() {
        return "HSQLDB";
    }
}

