/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.hsqldb.services;

import java.awt.Component;
import javax.swing.Icon;
import pl.mpak.orbada.hsqldb.OrbadaHSqlDbPlugin;
import pl.mpak.orbada.hsqldb.gui.dba.SessionsPanelView;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class HsqlDbSessionsView
extends ViewProvider {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaHSqlDbPlugin.class);

    public Component createView(IViewAccesibilities accesibilities) {
        return new SessionsPanelView(accesibilities);
    }

    public String getPublicName() {
        return this.stringManager.getString("HsqlDbSessionsView-public-name");
    }

    public String getViewId() {
        return "orbada-hsqldb-sessions-view";
    }

    public Icon getIcon() {
        return ImageManager.getImage((String)"/pl/mpak/res/icons/sessions.gif");
    }

    public boolean isForDatabase(Database database) {
        if (database == null) {
            return false;
        }
        boolean result = "HSQLDB".equals(database.getDriverType());
        if (result && !StringUtil.toBoolean((String)database.getUserProperties().getProperty("session-admin-role"))) {
            result = false;
        }
        return result;
    }

    public String getDescription() {
        return this.stringManager.getString("HsqlDbSessionsView-description");
    }

    public String getGroupName() {
        return "HSQLDB";
    }

    public String[] getSubmenu() {
        return null;
    }
}

