/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.hsqldb.services;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import pl.mpak.orbada.hsqldb.OrbadaHSqlDbPlugin;
import pl.mpak.orbada.hsqldb.Sql;
import pl.mpak.orbada.hsqldb.gui.aliases.ProcedureParametersPanel;
import pl.mpak.orbada.hsqldb.gui.tables.TableColumnsPanel;
import pl.mpak.orbada.hsqldb.gui.views.ViewColumnsPanel;
import pl.mpak.orbada.hsqldb.services.HSqlDbInfoProvider;
import pl.mpak.orbada.universal.providers.UniversalActionProvider;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class UniversalColumnProvider
extends UniversalActionProvider {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaHSqlDbPlugin.class);

    public UniversalColumnProvider() {
        this.setText(this.stringManager.getString("UniversalColumnProvider-text"));
        this.setShortCut(117, 2);
        this.setActionCommandKey("UniversalColumnProvider");
        this.addActionListener(this.createActionListener());
    }

    public boolean isForDatabase(Database database) {
        if (database == null) {
            return false;
        }
        return "HSQLDB".equals(database.getDriverType());
    }

    public boolean addToolButton() {
        return false;
    }

    public boolean addMenuItem() {
        return true;
    }

    public boolean addToEditor() {
        return true;
    }

    public String getDescription() {
        return this.stringManager.getString("UniversalColumnProvider-description");
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                block15: {
                    try {
                        String[] words = UniversalColumnProvider.this.accessibilities.getSyntaxEditor().getWordsAt(UniversalColumnProvider.this.accessibilities.getSyntaxEditor().getCaretPosition());
                        String object = null;
                        String schema = HSqlDbInfoProvider.getCurrentSchema(UniversalColumnProvider.this.accessibilities.getViewAccesibilities().getDatabase());
                        if (words == null || words.length <= 0) break block15;
                        if (words.length == 1) {
                            object = words[0];
                        } else {
                            schema = words[0];
                            object = words[1];
                        }
                        Query query = UniversalColumnProvider.this.accessibilities.getViewAccesibilities().getDatabase().createQuery();
                        try {
                            query.setSqlText(Sql.getObjectsType(HSqlDbInfoProvider.getVersionTest(UniversalColumnProvider.this.accessibilities.getViewAccesibilities().getDatabase())));
                            query.paramByName("schema_name").setString(schema);
                            query.paramByName("object_name").setString(object);
                            query.open();
                            if (!query.eof()) {
                                String type = query.fieldByName("object_type").getString();
                                if ("TABLE".equalsIgnoreCase(type)) {
                                    UniversalColumnProvider.this.setText(UniversalColumnProvider.this.stringManager.getString("columns"));
                                    TableColumnsPanel panel = new TableColumnsPanel(UniversalColumnProvider.this.accessibilities.getViewAccesibilities());
                                    panel.refresh(null, schema, object);
                                    UniversalColumnProvider.this.accessibilities.addResultTab(UniversalColumnProvider.this.getText() + " \"" + schema + "\".\"" + object + "\"", (JComponent)panel);
                                } else if ("VIEW".equalsIgnoreCase(type)) {
                                    UniversalColumnProvider.this.setText(UniversalColumnProvider.this.stringManager.getString("columns"));
                                    ViewColumnsPanel panel = new ViewColumnsPanel(UniversalColumnProvider.this.accessibilities.getViewAccesibilities());
                                    panel.refresh(null, schema, object);
                                    UniversalColumnProvider.this.accessibilities.addResultTab(UniversalColumnProvider.this.getText() + " \"" + schema + "\".\"" + object + "\"", (JComponent)panel);
                                } else if ("PROCEDURE".equalsIgnoreCase(type) || "FUNCTION".equalsIgnoreCase(type)) {
                                    UniversalColumnProvider.this.setText(UniversalColumnProvider.this.stringManager.getString("parameters"));
                                    ProcedureParametersPanel panel = new ProcedureParametersPanel(UniversalColumnProvider.this.accessibilities.getViewAccesibilities());
                                    panel.refresh(null, schema, object);
                                    UniversalColumnProvider.this.accessibilities.addResultTab(UniversalColumnProvider.this.getText() + " \"" + schema + "\".\"" + object + "\"", (JComponent)panel);
                                }
                            }
                        }
                        catch (Exception ex) {
                            ExceptionUtil.processException((Throwable)ex);
                        }
                        finally {
                            query.close();
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        };
    }

    public String getGroupName() {
        return "HSQLDB";
    }
}

