/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle;

import java.util.ArrayList;
import java.util.List;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.db.Template;
import pl.mpak.orbada.oracle.cm.CallObjectFromEditorAction;
import pl.mpak.orbada.oracle.cm.FindObjectFromEditorAction;
import pl.mpak.orbada.oracle.services.OracleAutoCompleteService;
import pl.mpak.orbada.oracle.services.OracleCompileErrorSettingsProvider;
import pl.mpak.orbada.oracle.services.OracleConnectionSettingsProvider;
import pl.mpak.orbada.oracle.services.OracleCopySqlFromSourceActionProvider;
import pl.mpak.orbada.oracle.services.OracleDatabaseProvider;
import pl.mpak.orbada.oracle.services.OracleDbInfoProvider;
import pl.mpak.orbada.oracle.services.OracleDbLinksView;
import pl.mpak.orbada.oracle.services.OracleDbmsOutputConnectionSettingsProvider;
import pl.mpak.orbada.oracle.services.OracleDbmsOutputSettingsProvider;
import pl.mpak.orbada.oracle.services.OracleDbmsOutputView;
import pl.mpak.orbada.oracle.services.OracleDictionaryView;
import pl.mpak.orbada.oracle.services.OracleDirectoriesView;
import pl.mpak.orbada.oracle.services.OracleExplainPlanProvider;
import pl.mpak.orbada.oracle.services.OracleExplainPlanSourceActionProvider;
import pl.mpak.orbada.oracle.services.OracleFocusProvider;
import pl.mpak.orbada.oracle.services.OracleFunctionsView;
import pl.mpak.orbada.oracle.services.OracleIndexesView;
import pl.mpak.orbada.oracle.services.OracleJavaClassesView;
import pl.mpak.orbada.oracle.services.OracleJavaResourcesView;
import pl.mpak.orbada.oracle.services.OracleJavaSourcesView;
import pl.mpak.orbada.oracle.services.OracleJobsView;
import pl.mpak.orbada.oracle.services.OracleMViewsView;
import pl.mpak.orbada.oracle.services.OraclePackagesView;
import pl.mpak.orbada.oracle.services.OraclePerspectiveProvider;
import pl.mpak.orbada.oracle.services.OracleProceduresView;
import pl.mpak.orbada.oracle.services.OracleQuickSearchObject;
import pl.mpak.orbada.oracle.services.OracleRecyclebinView;
import pl.mpak.orbada.oracle.services.OracleSearchObjectView;
import pl.mpak.orbada.oracle.services.OracleSearchSourceView;
import pl.mpak.orbada.oracle.services.OracleSequencesView;
import pl.mpak.orbada.oracle.services.OracleSettingsProvider;
import pl.mpak.orbada.oracle.services.OracleSourceCreatorSettingsProvider;
import pl.mpak.orbada.oracle.services.OracleSynonymsView;
import pl.mpak.orbada.oracle.services.OracleTablesView;
import pl.mpak.orbada.oracle.services.OracleTemplatesSettingsProvider;
import pl.mpak.orbada.oracle.services.OracleTriggersView;
import pl.mpak.orbada.oracle.services.OracleTypesView;
import pl.mpak.orbada.oracle.services.OracleViewsView;
import pl.mpak.orbada.oracle.services.UniversalColumnProvider;
import pl.mpak.orbada.oracle.services.UniversalErrorPosition;
import pl.mpak.orbada.oracle.services.UniversalResultDbmsOutputProvider;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.OrbadaPlugin;
import pl.mpak.orbada.plugins.queue.PluginMessage;
import pl.mpak.plugins.spi.IPlugin;
import pl.mpak.plugins.spi.IPluginProvider;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.id.VersionID;
import pl.mpak.util.timer.TimerManager;
import pl.mpak.util.timer.TimerQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrbadaOraclePlugin
extends OrbadaPlugin {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    public static final String versionId = new VersionID(1, 0, 1, 60).toString();
    public static final String oracleDriverType = "Oracle";
    public static final String javaGroup = stringManager.getString("OrbadaOraclePlugin-java-objects");
    public static final String dataGroup = stringManager.getString("OrbadaOraclePlugin-data-objects");
    public static final String editableGroup = stringManager.getString("OrbadaOraclePlugin-editable-objects");
    public static final String advancedGroup = stringManager.getString("OrbadaOraclePlugin-advanced");
    public static final String adminGroup = stringManager.getString("OrbadaOraclePlugin-oracle-dba");
    public static final String specjalOracleWizardsActions = "oracle-wizards-actions";
    public static final String specjalOracleActions = "oracle-actions";
    private static TimerQueue refreshQueue;
    public static final ArrayList<Class<? extends IPluginProvider>> classList;
    public static FindObjectFromEditorAction findObjectAction;
    public static CallObjectFromEditorAction callObjectAction;

    public static TimerQueue getRefreshQueue() {
        if (refreshQueue == null) {
            refreshQueue = TimerManager.getTimer((String)"orbada-oracle-refresh");
        }
        return refreshQueue;
    }

    public String getInternalName() {
        return "OrbadaOraclePlugin";
    }

    public String getDescriptiveName() {
        return String.format(stringManager.getString("OrbadaOraclePlugin-descriptive-name"), this.getVersion());
    }

    public String getDescription() {
        return "";
    }

    public String getCategory() {
        return "IDE,Database,Oracle";
    }

    public String getAuthor() {
        return "Andrzej Ka\u0142u\u017ca";
    }

    public String getCopyrights() {
        return "";
    }

    public String getWebSite() {
        return null;
    }

    public String getUpdateSite() {
        return null;
    }

    public String getVersion() {
        return versionId;
    }

    public String getLicence() {
        return null;
    }

    public String getUniqueID() {
        return "orbada-oracle-plugin";
    }

    public void load() {
    }

    public void unload() {
    }

    public void initialize() {
        this.application.registerDriverType(oracleDriverType);
        findObjectAction = new FindObjectFromEditorAction();
        callObjectAction = new CallObjectFromEditorAction();
        classList.add(OracleDbInfoProvider.class);
        classList.add(OracleDictionaryView.class);
        classList.add(OracleDbmsOutputView.class);
        classList.add(OracleDbmsOutputSettingsProvider.class);
        classList.add(OracleDbmsOutputConnectionSettingsProvider.class);
        classList.add(OracleTablesView.class);
        classList.add(OracleDatabaseProvider.class);
        classList.add(OracleRecyclebinView.class);
        classList.add(OracleSequencesView.class);
        classList.add(OracleIndexesView.class);
        classList.add(OracleTriggersView.class);
        classList.add(OracleSynonymsView.class);
        classList.add(OracleDbLinksView.class);
        classList.add(OracleViewsView.class);
        classList.add(OracleTypesView.class);
        classList.add(OraclePackagesView.class);
        classList.add(OraclePerspectiveProvider.class);
        classList.add(OracleFunctionsView.class);
        classList.add(OracleProceduresView.class);
        classList.add(OracleMViewsView.class);
        classList.add(OracleJavaSourcesView.class);
        classList.add(OracleJavaClassesView.class);
        classList.add(OracleJavaResourcesView.class);
        classList.add(OracleDirectoriesView.class);
        classList.add(OracleTemplatesSettingsProvider.class);
        classList.add(OracleSearchObjectView.class);
        classList.add(OracleSearchSourceView.class);
        classList.add(OracleQuickSearchObject.class);
        classList.add(OracleJobsView.class);
        classList.add(OracleCompileErrorSettingsProvider.class);
        classList.add(OracleFocusProvider.class);
        classList.add(OracleSourceCreatorSettingsProvider.class);
        classList.add(OracleSettingsProvider.class);
        classList.add(OracleConnectionSettingsProvider.class);
        classList.add(OracleAutoCompleteService.class);
        classList.add(OracleExplainPlanSourceActionProvider.class);
        classList.add(OracleCopySqlFromSourceActionProvider.class);
        this.initTemplates();
    }

    public boolean requires(List<IPlugin> loadedPlugins) {
        this.addDepend("orbada-universal-plugin");
        for (IPlugin plugin : loadedPlugins) {
            if (!"orbada-universal-plugin".equals(plugin.getUniqueID())) continue;
            classList.add(UniversalColumnProvider.class);
            classList.add(OracleExplainPlanProvider.class);
            classList.add(UniversalResultDbmsOutputProvider.class);
            classList.add(UniversalErrorPosition.class);
        }
        return true;
    }

    public Class<IPluginProvider>[] getProviderArray() {
        return classList.toArray(new Class[classList.size()]);
    }

    public void processMessage(PluginMessage message) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTemplates() {
        if (InternalDatabase.get() == null) {
            return;
        }
        Database database = InternalDatabase.get();
        Query query = database.createQuery();
        try {
            ISettings settings;
            query.open("select count( 0 ) cnt from templates where tpl_name like 'oracle-%'");
            if (query.fieldByName("cnt").getInteger() == 0) {
                Template template = new Template(this.application.getOrbadaDatabase());
                template.setName("oracle-function");
                template.setDescription("Oracle Function Template");
                template.setUsrId("");
                template.setBody("CREATE FUNCTION $(&name) $(&parameters) RETURN $(&return) IS\n--############################################################################\n--# ORBADA   : To change this template, choose Tools | Templates\n--# Autor    : $(orbada.user.name)\n--# Stworzono: $(orbada.current.date) $(orbada.current.time)\n--# Opis     : $(&description)\n--# Zmiany   :\n--# Data:      Autor:         Wersja:\n--# ---------- -------------- ------------------------------------------------\n--############################################################################\nBEGIN\n  /* TODO function implementation */\n$(&body)\nEND;");
                template.applyInsert();
                template = new Template(this.application.getOrbadaDatabase());
                template.setName("oracle-java-source");
                template.setDescription("Oracle Java Source Template");
                template.setUsrId("");
                template.setBody("CREATE JAVA SOURCE NAMED \"$(&name)\" AS\npublic class $(&name) {\n  /**\n   * $(&name) [.java]\n   * Created on $(orbada.current.date) $(orbada.current.time)\n   * \n   * <p>ORBADA: To change this template, choose Tools | Templates\n   * <p>$(&description)\n   * \n   * @author $(orbada.user.name)\n   * @author\n   */\n\n  public $(&name)() {\n  }\n\n}");
                template.applyInsert();
                template = new Template(this.application.getOrbadaDatabase());
                template.setName("oracle-object-type");
                template.setDescription("Oracle OBJECT Type Template");
                template.setUsrId("");
                template.setBody("CREATE TYPE $(&name) AS OBJECT (\n--############################################################################\n--# ORBADA   : To change this template, choose Tools | Templates\n--# Autor    : $(orbada.user.name)\n--# Stworzono: $(orbada.current.date) $(orbada.current.time)\n--# Opis     : $(&description)\n--# Zmiany   :\n--# Data:      Autor:         Wersja:\n--# ---------- -------------- ------------------------------------------------\n--############################################################################\n  /* TODO enter attribute and method declarations here */\n);");
                template.applyInsert();
                template = new Template(this.application.getOrbadaDatabase());
                template.setName("oracle-object-type-body");
                template.setDescription("Oracle OBJECT Type Body Template");
                template.setUsrId("");
                template.setBody("CREATE TYPE BODY $(&name) IS\n--############################################################################\n--# ORBADA   : To change this template, choose Tools | Templates\n--# Autor    : $(orbada.user.name)\n--# Stworzono: $(orbada.current.date) $(orbada.current.time)\n--# Opis     : $(&description)\n--# Zmiany   :\n--# Data:      Autor:         Wersja:\n--# ---------- -------------- ------------------------------------------------\n--############################################################################\n  /* TODO enter attribute and method implementations here */\nEND;");
                template.applyInsert();
                template = new Template(this.application.getOrbadaDatabase());
                template.setName("oracle-package");
                template.setDescription("Oracle Pakage Template");
                template.setUsrId("");
                template.setBody("CREATE PACKAGE $(&name) AS\n--############################################################################\n--# ORBADA   : To change this template, choose Tools | Templates\n--# Autor    : $(orbada.user.name)\n--# Stworzono: $(orbada.current.date) $(orbada.current.time)\n--# Opis     : $(&description)\n--# Zmiany   :\n--# Data:      Autor:         Wersja:\n--# ---------- -------------- ------------------------------------------------\n--############################################################################\n  /* TODO definitions */\nEND $(&name);");
                template.applyInsert();
                template = new Template(this.application.getOrbadaDatabase());
                template.setName("oracle-package-body");
                template.setDescription("Oracle Package Body Template");
                template.setUsrId("");
                template.setBody("CREATE PACKAGE BODY $(&name) AS\n--############################################################################\n--# ORBADA   : To change this template, choose Tools | Templates\n--# Autor    : $(orbada.user.name)\n--# Stworzono: $(orbada.current.date) $(orbada.current.time)\n--# Opis     : $(&description)\n--# Zmiany   :\n--# Data:      Autor:         Wersja:\n--# ---------- -------------- ------------------------------------------------\n--############################################################################\n  /* TODO implementations */\nEND $(&name);");
                template.applyInsert();
                template = new Template(this.application.getOrbadaDatabase());
                template.setName("oracle-procedure");
                template.setDescription("Oracle Procedure Template");
                template.setUsrId("");
                template.setBody("CREATE PROCEDURE $(&name) $(&parameters) IS\n--############################################################################\n--# ORBADA   : To change this template, choose Tools | Templates\n--# Autor    : $(orbada.user.name)\n--# Stworzono: $(orbada.current.date) $(orbada.current.time)\n--# Opis     : $(&description)\n--# Zmiany   :\n--# Data:      Autor:         Wersja:\n--# ---------- -------------- ------------------------------------------------\n--############################################################################\nBEGIN\n  /* TODO procedure implementation */\n$(&body)\nEND;");
                template.applyInsert();
                template = new Template(this.application.getOrbadaDatabase());
                template.setName("oracle-table-type");
                template.setDescription("Oracle TABLE Type Template");
                template.setUsrId("");
                template.setBody("CREATE TYPE $(&name) AS TABLE OF $(&data.type);");
                template.applyInsert();
                template = new Template(this.application.getOrbadaDatabase());
                template.setName("oracle-trigger");
                template.setDescription("Oracle Trigger Template");
                template.setUsrId("");
                template.setBody("CREATE TRIGGER $(&name)\n$(&type)\n--############################################################################\n--# ORBADA   : To change this template, choose Tools | Templates\n--# Autor    : $(orbada.user.name)\n--# Stworzono: $(orbada.current.date) $(orbada.current.time)\n--# Opis     : $(&description)\n--# Zmiany   :\n--# Data:      Autor:         Wersja:\n--# ---------- -------------- ------------------------------------------------\n--############################################################################\nBEGIN\n  /* TODO trigger implementation */\n$(&body)\nEND;");
                template.applyInsert();
                template = new Template(this.application.getOrbadaDatabase());
                template.setName("oracle-varray-type");
                template.setDescription("Oracle VARRAY Type Template");
                template.setUsrId("");
                template.setBody("CREATE TYPE $(&name) AS VARRAY($(&size)) OF $(&data.type);");
                template.applyInsert();
            }
            if ((settings = Application.get().getSettings(OracleTemplatesSettingsProvider.settingsName)).getValue(OracleTemplatesSettingsProvider.setFunction).isNull()) {
                settings.setValue(OracleTemplatesSettingsProvider.setFunction, "oracle-function");
            }
            if (settings.getValue(OracleTemplatesSettingsProvider.setJavaSource).isNull()) {
                settings.setValue(OracleTemplatesSettingsProvider.setJavaSource, "oracle-java-source");
            }
            if (settings.getValue(OracleTemplatesSettingsProvider.setObjectType).isNull()) {
                settings.setValue(OracleTemplatesSettingsProvider.setObjectType, "oracle-object-type");
            }
            if (settings.getValue(OracleTemplatesSettingsProvider.setObjectTypeBody).isNull()) {
                settings.setValue(OracleTemplatesSettingsProvider.setObjectTypeBody, "oracle-object-type-body");
            }
            if (settings.getValue(OracleTemplatesSettingsProvider.setPackage).isNull()) {
                settings.setValue(OracleTemplatesSettingsProvider.setPackage, "oracle-package");
            }
            if (settings.getValue(OracleTemplatesSettingsProvider.setPackageBody).isNull()) {
                settings.setValue(OracleTemplatesSettingsProvider.setPackageBody, "oracle-package-body");
            }
            if (settings.getValue(OracleTemplatesSettingsProvider.setProcedure).isNull()) {
                settings.setValue(OracleTemplatesSettingsProvider.setProcedure, "oracle-procedure");
            }
            if (settings.getValue(OracleTemplatesSettingsProvider.setTableType).isNull()) {
                settings.setValue(OracleTemplatesSettingsProvider.setTableType, "oracle-table-type");
            }
            if (settings.getValue(OracleTemplatesSettingsProvider.setTrigger).isNull()) {
                settings.setValue(OracleTemplatesSettingsProvider.setTrigger, "oracle-trigger");
            }
            if (settings.getValue(OracleTemplatesSettingsProvider.setVarrayType).isNull()) {
                settings.setValue(OracleTemplatesSettingsProvider.setVarrayType, "oracle-varray-type");
            }
            settings.store();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
    }

    static {
        classList = new ArrayList();
    }
}

