/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.cm;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.text.BadLocationException;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.gui.wizards.CallObjectWizard;
import pl.mpak.orbada.oracle.services.OracleDbInfoProvider;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.syntax.SyntaxEditor;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class CallObjectFromEditorAction
extends Action {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private SyntaxEditor syntaxEditor;

    public CallObjectFromEditorAction() {
        this.setText(this.stringManager.getString("CallObjectFromEditorAction-text"));
        this.setSmallIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/call_editor.gif"));
        this.setTooltip(this.stringManager.getString("CallObjectFromEditorAction-hint"));
        this.setShortCut(119, 3);
        this.setActionCommandKey("CallObjectFromEditorAction");
        this.addActionListener(this.createActionListener());
    }

    public SyntaxEditor getSyntaxEditor() {
        return this.syntaxEditor;
    }

    public void setSyntaxEditor(SyntaxEditor syntaxEditor) {
        this.syntaxEditor = syntaxEditor;
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    private void callFound(final String schemaName, final String objectName) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CallObjectWizard(CallObjectFromEditorAction.this.database, schemaName, objectName, null), (boolean)true);
            }
        });
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                block14: {
                    try {
                        String[] words = CallObjectFromEditorAction.this.syntaxEditor.getWordsAt(CallObjectFromEditorAction.this.syntaxEditor.getCaretPosition());
                        String packageName = null;
                        String object = null;
                        String schema = OracleDbInfoProvider.getCurrentSchema(CallObjectFromEditorAction.this.database);
                        if (words == null || words.length <= 0) break block14;
                        if (words.length == 1) {
                            object = SQLUtil.normalizeSqlName((String)words[0]);
                        } else if (words.length == 3) {
                            schema = SQLUtil.normalizeSqlName((String)words[0]);
                            packageName = SQLUtil.normalizeSqlName((String)words[1]);
                            object = SQLUtil.normalizeSqlName((String)words[2]);
                        } else {
                            packageName = SQLUtil.normalizeSqlName((String)words[0]);
                            object = SQLUtil.normalizeSqlName((String)words[1]);
                        }
                        Query query = CallObjectFromEditorAction.this.database.createQuery();
                        try {
                            query.setSqlText(Sql.getObjectForCall());
                            query.paramByName("schema_name").setString(schema);
                            query.paramByName("object_name").setString((packageName != null ? packageName + "." : "") + object);
                            query.open();
                            if (!query.eof()) {
                                CallObjectFromEditorAction.this.callFound(schema, (packageName != null ? packageName + "." : "") + object);
                            } else {
                                query.close();
                                query.paramByName("schema_name").setString(packageName);
                                query.paramByName("object_name").setString(object);
                                query.open();
                                if (!query.eof()) {
                                    CallObjectFromEditorAction.this.callFound(packageName, object);
                                }
                            }
                        }
                        catch (Exception ex) {
                            ExceptionUtil.processException((Throwable)ex);
                        }
                        finally {
                            query.close();
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        };
    }
}

