/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.dbinfo;

import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.dbinfo.OracleConstraintInfo;
import pl.mpak.orbada.oracle.dbinfo.OracleSchemaInfo;
import pl.mpak.orbada.oracle.dbinfo.OracleTableInfo;
import pl.mpak.orbada.plugins.dbinfo.DbObjectContainer;
import pl.mpak.orbada.plugins.dbinfo.DbObjectIdentified;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.variant.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleConstraintListInfo
extends DbObjectContainer<OracleConstraintInfo> {
    private boolean onTable = this.getTable() != null;

    public OracleConstraintListInfo(DbObjectContainer owner) {
        super("CONSTRAINTS", (DbObjectIdentified)owner);
    }

    public OracleSchemaInfo getSchema() {
        DbObjectIdentified o = this.getOwner(OracleSchemaInfo.class);
        if (o != null) {
            return (OracleSchemaInfo)o;
        }
        return null;
    }

    public OracleTableInfo getTable() {
        DbObjectIdentified o = this.getOwner(OracleTableInfo.class);
        if (o != null) {
            return (OracleTableInfo)o;
        }
        return null;
    }

    public String[] getColumnNames() {
        if (this.onTable) {
            return new String[]{"Nazwa kolumny", "Pozycja", "Status", "W\u0142\u0105czony", "Schemat ref.", "Ograncizenie ref.", "Akcja usuwania", "Akcja sprawdzania", "Typ"};
        }
        return new String[]{"Nazwa tabeli", "Nazwa kolumny", "Pozycja", "Status", "W\u0142\u0105czony", "Schemat ref.", "Ograncizenie ref.", "Akcja usuwania", "Akcja sprawdzania", "Typ"};
    }

    public String[] getMemberNames() {
        return new String[0];
    }

    public Variant[] getMemberValues() {
        return new Variant[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws Exception {
        if (this.isRefreshing()) {
            return;
        }
        this.setRefreshing(true);
        try {
            this.clear();
            Query query = this.getDatabase().createQuery();
            try {
                query.setSqlText(Sql.getConstraintList(this.getFilter()));
                query.paramByName("schema_name").setString(this.getSchema().getName());
                if (this.onTable) {
                    query.paramByName("table_name").setString(this.getTable().getName());
                }
                query.open();
                while (!query.eof()) {
                    OracleConstraintInfo info = new OracleConstraintInfo(query.fieldByName("constraint_name").getString(), this);
                    info.setCheckRule(query.fieldByName("search_condition").getString());
                    info.setType(query.fieldByName("constraint_type").getString());
                    info.setTableName(query.fieldByName("table_name").getString());
                    info.setColumnName(query.fieldByName("column_name").getString());
                    info.setPosition(query.fieldByName("position").getInteger());
                    info.setStatus(query.fieldByName("status").getString());
                    info.setValid(query.fieldByName("validated").getString());
                    info.setRSchemaName(query.fieldByName("r_schema_name").getString());
                    info.setRConstraint(query.fieldByName("r_constraint_name").getString());
                    info.setDeleteRule(query.fieldByName("delete_rule").getString());
                    this.put(info.getName() + "." + info.getColumnName(), info);
                    query.next();
                }
            }
            finally {
                query.close();
            }
        }
        finally {
            this.setRefreshed(true);
        }
    }
}

