/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.dbinfo;

import java.util.ArrayList;
import pl.mpak.orbada.oracle.dbinfo.OracleContentInfo;
import pl.mpak.orbada.oracle.dbinfo.OracleSchemaInfo;
import pl.mpak.orbada.plugins.dbinfo.DbObjectContainer;
import pl.mpak.orbada.plugins.dbinfo.DbObjectIdentified;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.variant.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleContentListInfo
extends DbObjectContainer<OracleContentInfo> {
    private String[] columns;

    public OracleContentListInfo(DbObjectContainer owner) {
        super("CONTENT", (DbObjectIdentified)owner);
    }

    public OracleSchemaInfo getSchema() {
        DbObjectIdentified o = this.getOwner(OracleSchemaInfo.class);
        if (o != null) {
            return (OracleSchemaInfo)o;
        }
        return null;
    }

    public String[] getColumnNames() {
        return this.columns;
    }

    public String[] getMemberNames() {
        return new String[0];
    }

    public Variant[] getMemberValues() {
        return new Variant[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws Exception {
        if (this.isRefreshing()) {
            return;
        }
        this.setRefreshing(true);
        try {
            this.clear();
            Query query = this.getDatabase().createQuery();
            try {
                DbObjectIdentified object = (DbObjectIdentified)this.getObjectOwner();
                String name = null;
                name = this.getSchema() == null ? SQLUtil.createSqlName((String)object.getName()) : SQLUtil.createSqlName((String)this.getSchema().getName(), (String)object.getName());
                query.setSqlText("select rownum, t.* from " + name + " t" + (this.getFilter() == null ? "" : " where " + this.getFilter()));
                query.open();
                ArrayList<String> columnList = new ArrayList<String>();
                for (int c = 1; c < query.getFieldCount(); ++c) {
                    columnList.add(query.getField(c).getDisplayName());
                }
                this.columns = columnList.toArray(new String[columnList.size()]);
                int maxRows = 100000 / this.columns.length;
                while (!query.eof()) {
                    ArrayList<Variant> values = new ArrayList<Variant>();
                    for (int c = 1; c < query.getFieldCount(); ++c) {
                        values.add(query.getField(c).getValue());
                    }
                    OracleContentInfo info = new OracleContentInfo(query.fieldByName("rownum").getString(), this.columns, values.toArray(new Variant[values.size()]), this);
                    this.put(info);
                    if (--maxRows == 0) {
                        break;
                    }
                    query.next();
                }
            }
            finally {
                query.close();
            }
        }
        finally {
            this.setRefreshed(false);
        }
    }
}

