/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.dbinfo;

import pl.mpak.orbada.oracle.dbinfo.OracleDataTypeListInfo;
import pl.mpak.orbada.oracle.dbinfo.OracleDictionaryListInfo;
import pl.mpak.orbada.oracle.dbinfo.OracleDirectoryListInfo;
import pl.mpak.orbada.oracle.dbinfo.OracleExceptionTableListInfo;
import pl.mpak.orbada.oracle.dbinfo.OracleNlsCharsetListInfo;
import pl.mpak.orbada.oracle.dbinfo.OracleRecyclebinListInfo;
import pl.mpak.orbada.oracle.dbinfo.OracleSchemaListInfo;
import pl.mpak.orbada.oracle.dbinfo.OracleSessionPrivilegeListInfo;
import pl.mpak.orbada.oracle.dbinfo.OracleSystemPrivilegeMapListInfo;
import pl.mpak.orbada.oracle.dbinfo.OracleTableTypeListInfo;
import pl.mpak.orbada.oracle.dbinfo.OracleTablespaceListInfo;
import pl.mpak.orbada.oracle.services.OracleDbInfoProvider;
import pl.mpak.orbada.plugins.dbinfo.DbDatabaseInfo;
import pl.mpak.orbada.plugins.dbinfo.DbObjectContainer;
import pl.mpak.orbada.plugins.dbinfo.DbObjectIdentified;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.variant.Variant;

public class OracleDatabaseInfo
extends DbDatabaseInfo {
    public OracleDatabaseInfo(Database database) {
        super(database);
        try {
            this.refresh();
        }
        catch (Throwable ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public String[] getColumnNames() {
        return new String[0];
    }

    public String[] getMemberNames() {
        return new String[]{"Version", "Banner"};
    }

    public Variant[] getMemberValues() {
        return new Variant[]{new Variant(this.getVersion()), new Variant(this.getBanner())};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws Exception {
        if (this.isRefreshing()) {
            return;
        }
        this.setRefreshing(true);
        try {
            this.clear();
            this.setVersion(OracleDbInfoProvider.getVersionInfo(this.getDatabase()));
            this.setBanner("Database:\n" + OracleDbInfoProvider.getBannerInfo(this.getDatabase()) + "\n\n" + "Driver:\n" + this.getDatabase().getMetaData().getDriverName() + ", " + this.getDatabase().getMetaData().getDriverVersion());
            this.setRemarks(this.getBanner());
            this.put((DbObjectIdentified)new OracleSchemaListInfo(this));
            this.put((DbObjectIdentified)new OracleDictionaryListInfo(this));
            this.put((DbObjectIdentified)new OracleTableTypeListInfo(this));
            this.put((DbObjectIdentified)new OracleDataTypeListInfo(this));
            if (OracleDbInfoProvider.instance.getMajorVersion(this.getDatabase()) >= 10) {
                this.put((DbObjectIdentified)new OracleRecyclebinListInfo((DbObjectContainer)this));
            }
            this.put((DbObjectIdentified)new OracleTablespaceListInfo((DbObjectContainer)this));
            this.put((DbObjectIdentified)new OracleNlsCharsetListInfo((DbObjectContainer)this));
            this.put((DbObjectIdentified)new OracleSystemPrivilegeMapListInfo((DbObjectContainer)this));
            this.put((DbObjectIdentified)new OracleDirectoryListInfo((DbObjectContainer)this));
            this.put((DbObjectIdentified)new OracleSessionPrivilegeListInfo((DbObjectContainer)this));
            this.put((DbObjectIdentified)new OracleExceptionTableListInfo(this));
        }
        finally {
            this.setRefreshed(true);
        }
    }

    public String getDescription() {
        return "Oracle Database Info Provider";
    }
}

