/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.dbinfo;

import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.dbinfo.OracleDbLinkInfo;
import pl.mpak.orbada.oracle.dbinfo.OracleSchemaInfo;
import pl.mpak.orbada.plugins.dbinfo.DbObjectContainer;
import pl.mpak.orbada.plugins.dbinfo.DbObjectIdentified;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.variant.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDbLinkListInfo
extends DbObjectContainer<OracleDbLinkInfo> {
    public OracleDbLinkListInfo(OracleSchemaInfo owner) {
        super("DB LINKS", (DbObjectIdentified)owner);
    }

    public OracleSchemaInfo getSchema() {
        DbObjectIdentified o = this.getOwner(OracleSchemaInfo.class);
        if (o != null) {
            return (OracleSchemaInfo)o;
        }
        return null;
    }

    public String[] getColumnNames() {
        return new String[]{"U\u017cytkownik", "Serwer docelowy", "Utworzony"};
    }

    public String[] getMemberNames() {
        return new String[0];
    }

    public Variant[] getMemberValues() {
        return new Variant[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws Exception {
        if (this.isRefreshing()) {
            return;
        }
        this.setRefreshing(true);
        try {
            this.clear();
            Query query = this.getDatabase().createQuery();
            try {
                query.setSqlText(Sql.getDbLinkList(this.getFilter()));
                query.paramByName("schema_name").setString(this.getSchema().getName());
                query.open();
                while (!query.eof()) {
                    OracleDbLinkInfo info = new OracleDbLinkInfo(query.fieldByName("db_link").getString(), this);
                    info.setUserName(query.fieldByName("username").getString());
                    info.setHost(query.fieldByName("host").getString());
                    info.setCreated(query.fieldByName("created").getTimestamp());
                    this.put(info);
                    query.next();
                }
            }
            finally {
                query.close();
            }
        }
        finally {
            this.setRefreshed(true);
        }
    }
}

