/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.dbinfo;

import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.dbinfo.OracleFunctionInfo;
import pl.mpak.orbada.oracle.dbinfo.OracleSchemaInfo;
import pl.mpak.orbada.oracle.services.OracleDbInfoProvider;
import pl.mpak.orbada.plugins.dbinfo.DbObjectContainer;
import pl.mpak.orbada.plugins.dbinfo.DbObjectIdentified;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.variant.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleFunctionListInfo
extends DbObjectContainer<OracleFunctionInfo> {
    public OracleFunctionListInfo(OracleSchemaInfo owner) {
        super("FUNCTIONS", (DbObjectIdentified)owner);
    }

    public String[] getColumnNames() {
        return new String[]{"Status"};
    }

    public String[] getMemberNames() {
        return new String[0];
    }

    public Variant[] getMemberValues() {
        return new Variant[0];
    }

    public OracleSchemaInfo getSchema() {
        DbObjectIdentified o = this.getOwner(OracleSchemaInfo.class);
        if (o != null) {
            return (OracleSchemaInfo)o;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws Exception {
        if (this.isRefreshing()) {
            return;
        }
        this.setRefreshing(true);
        try {
            this.clear();
            Query query = this.getDatabase().createQuery();
            try {
                query.setSqlText(Sql.getFunctionList(this.getFilter(), OracleDbInfoProvider.instance.getMajorVersion(this.getDatabase())));
                query.paramByName("schema_name").setString(this.getSchema().getName());
                query.paramByName("function_type").setString("FUNCTION");
                query.open();
                while (!query.eof()) {
                    OracleFunctionInfo info = new OracleFunctionInfo(query.fieldByName("object_name").getString(), this);
                    info.setStatus(query.fieldByName("status").getString());
                    this.put((DbObjectIdentified)info);
                    query.next();
                }
            }
            finally {
                query.close();
            }
        }
        finally {
            this.setRefreshed(true);
        }
    }
}

