/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.dbinfo;

import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.dbinfo.OracleIndexInfo;
import pl.mpak.orbada.oracle.dbinfo.OracleSchemaInfo;
import pl.mpak.orbada.plugins.dbinfo.DbObjectContainer;
import pl.mpak.orbada.plugins.dbinfo.DbObjectIdentified;
import pl.mpak.orbada.plugins.dbinfo.DbObjectInfo;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.StringUtil;
import pl.mpak.util.variant.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleIndexListInfo
extends DbObjectContainer<OracleIndexInfo> {
    private boolean onTable;

    public OracleIndexListInfo(DbObjectContainer owner) {
        super("INDEXES", (DbObjectIdentified)owner);
        DbObjectInfo info = this.getObjectOwner();
        this.onTable = info != null && StringUtil.equalAnyOfString((String)info.getObjectType(), (String[])new String[]{"TABLE", "MATERIALIZED VIEW"}, (boolean)true);
    }

    public OracleSchemaInfo getSchema() {
        DbObjectIdentified o = this.getOwner(OracleSchemaInfo.class);
        if (o != null) {
            return (OracleSchemaInfo)o;
        }
        return null;
    }

    public String[] getColumnNames() {
        if (this.onTable) {
            return new String[]{"Nazwa kolumny", "Typ", "Unikalny", "Przestrze\u0144 danych"};
        }
        return new String[]{"Tabela", "Typ", "Unikalny", "Przestrze\u0144 danych"};
    }

    public String[] getMemberNames() {
        return new String[0];
    }

    public Variant[] getMemberValues() {
        return new Variant[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws Exception {
        if (this.isRefreshing()) {
            return;
        }
        this.setRefreshing(true);
        try {
            this.clear();
            Query query = this.getDatabase().createQuery();
            try {
                if (this.onTable) {
                    query.setSqlText(Sql.getIndexList(this.getFilter(), false));
                    query.paramByName("table_name").setString(((DbObjectIdentified)this.getObjectOwner()).getName());
                } else {
                    query.setSqlText(Sql.getAllIndexList(null));
                }
                query.paramByName("schema_name").setString(this.getSchema().getName());
                query.open();
                while (!query.eof()) {
                    OracleIndexInfo info = new OracleIndexInfo(query.fieldByName("index_name").getString(), this);
                    info.setTableName(query.fieldByName("table_name").getString());
                    if (this.onTable) {
                        info.setColumnName(query.fieldByName("column_name").getString());
                    }
                    info.setType(query.fieldByName("index_type").getString());
                    info.setUnique("YES".equals(query.fieldByName("uniqueness").getString()));
                    info.setTablespaceName(query.fieldByName("tablespace_name").getString());
                    this.put(info.getName() + "." + info.getColumnName(), info);
                    query.next();
                }
            }
            finally {
                query.close();
            }
        }
        finally {
            this.setRefreshed(true);
        }
    }
}

