/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.dbinfo;

import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.dbinfo.OracleJavaSourceInfo;
import pl.mpak.orbada.oracle.dbinfo.OracleSchemaInfo;
import pl.mpak.orbada.plugins.dbinfo.DbObjectContainer;
import pl.mpak.orbada.plugins.dbinfo.DbObjectIdentified;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.variant.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleJavaSourceListInfo
extends DbObjectContainer<OracleJavaSourceInfo> {
    public OracleJavaSourceListInfo(OracleSchemaInfo owner) {
        super("JAVA SOURCES", (DbObjectIdentified)owner);
    }

    public String[] getColumnNames() {
        return new String[]{"Status", "Utworzony"};
    }

    public String[] getMemberNames() {
        return new String[0];
    }

    public Variant[] getMemberValues() {
        return new Variant[0];
    }

    public OracleSchemaInfo getSchema() {
        DbObjectIdentified o = this.getOwner(OracleSchemaInfo.class);
        if (o != null) {
            return (OracleSchemaInfo)o;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws Exception {
        if (this.isRefreshing()) {
            return;
        }
        this.setRefreshing(true);
        try {
            this.clear();
            Query query = this.getDatabase().createQuery();
            try {
                query.setSqlText(Sql.getObjectsName());
                query.paramByName("schema_name").setString(this.getSchema().getName());
                query.paramByName("object_type").setString("JAVA SOURCE");
                query.open();
                while (!query.eof()) {
                    OracleJavaSourceInfo info = new OracleJavaSourceInfo(query.fieldByName("object_name").getString(), this);
                    info.setStatus(query.fieldByName("status").getString());
                    info.setCreated(query.fieldByName("created").getTimestamp());
                    this.put((DbObjectIdentified)info);
                    query.next();
                }
            }
            finally {
                query.close();
            }
        }
        finally {
            this.setRefreshed(true);
        }
    }
}

