/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.dbinfo;

import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.dbinfo.OracleObjectInfo;
import pl.mpak.orbada.oracle.dbinfo.OracleSchemaInfo;
import pl.mpak.orbada.plugins.dbinfo.DbObjectContainer;
import pl.mpak.orbada.plugins.dbinfo.DbObjectIdentified;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.variant.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleObjectListInfo
extends DbObjectContainer<OracleObjectInfo> {
    public OracleObjectListInfo(OracleSchemaInfo owner) {
        super("ALL OBJECTS", (DbObjectIdentified)owner);
    }

    public OracleSchemaInfo getSchema() {
        DbObjectIdentified o = this.getOwner(OracleSchemaInfo.class);
        if (o != null) {
            return (OracleSchemaInfo)o;
        }
        return null;
    }

    public String[] getColumnNames() {
        return new String[]{"Nazwa obiektu", "Typ obiektu", "Utworzony", "Ostatnia zmiana", "Status"};
    }

    public String[] getMemberNames() {
        return new String[0];
    }

    public Variant[] getMemberValues() {
        return new Variant[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws Exception {
        if (this.isRefreshing()) {
            return;
        }
        this.setRefreshing(true);
        try {
            this.clear();
            Query query = this.getDatabase().createQuery();
            try {
                query.setSqlText(Sql.getAllObjectList() + " where schema_name = :SCHEMA_NAME");
                query.paramByName("schema_name").setString(this.getSchema().getName());
                query.open();
                while (!query.eof()) {
                    OracleObjectInfo info = new OracleObjectInfo(query.fieldByName("object_name").getString(), this);
                    info.setSchemaName(query.fieldByName("schema_name").getString());
                    info.setObjectName(query.fieldByName("object_name").getString());
                    info.setObjectType(query.fieldByName("object_type").getString());
                    info.setCreated(query.fieldByName("created").getTimestamp());
                    info.setLastDdlTime(query.fieldByName("last_ddl_time").getTimestamp());
                    info.setTimestamp(query.fieldByName("timestamp").getString());
                    info.setStatus(query.fieldByName("status").getString());
                    this.put(info.getSchemaName() + "." + info.getObjectType() + "." + info.getObjectName(), info);
                    query.next();
                }
            }
            finally {
                query.close();
            }
        }
        finally {
            this.setRefreshed(true);
        }
    }
}

