/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.dbinfo;

import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.dbinfo.OraclePackageInfo;
import pl.mpak.orbada.oracle.dbinfo.OraclePackageMethodInfo;
import pl.mpak.orbada.oracle.dbinfo.OracleSchemaInfo;
import pl.mpak.orbada.plugins.dbinfo.DbObjectContainer;
import pl.mpak.orbada.plugins.dbinfo.DbObjectIdentified;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.variant.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OraclePackageMethodListInfo
extends DbObjectContainer<OraclePackageMethodInfo> {
    public OraclePackageMethodListInfo(OraclePackageInfo owner) {
        super("METHODS", (DbObjectIdentified)owner);
    }

    public OracleSchemaInfo getSchema() {
        DbObjectIdentified o = this.getOwner(OracleSchemaInfo.class);
        if (o != null) {
            return (OracleSchemaInfo)o;
        }
        return null;
    }

    public OraclePackageInfo getPackage() {
        DbObjectIdentified o = this.getOwner(OraclePackageInfo.class);
        if (o != null) {
            return (OraclePackageInfo)o;
        }
        return null;
    }

    public String[] getColumnNames() {
        return new String[]{"Typ"};
    }

    public String[] getMemberNames() {
        return new String[0];
    }

    public Variant[] getMemberValues() {
        return new Variant[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws Exception {
        if (this.isRefreshing()) {
            return;
        }
        this.setRefreshing(true);
        try {
            this.clear();
            Query query = this.getDatabase().createQuery();
            try {
                query.setSqlText(Sql.getPackageMethodList(this.getFilter()));
                query.paramByName("schema_name").setString(this.getSchema().getName());
                query.paramByName("package_name").setString(this.getPackage().getName());
                query.open();
                while (!query.eof()) {
                    OraclePackageMethodInfo info = new OraclePackageMethodInfo(query.fieldByName("method_name").getString(), this);
                    info.setMethodType(query.fieldByName("method_type").getString());
                    this.put(info);
                    query.next();
                }
            }
            finally {
                query.close();
            }
        }
        finally {
            this.setRefreshed(true);
        }
    }
}

