/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.dbinfo;

import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.dbinfo.OraclePrivilegeInfo;
import pl.mpak.orbada.oracle.dbinfo.OracleSchemaInfo;
import pl.mpak.orbada.plugins.dbinfo.DbObjectContainer;
import pl.mpak.orbada.plugins.dbinfo.DbObjectIdentified;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.variant.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OraclePrivilegeListInfo
extends DbObjectContainer<OraclePrivilegeInfo> {
    public OraclePrivilegeListInfo(DbObjectContainer owner) {
        super("PRIVILEGES", (DbObjectIdentified)owner);
    }

    public OracleSchemaInfo getSchema() {
        DbObjectIdentified o = this.getOwner(OracleSchemaInfo.class);
        if (o != null) {
            return (OracleSchemaInfo)o;
        }
        return null;
    }

    public String[] getColumnNames() {
        return new String[]{"Schemat", "Nazwa obiektu", "Nada\u0142", "Dla", "Admin"};
    }

    public String[] getMemberNames() {
        return new String[0];
    }

    public Variant[] getMemberValues() {
        return new Variant[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws Exception {
        if (this.isRefreshing()) {
            return;
        }
        this.setRefreshing(true);
        try {
            this.clear();
            Query query = this.getDatabase().createQuery();
            try {
                query.setSqlText(Sql.getPrivilegeList(this.getFilter()));
                query.paramByName("schema_name").setString(this.getSchema().getName());
                query.paramByName("table_name").setString(((DbObjectIdentified)this.getObjectOwner()).getName());
                query.open();
                while (!query.eof()) {
                    OraclePrivilegeInfo info = new OraclePrivilegeInfo(query.fieldByName("privilege").getString(), this);
                    info.setObjectSchema(query.fieldByName("table_schema").getString());
                    info.setObjectName(query.fieldByName("table_name").getString());
                    info.setGrantee(query.fieldByName("grantee").getString());
                    info.setGrantor(query.fieldByName("grantor").getString());
                    info.setGrantable(query.fieldByName("grantable").getString());
                    this.put(info.getObjectSchema() + "." + info.getObjectName() + "." + info.getName(), info);
                    query.next();
                }
            }
            finally {
                query.close();
            }
        }
        finally {
            this.setRefreshed(true);
        }
    }
}

