/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.dbinfo;

import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.dbinfo.OracleRecyclebinInfo;
import pl.mpak.orbada.oracle.dbinfo.OracleSchemaInfo;
import pl.mpak.orbada.plugins.dbinfo.DbObjectContainer;
import pl.mpak.orbada.plugins.dbinfo.DbObjectIdentified;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.variant.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleRecyclebinListInfo
extends DbObjectContainer<OracleRecyclebinInfo> {
    private boolean onSchema = this.getSchema() != null;

    public OracleRecyclebinListInfo(DbObjectContainer owner) {
        super("RECYCLEBIN", (DbObjectIdentified)owner);
    }

    public OracleSchemaInfo getSchema() {
        DbObjectIdentified o = this.getOwner(OracleSchemaInfo.class);
        if (o != null) {
            return (OracleSchemaInfo)o;
        }
        return null;
    }

    public String[] getColumnNames() {
        if ("TRUE".equalsIgnoreCase(this.getDatabase().getUserProperties().getProperty("dba-role", "false")) && !this.onSchema) {
            return new String[]{"Nazwa schematu", "Nazwa oryginalna", "Typ obiektu", "Operacja", "Utworzony", "Usuni\u0119ty"};
        }
        return new String[]{"Nazwa oryginalna", "Typ obiektu", "Operacja", "Utworzony", "Usuni\u0119ty"};
    }

    public String[] getMemberNames() {
        return new String[0];
    }

    public Variant[] getMemberValues() {
        return new Variant[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws Exception {
        if (this.isRefreshing()) {
            return;
        }
        this.setRefreshing(true);
        try {
            this.clear();
            Query query = this.getDatabase().createQuery();
            try {
                if ("TRUE".equalsIgnoreCase(this.getDatabase().getUserProperties().getProperty("dba-role", "false"))) {
                    query.setSqlText(Sql.getDbaRecyclebinList(this.getFilter()));
                    if (this.onSchema) {
                        query.paramByName("SCHEMA_NAME").setString(this.getSchema().getName());
                    }
                } else {
                    query.setSqlText(Sql.getRecyclebinList(null));
                }
                query.open();
                while (!query.eof()) {
                    OracleRecyclebinInfo info = new OracleRecyclebinInfo(query.fieldByName("object_name").getString(), this);
                    if ("TRUE".equalsIgnoreCase(this.getDatabase().getUserProperties().getProperty("dba-role", "false"))) {
                        info.setSchemaName(query.fieldByName("owner").getString());
                    }
                    info.setOriginalName(query.fieldByName("original_name").getString());
                    info.setType(query.fieldByName("type").getString());
                    info.setOperation(query.fieldByName("operation").getString());
                    info.setCreateTime(query.fieldByName("createtime").getString());
                    info.setDropTime(query.fieldByName("droptime").getString());
                    this.put(info);
                    query.next();
                }
            }
            finally {
                query.close();
            }
        }
        finally {
            this.setRefreshed(true);
        }
    }
}

