/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.dbinfo;

import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.dbinfo.OracleSchemaInfo;
import pl.mpak.orbada.oracle.dbinfo.OracleSequenceInfo;
import pl.mpak.orbada.plugins.dbinfo.DbObjectContainer;
import pl.mpak.orbada.plugins.dbinfo.DbObjectIdentified;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.variant.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleSequenceListInfo
extends DbObjectContainer<OracleSequenceInfo> {
    public OracleSequenceListInfo(OracleSchemaInfo owner) {
        super("SEQUENCES", (DbObjectIdentified)owner);
    }

    public OracleSchemaInfo getSchema() {
        DbObjectIdentified o = this.getOwner(OracleSchemaInfo.class);
        if (o != null) {
            return (OracleSchemaInfo)o;
        }
        return null;
    }

    public String[] getColumnNames() {
        return new String[]{"Warto\u015b\u0107", "Warto\u015b\u0107 min.", "Warto\u015b\u0107 max.", "Inc", "Cykl.", "Porz\u0105d.", "Bufor"};
    }

    public String[] getMemberNames() {
        return new String[0];
    }

    public Variant[] getMemberValues() {
        return new Variant[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws Exception {
        if (this.isRefreshing()) {
            return;
        }
        this.setRefreshing(true);
        try {
            this.clear();
            Query query = this.getDatabase().createQuery();
            try {
                query.setSqlText(Sql.getSequenceList(this.getFilter()));
                query.paramByName("schema_name").setString(this.getSchema().getName());
                query.open();
                while (!query.eof()) {
                    OracleSequenceInfo info = new OracleSequenceInfo(query.fieldByName("sequence_name").getString(), this);
                    info.setMinimumValue(query.fieldByName("min_value").getBigDecimal().toBigInteger());
                    info.setMaximumValue(query.fieldByName("max_value").getBigDecimal().toBigInteger());
                    info.setIncrement(query.fieldByName("increment_by").getBigDecimal().toBigInteger());
                    info.setLastValue(query.fieldByName("last_number").getBigDecimal().toBigInteger());
                    info.setBufferSize(query.fieldByName("cache_size").getBigDecimal().toBigInteger());
                    info.setCycle(query.fieldByName("cycle_flag").getString());
                    info.setOrdered(query.fieldByName("order_flag").getString());
                    this.put(info);
                    query.next();
                }
            }
            finally {
                query.close();
            }
        }
        finally {
            this.setRefreshed(true);
        }
    }
}

