/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.dbinfo;

import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.dbinfo.OracleSchemaInfo;
import pl.mpak.orbada.oracle.dbinfo.OracleSynonymInfo;
import pl.mpak.orbada.plugins.dbinfo.DbObjectContainer;
import pl.mpak.orbada.plugins.dbinfo.DbObjectIdentified;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.variant.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleSynonymListInfo
extends DbObjectContainer<OracleSynonymInfo> {
    public OracleSynonymListInfo(OracleSchemaInfo owner) {
        super("SYNONYMS", (DbObjectIdentified)owner);
    }

    public OracleSchemaInfo getSchema() {
        DbObjectIdentified o = this.getOwner(OracleSchemaInfo.class);
        if (o != null) {
            return (OracleSchemaInfo)o;
        }
        return null;
    }

    public String[] getColumnNames() {
        return new String[]{"Schemat obiektu", "Nazwa obiektu", "Typ obiektu", "Po\u0142\u0105czenie zdalne", "Stan"};
    }

    public String[] getMemberNames() {
        return new String[0];
    }

    public Variant[] getMemberValues() {
        return new Variant[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws Exception {
        if (this.isRefreshing()) {
            return;
        }
        this.setRefreshing(true);
        try {
            this.clear();
            Query query = this.getDatabase().createQuery();
            try {
                query.setSqlText(Sql.getSynonymList(this.getFilter()));
                query.paramByName("schema_name").setString(this.getSchema().getName());
                query.open();
                while (!query.eof()) {
                    OracleSynonymInfo info = new OracleSynonymInfo(query.fieldByName("synonym_name").getString(), this);
                    info.setTableOwner(query.fieldByName("table_owner").getString());
                    info.setTableName(query.fieldByName("table_name").getString());
                    info.setObjectType(query.fieldByName("object_type").getString());
                    info.setDbLink(query.fieldByName("db_link").getString());
                    info.setStatus(query.fieldByName("status").getString());
                    this.put(info);
                    query.next();
                }
            }
            finally {
                query.close();
            }
        }
        finally {
            this.setRefreshed(true);
        }
    }
}

