/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.dbinfo;

import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.dbinfo.OracleTablespaceInfo;
import pl.mpak.orbada.plugins.dbinfo.DbObjectContainer;
import pl.mpak.orbada.plugins.dbinfo.DbObjectIdentified;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.variant.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleTablespaceListInfo
extends DbObjectContainer<OracleTablespaceInfo> {
    public OracleTablespaceListInfo(DbObjectContainer owner) {
        super("TABLESPACES", (DbObjectIdentified)owner);
    }

    public String[] getColumnNames() {
        return new String[]{"Rozmiar bloku", "Init.Ext.", "Next Ext.", "Min Ext.", "Max Ext.", "Status", "Zawarto\u015b\u0107"};
    }

    public String[] getMemberNames() {
        return new String[0];
    }

    public Variant[] getMemberValues() {
        return new Variant[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws Exception {
        if (this.isRefreshing()) {
            return;
        }
        this.setRefreshing(true);
        try {
            this.clear();
            Query query = this.getDatabase().createQuery();
            try {
                if ("TRUE".equalsIgnoreCase(this.getDatabase().getUserProperties().getProperty("dba-role", "false"))) {
                    query.setSqlText(Sql.getDbaTablespaceList());
                } else {
                    query.setSqlText(Sql.getTablespaceList());
                }
                query.open();
                while (!query.eof()) {
                    OracleTablespaceInfo info = new OracleTablespaceInfo(query.fieldByName("tablespace_name").getString(), this);
                    info.setBlockSize(query.fieldByName("block_size").getLong());
                    info.setInitialExtent(query.fieldByName("initial_extent").getBigDecimal().toBigInteger());
                    if (!query.fieldByName("next_extent").isNull()) {
                        info.setNextExtent(query.fieldByName("next_extent").getBigDecimal().toBigInteger());
                    }
                    if (!query.fieldByName("min_extents").isNull()) {
                        info.setMinExtents(query.fieldByName("min_extents").getBigDecimal().toBigInteger());
                    }
                    if (!query.fieldByName("max_extents").isNull()) {
                        info.setMaxExtents(query.fieldByName("max_extents").getBigDecimal().toBigInteger());
                    }
                    info.setStatus(query.fieldByName("status").getString());
                    info.setContents(query.fieldByName("contents").getString());
                    this.put(info);
                    query.next();
                }
            }
            finally {
                query.close();
            }
        }
        finally {
            this.setRefreshed(true);
        }
    }
}

