/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.dbinfo;

import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.dbinfo.OracleSchemaInfo;
import pl.mpak.orbada.oracle.dbinfo.OracleTriggerInfo;
import pl.mpak.orbada.oracle.services.OracleDbInfoProvider;
import pl.mpak.orbada.plugins.dbinfo.DbObjectContainer;
import pl.mpak.orbada.plugins.dbinfo.DbObjectIdentified;
import pl.mpak.orbada.plugins.dbinfo.DbObjectInfo;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.StringUtil;
import pl.mpak.util.variant.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleTriggerListInfo
extends DbObjectContainer<OracleTriggerInfo> {
    private boolean onTable;

    public OracleTriggerListInfo(DbObjectContainer owner) {
        super("TRIGGERS", (DbObjectIdentified)owner);
        DbObjectInfo info = this.getObjectOwner();
        this.onTable = info != null && StringUtil.equalAnyOfString((String)info.getObjectType(), (String[])new String[]{"TABLE", "VIEW", "MATERIALIZED VIEW"}, (boolean)true);
    }

    public OracleSchemaInfo getSchema() {
        DbObjectIdentified o = this.getOwner(OracleSchemaInfo.class);
        if (o != null) {
            return (OracleSchemaInfo)o;
        }
        return null;
    }

    public String[] getColumnNames() {
        if (this.onTable) {
            return new String[]{"Stan", "W\u0142\u0105czony", "Zda\u017cenie", "Typ", "Kiedy"};
        }
        return new String[]{"Nazwa tabeli", "Stan", "W\u0142\u0105czony", "Zda\u017cenie", "Typ", "Kiedy"};
    }

    public String[] getMemberNames() {
        return new String[0];
    }

    public Variant[] getMemberValues() {
        return new Variant[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws Exception {
        if (this.isRefreshing()) {
            return;
        }
        this.setRefreshing(true);
        try {
            this.clear();
            Query query = this.getDatabase().createQuery();
            try {
                if (this.onTable) {
                    query.setSqlText(Sql.getTableTriggerList(this.getFilter()));
                    query.paramByName("table_name").setString(((DbObjectIdentified)this.getObjectOwner()).getName());
                } else {
                    query.setSqlText(Sql.getAllTriggerList(null, OracleDbInfoProvider.instance.getMajorVersion(this.getDatabase())));
                }
                query.paramByName("schema_name").setString(this.getSchema().getName());
                query.open();
                while (!query.eof()) {
                    OracleTriggerInfo info = new OracleTriggerInfo(query.fieldByName("trigger_name").getString(), this);
                    info.setTableName(query.fieldByName("table_name").getString());
                    info.setEnabled(query.fieldByName("enabled").getString());
                    info.setState(query.fieldByName("status").getString());
                    info.setEvent(query.fieldByName("triggering_event").getString());
                    info.setType(query.fieldByName("trigger_type").getString());
                    info.setWhen(query.fieldByName("when_clause").getString());
                    this.put(info);
                    query.next();
                }
            }
            finally {
                query.close();
            }
        }
        finally {
            this.setRefreshed(true);
        }
    }
}

