/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.dbinfo;

import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.dbinfo.OracleSchemaInfo;
import pl.mpak.orbada.oracle.dbinfo.OracleTypeAttrInfo;
import pl.mpak.orbada.oracle.dbinfo.OracleTypeInfo;
import pl.mpak.orbada.plugins.dbinfo.DbObjectContainer;
import pl.mpak.orbada.plugins.dbinfo.DbObjectIdentified;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.variant.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleTypeAttrListInfo
extends DbObjectContainer<OracleTypeAttrInfo> {
    public OracleTypeAttrListInfo(OracleTypeInfo owner) {
        super("ATTRIBUTES", (DbObjectIdentified)owner);
    }

    public OracleSchemaInfo getSchema() {
        DbObjectIdentified o = this.getOwner(OracleSchemaInfo.class);
        if (o != null) {
            return (OracleSchemaInfo)o;
        }
        return null;
    }

    public OracleTypeInfo getType() {
        DbObjectIdentified o = this.getOwner(OracleTypeInfo.class);
        if (o != null) {
            return (OracleTypeInfo)o;
        }
        return null;
    }

    public String[] getColumnNames() {
        return new String[]{"Lp", "Typ", "D\u0142ugo\u015b\u0107", "Precyzja", "Skala"};
    }

    public String[] getMemberNames() {
        return new String[0];
    }

    public Variant[] getMemberValues() {
        return new Variant[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws Exception {
        if (this.isRefreshing()) {
            return;
        }
        this.setRefreshing(true);
        try {
            this.clear();
            Query query = this.getDatabase().createQuery();
            try {
                query.setSqlText(Sql.getTypeAttrList(this.getFilter()));
                query.paramByName("schema_name").setString(this.getSchema().getName());
                query.paramByName("type_name").setString(this.getType().getName());
                query.open();
                while (!query.eof()) {
                    OracleTypeAttrInfo column = new OracleTypeAttrInfo(query.fieldByName("attr_name").getString(), this);
                    column.setAttrTypeName(query.fieldByName("attr_type_name").getString());
                    column.setAttrNo(query.fieldByName("attr_no").getLong());
                    column.setLength(query.fieldByName("length").isNull() ? null : Long.valueOf(query.fieldByName("length").getLong()));
                    column.setPrecision(query.fieldByName("precision").isNull() ? null : Long.valueOf(query.fieldByName("precision").getLong()));
                    column.setScale(query.fieldByName("scale").isNull() ? null : Long.valueOf(query.fieldByName("scale").getLong()));
                    this.put(column);
                    query.next();
                }
            }
            finally {
                query.close();
            }
        }
        finally {
            this.setRefreshed(true);
        }
    }
}

