/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.dbinfo;

import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.dbinfo.OracleSchemaInfo;
import pl.mpak.orbada.oracle.dbinfo.OracleTypeInfo;
import pl.mpak.orbada.oracle.dbinfo.OracleTypeMethodInfo;
import pl.mpak.orbada.plugins.dbinfo.DbObjectContainer;
import pl.mpak.orbada.plugins.dbinfo.DbObjectIdentified;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.variant.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleTypeMethodListInfo
extends DbObjectContainer<OracleTypeMethodInfo> {
    public OracleTypeMethodListInfo(OracleTypeInfo owner) {
        super("METHODS", (DbObjectIdentified)owner);
    }

    public OracleSchemaInfo getSchema() {
        DbObjectIdentified o = this.getOwner(OracleSchemaInfo.class);
        if (o != null) {
            return (OracleSchemaInfo)o;
        }
        return null;
    }

    public OracleTypeInfo getType() {
        DbObjectIdentified o = this.getOwner(OracleTypeInfo.class);
        if (o != null) {
            return (OracleTypeInfo)o;
        }
        return null;
    }

    public String[] getColumnNames() {
        return new String[]{"Lp", "Zakres", "Typ"};
    }

    public String[] getMemberNames() {
        return new String[0];
    }

    public Variant[] getMemberValues() {
        return new Variant[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws Exception {
        if (this.isRefreshing()) {
            return;
        }
        this.setRefreshing(true);
        try {
            this.clear();
            Query query = this.getDatabase().createQuery();
            try {
                query.setSqlText(Sql.getTypeMethodList(this.getFilter()));
                query.paramByName("schema_name").setString(this.getSchema().getName());
                query.paramByName("type_name").setString(this.getType().getName());
                query.open();
                while (!query.eof()) {
                    OracleTypeMethodInfo info = new OracleTypeMethodInfo(query.fieldByName("method_name").getString(), this);
                    info.setMethodRange(query.fieldByName("method_range").getString());
                    info.setMethodType(query.fieldByName("method_type").getString());
                    info.setMethodNo(query.fieldByName("method_no").getLong());
                    this.put(info);
                    query.next();
                }
            }
            finally {
                query.close();
            }
        }
        finally {
            this.setRefreshed(true);
        }
    }
}

