/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.dbinfo;

import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.dbinfo.OracleSchemaInfo;
import pl.mpak.orbada.oracle.dbinfo.OracleViewColumnInfo;
import pl.mpak.orbada.oracle.dbinfo.OracleViewInfo;
import pl.mpak.orbada.plugins.dbinfo.DbObjectContainer;
import pl.mpak.orbada.plugins.dbinfo.DbObjectIdentified;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.variant.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleViewColumnListInfo
extends DbObjectContainer<OracleViewColumnInfo> {
    public OracleViewColumnListInfo(OracleViewInfo owner) {
        super("COLUMNS", (DbObjectIdentified)owner);
    }

    public OracleSchemaInfo getSchema() {
        DbObjectIdentified o = this.getOwner(OracleSchemaInfo.class);
        if (o != null) {
            return (OracleSchemaInfo)o;
        }
        return null;
    }

    public OracleViewInfo getView() {
        DbObjectIdentified o = this.getOwner(OracleViewInfo.class);
        if (o != null) {
            return (OracleViewInfo)o;
        }
        return null;
    }

    public String[] getColumnNames() {
        return new String[]{"Pozycja", "Typ", "Null?", "Zmiana", "Komentarz"};
    }

    public String[] getMemberNames() {
        return new String[0];
    }

    public Variant[] getMemberValues() {
        return new Variant[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws Exception {
        if (this.isRefreshing()) {
            return;
        }
        this.setRefreshing(true);
        try {
            this.clear();
            Query query = this.getDatabase().createQuery();
            try {
                query.setSqlText(Sql.getViewColumnList(this.getFilter()));
                query.paramByName("schema_name").setString(this.getSchema().getName());
                query.paramByName("view_name").setString(this.getView().getName());
                query.open();
                while (!query.eof()) {
                    OracleViewColumnInfo column = new OracleViewColumnInfo(query.fieldByName("column_name").getString(), this);
                    column.setRemarks(query.fieldByName("remarks").getString());
                    column.setPosition(query.fieldByName("column_id").getInteger());
                    column.setType(query.fieldByName("display_type").getString());
                    column.setNullable("YES".equalsIgnoreCase(query.fieldByName("nullable").getString()));
                    column.setUpdatable("YES".equalsIgnoreCase(query.fieldByName("updatable").getString()));
                    this.put(column);
                    query.next();
                }
            }
            finally {
                query.close();
            }
        }
        finally {
            this.setRefreshed(true);
        }
    }
}

