/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class ObjectUsingPanel
extends JPanel
implements ITabObjectInfo {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName = "";
    private String currentObjectName = "";
    private String objectType;
    private boolean requestRefresh = false;
    private boolean closing = false;
    private SqlFilter filter;
    private ToolButton buttonActions;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private Action cmFilter;
    private Action cmRefresh;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JPopupMenu menuActions;
    private QueryTableStatusBar statusBarIndexes;
    private ViewTable tableUsing;
    private JToolBar toolBarIndexes;

    public ObjectUsingPanel(IViewAccesibilities accesibilities, String objectType) {
        this.accesibilities = accesibilities;
        this.objectType = objectType;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.tableUsing.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableUsing.addColumn((TableColumn)new QueryTableColumn("schema_name", this.stringManager.getString("schema"), 120));
            this.tableUsing.addColumn((TableColumn)new QueryTableColumn("object_name", this.stringManager.getString("obejct-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableUsing.addColumn((TableColumn)new QueryTableColumn("object_type", this.stringManager.getString("object-type"), 100, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.GREEN)));
            this.tableUsing.addColumn((TableColumn)new QueryTableColumn("dependency_type", this.stringManager.getString("dependency-type"), 80));
            this.tableUsing.addColumn((TableColumn)new QueryTableColumn("status", this.stringManager.getString("status"), 50));
            SqlFilterDef def = new SqlFilterDef();
            def.add(new SqlFilterDefComponent("referenced_owner", this.stringManager.getString("schema"), (String[])null));
            def.add(new SqlFilterDefComponent("referenced_name", this.stringManager.getString("object-name"), (String[])null));
            def.add(new SqlFilterDefComponent("referenced_type", this.stringManager.getString("object-type"), new String[]{"", "'TABLE'", "'VIEW'", "'FUNCTION'", "'PROCEDURE'"}));
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-" + this.objectType + "-using-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableUsing, (JButton)this.buttonActions, this.menuActions, "oracle-using-actions");
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public String getTitle() {
        return this.stringManager.getString("ObjectUsingPanel-title");
    }

    private void refreshTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ObjectUsingPanel.this.refresh();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        try {
            this.cmRefresh.setEnabled(false);
            try {
                this.requestRefresh = false;
                this.tableUsing.getQuery().close();
                this.tableUsing.getQuery().setSqlText(Sql.getUsingList(this.filter.getSqlText()));
                this.tableUsing.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
                this.tableUsing.getQuery().paramByName("object_name").setString(this.currentObjectName);
                this.tableUsing.getQuery().paramByName("object_type").setString(this.objectType);
                this.tableUsing.getQuery().open();
                if (!this.tableUsing.getQuery().isEmpty()) {
                    this.tableUsing.changeSelection(0, 0);
                }
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
        finally {
            this.cmRefresh.setEnabled(true);
        }
    }

    public void refresh(String catalogName, String schemaName, String objectName) {
        if (!this.currentSchemaName.equals(schemaName) || !this.currentObjectName.equals(objectName) || this.requestRefresh) {
            this.currentSchemaName = schemaName;
            this.currentObjectName = objectName;
            if (this.isVisible()) {
                this.refresh();
            } else {
                this.requestRefresh = true;
            }
        }
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.closing = true;
        this.tableUsing.getQuery().close();
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.menuActions = new JPopupMenu();
        this.statusBarIndexes = new QueryTableStatusBar();
        this.jPanel1 = new JPanel();
        this.toolBarIndexes = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.jScrollPane1 = new JScrollPane();
        this.tableUsing = new ViewTable();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ObjectUsingPanel.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ObjectUsingPanel.this.cmFilterActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                ObjectUsingPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.statusBarIndexes.setShowFieldType(false);
        this.statusBarIndexes.setShowOpenTime(false);
        this.statusBarIndexes.setTable((QueryTable)this.tableUsing);
        this.add((Component)this.statusBarIndexes, "Last");
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarIndexes.setFloatable(false);
        this.toolBarIndexes.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarIndexes.add((Component)this.buttonRefresh);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarIndexes.add((Component)this.buttonFilter);
        this.toolBarIndexes.add(this.jSeparator1);
        this.toolBarIndexes.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBarIndexes);
        this.add((Component)this.jPanel1, "North");
        this.jScrollPane1.setViewportView((Component)this.tableUsing);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void formComponentShown(ComponentEvent evt) {
        if (this.requestRefresh && !this.closing) {
            this.refreshTask();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }
}

