/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class StoredParametersPanel
extends JPanel
implements ITabObjectInfo {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName = "";
    private String currentPackageName = "";
    private String objectType;
    private boolean requestRefresh = false;
    private boolean closing = false;
    private ToolButton buttonActions;
    private ToolButton buttonRefresh;
    private Action cmRefresh;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JPopupMenu menuActions;
    private QueryTableStatusBar statusBar;
    private ViewTable tableParameters;
    private JToolBar toolBar;

    public StoredParametersPanel(IViewAccesibilities accesibilities, String objectType) {
        this.accesibilities = accesibilities;
        this.objectType = objectType;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.tableParameters.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableParameters.addColumn((TableColumn)new QueryTableColumn("param_name", this.stringManager.getString("param-name"), 150));
            this.tableParameters.addColumn((TableColumn)new QueryTableColumn("param_value", this.stringManager.getString("param-value"), 300));
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableParameters, (JButton)this.buttonActions, this.menuActions, "oracle-stored-parameters-actions");
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public String getTitle() {
        return this.stringManager.getString("StoredParametersPanel-title");
    }

    private void refreshTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                StoredParametersPanel.this.refresh();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        try {
            this.cmRefresh.setEnabled(false);
            try {
                this.requestRefresh = false;
                this.tableParameters.getQuery().close();
                this.tableParameters.getQuery().setSqlText(Sql.getStoredParametersList(null));
                this.tableParameters.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
                this.tableParameters.getQuery().paramByName("object_name").setString(this.currentPackageName);
                this.tableParameters.getQuery().paramByName("object_type").setString(this.objectType);
                this.tableParameters.getQuery().open();
                if (!this.tableParameters.getQuery().isEmpty()) {
                    this.tableParameters.changeSelection(0, 0);
                }
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
        finally {
            this.cmRefresh.setEnabled(true);
        }
    }

    public void refresh(String catalogName, String schemaName, String objectName) {
        if (!this.currentSchemaName.equals(schemaName) || !this.currentPackageName.equals(objectName) || this.requestRefresh) {
            this.currentSchemaName = schemaName;
            this.currentPackageName = objectName;
            if (this.isVisible()) {
                this.refresh();
            } else {
                this.requestRefresh = true;
            }
        }
    }

    public Query getQuery() {
        return this.tableParameters.getQuery();
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.closing = true;
        this.tableParameters.getQuery().close();
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.menuActions = new JPopupMenu();
        this.statusBar = new QueryTableStatusBar();
        this.jPanel1 = new JPanel();
        this.toolBar = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.jScrollPane1 = new JScrollPane();
        this.tableParameters = new ViewTable();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StoredParametersPanel.this.cmRefreshActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                StoredParametersPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.statusBar.setShowFieldType(false);
        this.statusBar.setShowOpenTime(false);
        this.statusBar.setTable((QueryTable)this.tableParameters);
        this.add((Component)this.statusBar, "Last");
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonRefresh);
        this.toolBar.add(this.jSeparator1);
        this.toolBar.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBar);
        this.add((Component)this.jPanel1, "North");
        this.jScrollPane1.setViewportView((Component)this.tableParameters);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private void formComponentShown(ComponentEvent evt) {
        if (this.requestRefresh && !this.closing) {
            this.refreshTask();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }
}

