/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.dblinks;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.gui.util.SimpleSelectDialog;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.gui.wizards.CreateDbLinkWizard;
import pl.mpak.orbada.oracle.gui.wizards.DropDbLinkWizard;
import pl.mpak.orbada.oracle.services.OracleDbInfoProvider;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.QueryUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class DbLinksPanelView
extends JPanel
implements IRootTabObjectInfo {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName;
    private String tabTitle;
    private SqlFilter filter;
    private boolean viewClosing = false;
    private ToolButton buttonActions;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private ToolButton buttonSelectSchema;
    private Action cmCreateDbLink;
    private Action cmDropDbLink;
    private Action cmFilter;
    private Action cmRefresh;
    private Action cmSelectSchema;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JSeparator jSeparator2;
    private JPopupMenu menuActions;
    private JMenuItem menuCreateDbLink;
    private JMenuItem menuDropDbLink;
    private QueryTableStatusBar statusBar;
    private ViewTable tableSynonyms;
    private JToolBar toolBar;

    public DbLinksPanelView(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.tabTitle = this.accesibilities.getTabTitle();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.currentSchemaName = OracleDbInfoProvider.getCurrentSchema(this.getDatabase());
        this.tableSynonyms.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableSynonyms.addColumn((TableColumn)new QueryTableColumn("db_link", this.stringManager.getString("db-link-name"), 300, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableSynonyms.addColumn((TableColumn)new QueryTableColumn("username", this.stringManager.getString("user-name"), 150));
            this.tableSynonyms.addColumn((TableColumn)new QueryTableColumn("host", this.stringManager.getString("destination-host"), 180));
            this.tableSynonyms.addColumn((TableColumn)new QueryTableColumn("created", this.stringManager.getString("created"), 110));
            SqlFilterDef def = new SqlFilterDef();
            def.add(new SqlFilterDefComponent("db_link", this.stringManager.getString("db-link-name"), (String[])null));
            def.add(new SqlFilterDefComponent("username", this.stringManager.getString("user-name"), (String[])null));
            def.add(new SqlFilterDefComponent("host", this.stringManager.getString("destination-host"), (String[])null));
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-dblinks-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableSynonyms, (JButton)this.buttonActions, this.menuActions, "oracle-dblinks-actions");
    }

    public void setCurrentSchemaName(String schemaName) {
        if (!this.currentSchemaName.equals(schemaName)) {
            this.currentSchemaName = schemaName;
            if (!this.currentSchemaName.equalsIgnoreCase(OracleDbInfoProvider.getCurrentSchema(this.getDatabase()))) {
                this.accesibilities.setTabTitle(this.tabTitle + " (" + this.currentSchemaName + ")");
            } else {
                this.accesibilities.setTabTitle(this.tabTitle);
            }
        }
    }

    private void refreshTableListTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                DbLinksPanelView.this.refresh();
            }
        });
    }

    public void refresh() {
        if (!this.isVisible() || this.viewClosing) {
            return;
        }
        try {
            String objectName = null;
            if (this.tableSynonyms.getQuery().isActive() && this.tableSynonyms.getSelectedRow() >= 0) {
                this.tableSynonyms.getQuery().getRecord(this.tableSynonyms.getSelectedRow());
                objectName = this.tableSynonyms.getQuery().fieldByName("db_link").getString();
            }
            this.refresh(objectName);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public void refresh(String objectName) {
        try {
            int column = this.tableSynonyms.getSelectedColumn();
            int index = Math.max(0, this.tableSynonyms.getSelectedRow());
            this.tableSynonyms.getQuery().close();
            this.tableSynonyms.getQuery().setSqlText(Sql.getDbLinkList(this.filter.getSqlText()));
            this.tableSynonyms.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
            this.tableSynonyms.getQuery().open();
            if (objectName != null && this.tableSynonyms.getQuery().locate("db_link", new Variant(objectName))) {
                this.tableSynonyms.changeSelection(this.tableSynonyms.getQuery().getCurrentRecord().getIndex(), column);
            } else if (!this.tableSynonyms.getQuery().isEmpty()) {
                this.tableSynonyms.changeSelection(Math.min(index, this.tableSynonyms.getRowCount() - 1), column);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.viewClosing = true;
        this.tableSynonyms.getQuery().close();
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.cmSelectSchema = new Action();
        this.menuActions = new JPopupMenu();
        this.menuCreateDbLink = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.menuDropDbLink = new JMenuItem();
        this.cmDropDbLink = new Action();
        this.cmCreateDbLink = new Action();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableSynonyms = new ViewTable();
        this.statusBar = new QueryTableStatusBar();
        this.jPanel2 = new JPanel();
        this.toolBar = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonSelectSchema = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DbLinksPanelView.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DbLinksPanelView.this.cmFilterActionPerformed(evt);
            }
        });
        this.cmSelectSchema.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/users16.gif"));
        this.cmSelectSchema.setText(this.stringManager.getString("cmSelectSchema-text"));
        this.cmSelectSchema.setTooltip(this.stringManager.getString("cmSelectSchema-hint"));
        this.cmSelectSchema.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DbLinksPanelView.this.cmSelectSchemaActionPerformed(evt);
            }
        });
        this.menuCreateDbLink.setAction((javax.swing.Action)this.cmCreateDbLink);
        this.menuActions.add(this.menuCreateDbLink);
        this.menuActions.add(this.jSeparator2);
        this.menuDropDbLink.setAction((javax.swing.Action)this.cmDropDbLink);
        this.menuActions.add(this.menuDropDbLink);
        this.cmDropDbLink.setActionCommandKey("cmDropDbLink");
        this.cmDropDbLink.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDropDbLink.setText(this.stringManager.getString("cmDropDbLink-text"));
        this.cmDropDbLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DbLinksPanelView.this.cmDropDbLinkActionPerformed(evt);
            }
        });
        this.cmCreateDbLink.setActionCommandKey("cmCreateDbLink");
        this.cmCreateDbLink.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/db_link.gif"));
        this.cmCreateDbLink.setText(this.stringManager.getString("cmCreateDbLink-text"));
        this.cmCreateDbLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DbLinksPanelView.this.cmCreateDbLinkActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                DbLinksPanelView.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableSynonyms);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.statusBar.setShowFieldType(false);
        this.statusBar.setShowOpenTime(false);
        this.statusBar.setTable((QueryTable)this.tableSynonyms);
        this.jPanel1.add((Component)this.statusBar, "South");
        this.add((Component)this.jPanel1, "Center");
        this.jPanel2.setLayout(new FlowLayout(0, 0, 0));
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonRefresh);
        this.buttonSelectSchema.setAction((javax.swing.Action)this.cmSelectSchema);
        this.buttonSelectSchema.setHorizontalTextPosition(0);
        this.buttonSelectSchema.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonSelectSchema);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonFilter);
        this.toolBar.add(this.jSeparator1);
        this.toolBar.add((Component)this.buttonActions);
        this.jPanel2.add(this.toolBar);
        this.add((Component)this.jPanel2, "North");
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void formComponentShown(ComponentEvent evt) {
        if (!this.tableSynonyms.getQuery().isActive()) {
            this.refresh();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmSelectSchemaActionPerformed(ActionEvent evt) {
        Query query = this.getDatabase().createQuery();
        try {
            query.open(Sql.getSchemaList());
            Vector vl = QueryUtil.staticData((String)"{schema_name}", (Query)query);
            Point point = this.buttonSelectSchema.getLocationOnScreen();
            point.y += this.buttonSelectSchema.getHeight();
            SimpleSelectDialog.select((Window)SwingUtil.getWindowComponent((Component)this), (int)point.x, (int)point.y, (Vector)vl, (int)vl.indexOf(this.currentSchemaName), (SimpleSelectDialog.CallBack)new SimpleSelectDialog.CallBack(){

                public void selected(Object o) {
                    DbLinksPanelView.this.setCurrentSchemaName(o.toString());
                    DbLinksPanelView.this.refresh();
                }
            });
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
    }

    private void cmDropDbLinkActionPerformed(ActionEvent evt) {
        if (this.tableSynonyms.getSelectedRow() >= 0) {
            try {
                this.tableSynonyms.getQuery().getRecord(this.tableSynonyms.getSelectedRow());
                String dbLinkName = this.tableSynonyms.getQuery().fieldByName("db_link").getString();
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new DropDbLinkWizard(this.getDatabase(), this.currentSchemaName, dbLinkName), (boolean)true) != null) {
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmCreateDbLinkActionPerformed(ActionEvent evt) {
        if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateDbLinkWizard(this.getDatabase(), this.currentSchemaName), (boolean)true) != null) {
            this.refresh();
        }
    }
}

