/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.dbmsoutput;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.services.OracleDbmsOutputSettingsProvider;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.TextArea;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Command;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.FileUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.files.FileExtensionFilter;
import pl.mpak.util.timer.Timer;

public class DbmsOutputPanelView
extends JPanel
implements Closeable {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private IViewAccesibilities accesibilities;
    private boolean viewClosing = false;
    private ISettings settings;
    private boolean outputEnable = false;
    private Icon iconEnabled;
    private Icon iconDisabled;
    private Timer timer;
    private ToolButton buttonClear;
    private ToolButton buttonRefresh;
    private ToolButton buttonSave;
    private ToolButton buttonSwitchEnable;
    private Action cmClearDbmsOutput;
    private Action cmRefreshDbmsOutput;
    private Action cmSaveToFile;
    private Action cmSwitchEnableDbmsOutput;
    private JComboBox comboRefresh;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JLabel labelRefresh;
    private TextArea textOutput;
    private JToolBar toolBarTriggers;

    public DbmsOutputPanelView(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.iconEnabled = ImageManager.getImage((String)"/pl/mpak/res/icons/service_start.gif");
        this.iconDisabled = ImageManager.getImage((String)"/pl/mpak/res/icons/service_stop.gif");
        this.initComponents();
        this.init();
    }

    private void init() {
        this.settings = this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), OracleDbmsOutputSettingsProvider.settingsName);
        if (this.settings.getValue(OracleDbmsOutputSettingsProvider.setUseGlobalSettings, Boolean.valueOf(true)).booleanValue()) {
            this.settings = this.accesibilities.getApplication().getSettings(OracleDbmsOutputSettingsProvider.settingsName);
        }
        this.timer = new Timer(1000L){

            public void run() {
                DbmsOutputPanelView.this.refreshOutput();
            }
        };
        OrbadaOraclePlugin.getRefreshQueue().add(this.timer);
        if (this.settings.getValue(OracleDbmsOutputSettingsProvider.setOnStartupViewEnable, Boolean.valueOf(true)).booleanValue()) {
            this.cmSwitchEnableDbmsOutput.performe();
        }
        this.updateEnable();
        this.comboRefresh.setSelectedItem(this.settings.getValue(OracleDbmsOutputSettingsProvider.setRefreshInterval, "5"));
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public void close() throws IOException {
        this.viewClosing = true;
        if (this.outputEnable) {
            this.cmSwitchEnableDbmsOutput.performe();
        }
        this.timer.cancel();
        this.timer = null;
        this.accesibilities = null;
    }

    private void refreshOutput() {
        if (this.outputEnable && SwingUtil.isVisible((Component)this)) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    DbmsOutputPanelView.this.labelRefresh.setEnabled(true);
                }
            });
            EventQueue.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        Command command = DbmsOutputPanelView.this.getDatabase().createCommand();
                        command.setSqlText(Sql.getDbmsOutputLine());
                        command.paramByName("TEXT").setParamMode(4, 12);
                        command.paramByName("STATUS").setParamMode(4, 4);
                        boolean hasMore = true;
                        while (hasMore && !DbmsOutputPanelView.this.viewClosing) {
                            command.execute();
                            hasMore = command.paramByName("STATUS").getInteger() == 0;
                            if (!hasMore) continue;
                            DbmsOutputPanelView.this.textOutput.append(command.paramByName("TEXT").getString() + "\n");
                        }
                    }
                    catch (Exception ex) {
                        try {
                            ExceptionUtil.processException((Throwable)ex);
                            DbmsOutputPanelView.this.textOutput.append(ex.getMessage() + "\n");
                        }
                        catch (Throwable throwable) {
                            EventQueue.invokeLater(new Runnable(){

                                public void run() {
                                    DbmsOutputPanelView.this.labelRefresh.setEnabled(false);
                                }
                            });
                            throw throwable;
                        }
                        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                    EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            });
        }
    }

    private void updateEnable() {
        this.cmRefreshDbmsOutput.setEnabled(this.outputEnable);
        if (this.outputEnable) {
            this.cmSwitchEnableDbmsOutput.setSmallIcon(this.iconDisabled);
            this.cmSwitchEnableDbmsOutput.setTooltip(this.stringManager.getString("cmSwitchEnableDbmsOutput-hint-enabled"));
        } else {
            this.cmSwitchEnableDbmsOutput.setSmallIcon(this.iconEnabled);
            this.cmSwitchEnableDbmsOutput.setTooltip(this.stringManager.getString("cmSwitchEnableDbmsOutput-hint-disabled"));
        }
        if (this.timer != null) {
            this.timer.setEnabled(this.outputEnable && this.isVisible());
        }
    }

    private long getRefreshTime() {
        if (this.comboRefresh.getSelectedIndex() == 0) {
            return 1000000L;
        }
        return (long)(Double.parseDouble(this.comboRefresh.getSelectedItem().toString()) * 1000.0);
    }

    private void initComponents() {
        this.cmRefreshDbmsOutput = new Action();
        this.cmSwitchEnableDbmsOutput = new Action();
        this.cmClearDbmsOutput = new Action();
        this.cmSaveToFile = new Action();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.textOutput = new TextArea();
        this.jPanel2 = new JPanel();
        this.toolBarTriggers = new JToolBar();
        this.buttonSwitchEnable = new ToolButton();
        this.buttonRefresh = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonClear = new ToolButton();
        this.buttonSave = new ToolButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jLabel1 = new JLabel();
        this.comboRefresh = new JComboBox();
        this.jLabel2 = new JLabel();
        this.labelRefresh = new JLabel();
        this.cmRefreshDbmsOutput.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefreshDbmsOutput.setText(this.stringManager.getString("cmRefreshDbmsOutput-text"));
        this.cmRefreshDbmsOutput.setTooltip(this.stringManager.getString("cmRefreshDbmsOutput-hint"));
        this.cmRefreshDbmsOutput.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DbmsOutputPanelView.this.cmRefreshDbmsOutputActionPerformed(evt);
            }
        });
        this.cmSwitchEnableDbmsOutput.setActionCommandKey("cmSwitchEnableDbmsOutput");
        this.cmSwitchEnableDbmsOutput.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/service_start.gif"));
        this.cmSwitchEnableDbmsOutput.setText(this.stringManager.getString("cmSwitchEnableDbmsOutput-text"));
        this.cmSwitchEnableDbmsOutput.setTooltip(this.stringManager.getString("cmSwitchEnableDbmsOutput-hint"));
        this.cmSwitchEnableDbmsOutput.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DbmsOutputPanelView.this.cmSwitchEnableDbmsOutputActionPerformed(evt);
            }
        });
        this.cmClearDbmsOutput.setActionCommandKey("cmClearDbmsOutput");
        this.cmClearDbmsOutput.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/new16.gif"));
        this.cmClearDbmsOutput.setText(this.stringManager.getString("cmClearDbmsOutput-text"));
        this.cmClearDbmsOutput.setTooltip(this.stringManager.getString("cmClearDbmsOutput-hint"));
        this.cmClearDbmsOutput.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DbmsOutputPanelView.this.cmClearDbmsOutputActionPerformed(evt);
            }
        });
        this.cmSaveToFile.setActionCommandKey("cmSaveToFile");
        this.cmSaveToFile.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/save16.gif"));
        this.cmSaveToFile.setText(this.stringManager.getString("cmSaveToFile-text"));
        this.cmSaveToFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DbmsOutputPanelView.this.cmSaveToFileActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent evt) {
                DbmsOutputPanelView.this.formComponentHidden(evt);
            }

            public void componentShown(ComponentEvent evt) {
                DbmsOutputPanelView.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.textOutput.setColumns(20);
        this.textOutput.setEditable(false);
        this.textOutput.setRows(5);
        this.textOutput.setFont(new Font("Courier New", 0, 11));
        this.jScrollPane1.setViewportView((Component)this.textOutput);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.add((Component)this.jPanel1, "Center");
        this.jPanel2.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarTriggers.setFloatable(false);
        this.toolBarTriggers.setRollover(true);
        this.buttonSwitchEnable.setAction((javax.swing.Action)this.cmSwitchEnableDbmsOutput);
        this.buttonSwitchEnable.setHorizontalTextPosition(0);
        this.buttonSwitchEnable.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.buttonSwitchEnable);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefreshDbmsOutput);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.buttonRefresh);
        this.toolBarTriggers.add(this.jSeparator1);
        this.buttonClear.setAction((javax.swing.Action)this.cmClearDbmsOutput);
        this.buttonClear.setHorizontalTextPosition(0);
        this.buttonClear.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.buttonClear);
        this.buttonSave.setAction((javax.swing.Action)this.cmSaveToFile);
        this.buttonSave.setHorizontalTextPosition(0);
        this.buttonSave.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.buttonSave);
        this.toolBarTriggers.add(this.jSeparator2);
        this.jLabel1.setText(this.stringManager.getString("refresh-dd"));
        this.toolBarTriggers.add(this.jLabel1);
        this.comboRefresh.setModel(new DefaultComboBoxModel<String>(new String[]{"off", "0.5", "1", "5", "10", "30", "60", "120"}));
        this.comboRefresh.setPreferredSize(new Dimension(60, 22));
        this.comboRefresh.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                DbmsOutputPanelView.this.comboRefreshItemStateChanged(evt);
            }
        });
        this.toolBarTriggers.add(this.comboRefresh);
        this.jLabel2.setText(" s ");
        this.toolBarTriggers.add(this.jLabel2);
        this.labelRefresh.setIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/orange_bdot.gif"));
        this.labelRefresh.setEnabled(false);
        this.toolBarTriggers.add(this.labelRefresh);
        this.jPanel2.add(this.toolBarTriggers);
        this.add((Component)this.jPanel2, "North");
    }

    private void formComponentShown(ComponentEvent evt) {
        this.refreshOutput();
        this.updateEnable();
    }

    private void cmRefreshDbmsOutputActionPerformed(ActionEvent evt) {
        this.refreshOutput();
    }

    private void cmSwitchEnableDbmsOutputActionPerformed(ActionEvent evt) {
        try {
            if (!this.outputEnable) {
                Command command = this.getDatabase().createCommand();
                command.setSqlText(Sql.getDbmsOutputEnable());
                command.paramByName("BYTES").setLong(this.settings.getValue(OracleDbmsOutputSettingsProvider.setBufferSize, Long.valueOf(1000L)) * 1000L);
                command.execute();
                this.outputEnable = true;
            } else {
                Command command = this.getDatabase().createCommand();
                command.setSqlText(Sql.getDbmsOutputDisable());
                command.execute();
                this.outputEnable = false;
            }
        }
        catch (Exception ex) {
            MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
        this.updateEnable();
    }

    private void formComponentHidden(ComponentEvent evt) {
        this.updateEnable();
    }

    private void cmClearDbmsOutputActionPerformed(ActionEvent evt) {
        this.textOutput.setText("");
    }

    private void cmSaveToFileActionPerformed(ActionEvent evt) {
        File file = FileUtil.selectFileToSave((Component)this, (FileExtensionFilter[])new FileExtensionFilter[]{new FileExtensionFilter(this.stringManager.getString("text-files"), new String[]{".txt"})});
        if (file != null) {
            try {
                PrintWriter pw = new PrintWriter(new FileOutputStream(file));
                pw.write(this.textOutput.getText());
                pw.close();
            }
            catch (FileNotFoundException ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void comboRefreshItemStateChanged(ItemEvent evt) {
        if (this.comboRefresh.getSelectedItem() != null) {
            if (this.comboRefresh.getSelectedIndex() > 0) {
                this.timer.setInterval((long)((int)this.getRefreshTime()));
                this.timer.setEnabled(true);
            } else {
                this.timer.setEnabled(false);
            }
        }
    }
}

