/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.directories;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.gui.util.SimpleSelectDialog;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.gui.wizards.CreateDirectoryWizard;
import pl.mpak.orbada.oracle.gui.wizards.DropDirectoryWizard;
import pl.mpak.orbada.oracle.services.OracleDbInfoProvider;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableCellRendererFilter;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.QueryUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.variant.Variant;

public class DirectoriesPanelView
extends JPanel
implements IRootTabObjectInfo {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName;
    private String tabTitle;
    private SqlFilter filter;
    private boolean viewClosing = false;
    private ToolButton buttonActions;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private ToolButton buttonSelectSchema;
    private Action cmCreateDirectory;
    private Action cmDropDirectory;
    private Action cmFilter;
    private Action cmRefresh;
    private Action cmSelectSchema;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JSeparator jSeparator2;
    private JPopupMenu menuActions;
    private JMenuItem menuCreateDirectory;
    private JMenuItem menuDropDirectory;
    private QueryTableStatusBar statusBar;
    private ViewTable tableDirs;
    private JToolBar toolBar;

    public DirectoriesPanelView(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.tabTitle = this.accesibilities.getTabTitle();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.currentSchemaName = OracleDbInfoProvider.getCurrentSchema(this.getDatabase());
        this.tableDirs.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableDirs.addColumn((TableColumn)new QueryTableColumn("directory_name", this.stringManager.getString("directory-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableDirs.addColumn((TableColumn)new QueryTableColumn("created", this.stringManager.getString("created"), 120));
            this.tableDirs.addColumn((TableColumn)new QueryTableColumn("status", this.stringManager.getString("status"), 60, (TableCellRenderer)new QueryTableCellRenderer(new QueryTableCellRendererFilter(){

                public void cellRendererPerformed(JTable table, Component renderer, Object value, boolean isSelected, boolean hasFocus) {
                    if (StringUtil.nvl((String)((String)value), (String)"").equals("VALID")) {
                        ((JLabel)renderer).setForeground(SwingUtil.Color.GREEN);
                    } else if (StringUtil.nvl((String)((String)value), (String)"").equals("INVALID")) {
                        ((JLabel)renderer).setForeground(Color.RED);
                    }
                }
            })));
            this.tableDirs.addColumn((TableColumn)new QueryTableColumn("read_for", this.stringManager.getString("read-for"), 100));
            this.tableDirs.addColumn((TableColumn)new QueryTableColumn("read", this.stringManager.getString("read"), 40));
            this.tableDirs.addColumn((TableColumn)new QueryTableColumn("write_for", this.stringManager.getString("write-for"), 100));
            this.tableDirs.addColumn((TableColumn)new QueryTableColumn("write", this.stringManager.getString("write"), 40));
            this.tableDirs.addColumn((TableColumn)new QueryTableColumn("directory_path", this.stringManager.getString("directory-path"), 350));
            SqlFilterDef def = new SqlFilterDef();
            def.add(new SqlFilterDefComponent("directory_name", this.stringManager.getString("directory-name"), (String[])null));
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-directories-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableDirs, (JButton)this.buttonActions, this.menuActions, "oracle-directories-actions");
    }

    public void setCurrentSchemaName(String schemaName) {
        if (!this.currentSchemaName.equals(schemaName)) {
            this.currentSchemaName = schemaName;
            if (!this.currentSchemaName.equalsIgnoreCase(OracleDbInfoProvider.getCurrentSchema(this.getDatabase()))) {
                this.accesibilities.setTabTitle(this.tabTitle + " (" + this.currentSchemaName + ")");
            } else {
                this.accesibilities.setTabTitle(this.tabTitle);
            }
        }
    }

    private void refreshTableListTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                DirectoriesPanelView.this.refresh();
            }
        });
    }

    public void refresh() {
        if (!this.isVisible() || this.viewClosing) {
            return;
        }
        try {
            String objectName = null;
            if (this.tableDirs.getQuery().isActive() && this.tableDirs.getSelectedRow() >= 0) {
                this.tableDirs.getQuery().getRecord(this.tableDirs.getSelectedRow());
                objectName = this.tableDirs.getQuery().fieldByName("directory_name").getString();
            }
            this.refresh(objectName);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public void refresh(String objectName) {
        try {
            int column = this.tableDirs.getSelectedColumn();
            int index = Math.max(0, this.tableDirs.getSelectedRow());
            this.tableDirs.getQuery().close();
            this.tableDirs.getQuery().setSqlText(Sql.getDirectoryList(this.filter.getSqlText()));
            this.tableDirs.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
            this.tableDirs.getQuery().open();
            if (objectName != null && this.tableDirs.getQuery().locate("directory_name", new Variant(objectName))) {
                this.tableDirs.changeSelection(this.tableDirs.getQuery().getCurrentRecord().getIndex(), column);
            } else if (!this.tableDirs.getQuery().isEmpty()) {
                this.tableDirs.changeSelection(Math.min(index, this.tableDirs.getRowCount() - 1), column);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.viewClosing = true;
        this.tableDirs.getQuery().close();
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.cmSelectSchema = new Action();
        this.menuActions = new JPopupMenu();
        this.menuCreateDirectory = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.menuDropDirectory = new JMenuItem();
        this.cmCreateDirectory = new Action();
        this.cmDropDirectory = new Action();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableDirs = new ViewTable();
        this.statusBar = new QueryTableStatusBar();
        this.jPanel2 = new JPanel();
        this.toolBar = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonSelectSchema = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DirectoriesPanelView.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DirectoriesPanelView.this.cmFilterActionPerformed(evt);
            }
        });
        this.cmSelectSchema.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/users16.gif"));
        this.cmSelectSchema.setText(this.stringManager.getString("cmSelectSchema-text"));
        this.cmSelectSchema.setTooltip(this.stringManager.getString("cmSelectSchema-hint"));
        this.cmSelectSchema.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DirectoriesPanelView.this.cmSelectSchemaActionPerformed(evt);
            }
        });
        this.menuCreateDirectory.setAction((javax.swing.Action)this.cmCreateDirectory);
        this.menuActions.add(this.menuCreateDirectory);
        this.menuActions.add(this.jSeparator2);
        this.menuDropDirectory.setAction((javax.swing.Action)this.cmDropDirectory);
        this.menuActions.add(this.menuDropDirectory);
        this.cmCreateDirectory.setActionCommandKey("cmCreateDirectory");
        this.cmCreateDirectory.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/directory.gif"));
        this.cmCreateDirectory.setText(this.stringManager.getString("cmCreateDirectory-text"));
        this.cmCreateDirectory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DirectoriesPanelView.this.cmCreateDirectoryActionPerformed(evt);
            }
        });
        this.cmDropDirectory.setActionCommandKey("cmDropDirectory");
        this.cmDropDirectory.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDropDirectory.setText(this.stringManager.getString("cmDropDirectory-text"));
        this.cmDropDirectory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DirectoriesPanelView.this.cmDropDirectoryActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                DirectoriesPanelView.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableDirs);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.statusBar.setShowFieldType(false);
        this.statusBar.setShowOpenTime(false);
        this.statusBar.setTable((QueryTable)this.tableDirs);
        this.jPanel1.add((Component)this.statusBar, "South");
        this.add((Component)this.jPanel1, "Center");
        this.jPanel2.setLayout(new FlowLayout(0, 0, 0));
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonRefresh);
        this.buttonSelectSchema.setAction((javax.swing.Action)this.cmSelectSchema);
        this.buttonSelectSchema.setHorizontalTextPosition(0);
        this.buttonSelectSchema.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonSelectSchema);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonFilter);
        this.toolBar.add(this.jSeparator1);
        this.toolBar.add((Component)this.buttonActions);
        this.jPanel2.add(this.toolBar);
        this.add((Component)this.jPanel2, "North");
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void formComponentShown(ComponentEvent evt) {
        if (!this.tableDirs.getQuery().isActive()) {
            this.refreshTableListTask();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmSelectSchemaActionPerformed(ActionEvent evt) {
        Query query = this.getDatabase().createQuery();
        try {
            query.open(Sql.getSchemaList());
            Vector vl = QueryUtil.staticData((String)"{schema_name}", (Query)query);
            Point point = this.buttonSelectSchema.getLocationOnScreen();
            point.y += this.buttonSelectSchema.getHeight();
            SimpleSelectDialog.select((Window)SwingUtil.getWindowComponent((Component)this), (int)point.x, (int)point.y, (Vector)vl, (int)vl.indexOf(this.currentSchemaName), (SimpleSelectDialog.CallBack)new SimpleSelectDialog.CallBack(){

                public void selected(Object o) {
                    DirectoriesPanelView.this.setCurrentSchemaName(o.toString());
                    DirectoriesPanelView.this.refresh();
                }
            });
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
    }

    private void cmCreateDirectoryActionPerformed(ActionEvent evt) {
        if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateDirectoryWizard(this.getDatabase()), (boolean)true) != null) {
            this.refresh();
        }
    }

    private void cmDropDirectoryActionPerformed(ActionEvent evt) {
        if (this.tableDirs.getSelectedRow() >= 0) {
            try {
                this.tableDirs.getQuery().getRecord(this.tableDirs.getSelectedRow());
                String directoryName = this.tableDirs.getQuery().fieldByName("directory_name").getString();
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new DropDirectoryWizard(this.getDatabase(), directoryName), (boolean)true) != null) {
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
    }
}

