/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.freezing;

import java.util.HashMap;
import pl.mpak.orbada.oracle.gui.freezing.FreezeViewService;
import pl.mpak.orbada.oracle.gui.freezing.FunctionFreezeViewService;
import pl.mpak.orbada.oracle.gui.freezing.JavaClassFreezeViewService;
import pl.mpak.orbada.oracle.gui.freezing.JavaSourceFreezeViewService;
import pl.mpak.orbada.oracle.gui.freezing.MViewFreezeViewService;
import pl.mpak.orbada.oracle.gui.freezing.PackageFreezeViewService;
import pl.mpak.orbada.oracle.gui.freezing.ProcedureFreezeViewService;
import pl.mpak.orbada.oracle.gui.freezing.TableFreezeViewService;
import pl.mpak.orbada.oracle.gui.freezing.TriggerFreezeViewService;
import pl.mpak.orbada.oracle.gui.freezing.TypeFreezeViewService;
import pl.mpak.orbada.oracle.gui.freezing.ViewFreezeViewService;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.util.ExceptionUtil;

public class FreezeFactory {
    private HashMap<String, Class<? extends FreezeViewService>> freezeMap = new HashMap();
    private IViewAccesibilities accesibilities;

    public FreezeFactory() {
        this.freezeMap.put("FUNCTION", FunctionFreezeViewService.class);
        this.freezeMap.put("PROCEDURE", ProcedureFreezeViewService.class);
        this.freezeMap.put("PACKAGE", PackageFreezeViewService.class);
        this.freezeMap.put("PACKAGE BODY", PackageFreezeViewService.class);
        this.freezeMap.put("TYPE", TypeFreezeViewService.class);
        this.freezeMap.put("TABLE", TableFreezeViewService.class);
        this.freezeMap.put("VIEW", ViewFreezeViewService.class);
        this.freezeMap.put("MATERIALIZED VIEW", MViewFreezeViewService.class);
        this.freezeMap.put("JAVA CLASS", JavaClassFreezeViewService.class);
        this.freezeMap.put("JAVA SOURCE", JavaSourceFreezeViewService.class);
        this.freezeMap.put("TRIGGER", TriggerFreezeViewService.class);
    }

    public FreezeFactory(IViewAccesibilities accesibilities) {
        this();
        this.accesibilities = accesibilities;
    }

    public boolean canCreate(String objectType) {
        return this.freezeMap.get(objectType) != null;
    }

    public FreezeViewService createInstance(String objectType, String schemaName, String objectName) {
        Class<? extends FreezeViewService> clazz = this.freezeMap.get(objectType);
        if (clazz != null) {
            try {
                FreezeViewService service = clazz.newInstance();
                service.setSchemaName(schemaName);
                service.setObjectName(objectName);
                return service;
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
        return null;
    }
}

