/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.functions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.gui.wizards.GrantFunctionPrivilegesWizard;
import pl.mpak.orbada.oracle.gui.wizards.RevokeFunctionPrivilegesWizard;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableCellRendererFilter;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class FunctionGrantsPanel
extends JPanel
implements ITabObjectInfo {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName = "";
    private String currentObjectName = "";
    private boolean requestRefresh = false;
    private boolean closing = false;
    private SqlFilter filter;
    private ToolButton buttonActions;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private Action cmFilter;
    private Action cmGrants;
    private Action cmRefresh;
    private Action cmRevoke;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JPopupMenu menuActions;
    private JMenuItem menuGrants;
    private JMenuItem menuRevoke;
    private QueryTableStatusBar statusBarIndexes;
    private ViewTable tableGrants;
    private JToolBar toolBarIndexes;

    public FunctionGrantsPanel(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.tableGrants.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int rowIndex = FunctionGrantsPanel.this.tableGrants.getSelectedRow();
                if (rowIndex >= 0 && FunctionGrantsPanel.this.tableGrants.getQuery().isActive()) {
                    try {
                        FunctionGrantsPanel.this.tableGrants.getQuery().getRecord(rowIndex);
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                }
            }
        });
        this.tableGrants.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableGrants.addColumn((TableColumn)new QueryTableColumn("grantee", this.stringManager.getString("grantee"), 120));
            this.tableGrants.addColumn((TableColumn)new QueryTableColumn("privilege", this.stringManager.getString("privilege"), 160, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableGrants.addColumn((TableColumn)new QueryTableColumn("grantor", this.stringManager.getString("grantor"), 120));
            this.tableGrants.addColumn((TableColumn)new QueryTableColumn("grantable", this.stringManager.getString("grantable"), 70, (TableCellRenderer)new QueryTableCellRenderer(new QueryTableCellRendererFilter(){

                public void cellRendererPerformed(JTable table, Component renderer, Object value, boolean isSelected, boolean hasFocus) {
                    if (StringUtil.nvl((String)((String)value), (String)"").equals("YES")) {
                        ((JLabel)renderer).setForeground(SwingUtil.Color.GREEN);
                    }
                }
            })));
            SqlFilterDef def = new SqlFilterDef();
            def.add(new SqlFilterDefComponent("privilege", this.stringManager.getString("privilege"), (String[])null));
            def.add(new SqlFilterDefComponent("grantee", this.stringManager.getString("grantee"), (String[])null));
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-function-grants-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableGrants, (JButton)this.buttonActions, this.menuActions, "oracle-function-grants-actions");
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public String getTitle() {
        return this.stringManager.getString("FunctionGrantsPanel-title");
    }

    private void refreshTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                FunctionGrantsPanel.this.refresh();
            }
        });
    }

    public void refresh() {
        try {
            this.requestRefresh = false;
            this.tableGrants.getQuery().close();
            this.tableGrants.getQuery().setSqlText(Sql.getPrivilegeList(this.filter.getSqlText()));
            this.tableGrants.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
            this.tableGrants.getQuery().paramByName("table_name").setString(this.currentObjectName);
            this.tableGrants.getQuery().open();
            if (!this.tableGrants.getQuery().isEmpty()) {
                this.tableGrants.changeSelection(0, 0);
            }
        }
        catch (Exception ex) {
            MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
        }
    }

    public void refresh(String catalogName, String schemaName, String objectName) {
        if (!this.currentSchemaName.equals(schemaName) || !this.currentObjectName.equals(objectName) || this.requestRefresh) {
            this.currentSchemaName = schemaName;
            this.currentObjectName = objectName;
            if (this.isVisible()) {
                this.refresh();
            } else {
                this.requestRefresh = true;
            }
        }
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.closing = true;
        this.tableGrants.getQuery().close();
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.menuActions = new JPopupMenu();
        this.menuGrants = new JMenuItem();
        this.menuRevoke = new JMenuItem();
        this.cmGrants = new Action();
        this.cmRevoke = new Action();
        this.statusBarIndexes = new QueryTableStatusBar();
        this.jPanel1 = new JPanel();
        this.toolBarIndexes = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.jScrollPane1 = new JScrollPane();
        this.tableGrants = new ViewTable();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FunctionGrantsPanel.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FunctionGrantsPanel.this.cmFilterActionPerformed(evt);
            }
        });
        this.menuGrants.setAction((javax.swing.Action)this.cmGrants);
        this.menuActions.add(this.menuGrants);
        this.menuRevoke.setAction((javax.swing.Action)this.cmRevoke);
        this.menuActions.add(this.menuRevoke);
        this.cmGrants.setActionCommandKey("cmGrant");
        this.cmGrants.setText(this.stringManager.getString("cmGrants-text"));
        this.cmGrants.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FunctionGrantsPanel.this.cmGrantsActionPerformed(evt);
            }
        });
        this.cmRevoke.setActionCommandKey("cmRevoke");
        this.cmRevoke.setText(this.stringManager.getString("cmRevoke-text"));
        this.cmRevoke.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FunctionGrantsPanel.this.cmRevokeActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                FunctionGrantsPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.statusBarIndexes.setShowFieldType(false);
        this.statusBarIndexes.setShowOpenTime(false);
        this.statusBarIndexes.setTable((QueryTable)this.tableGrants);
        this.add((Component)this.statusBarIndexes, "Last");
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarIndexes.setFloatable(false);
        this.toolBarIndexes.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarIndexes.add((Component)this.buttonRefresh);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarIndexes.add((Component)this.buttonFilter);
        this.toolBarIndexes.add(this.jSeparator1);
        this.toolBarIndexes.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBarIndexes);
        this.add((Component)this.jPanel1, "North");
        this.jScrollPane1.setViewportView((Component)this.tableGrants);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void formComponentShown(ComponentEvent evt) {
        if (this.requestRefresh && !this.closing) {
            this.refreshTask();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void cmGrantsActionPerformed(ActionEvent evt) {
        if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new GrantFunctionPrivilegesWizard(this.getDatabase(), this.currentSchemaName, this.currentObjectName), (boolean)true) != null) {
            this.refresh();
        }
    }

    private void cmRevokeActionPerformed(ActionEvent evt) {
        if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new RevokeFunctionPrivilegesWizard(this.getDatabase(), this.currentSchemaName, this.currentObjectName), (boolean)true) != null) {
            this.refresh();
        }
    }
}

