/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.functions;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.OrbadaTabbedPane;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.gui.util.SimpleSelectDialog;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.gui.freezing.FunctionFreezeViewService;
import pl.mpak.orbada.oracle.gui.functions.FunctionSourcePanel;
import pl.mpak.orbada.oracle.gui.functions.FunctionTabbedPane;
import pl.mpak.orbada.oracle.gui.wizards.CallObjectWizard;
import pl.mpak.orbada.oracle.gui.wizards.CompileAllObjectsWizard;
import pl.mpak.orbada.oracle.gui.wizards.CreateFunctionWizard;
import pl.mpak.orbada.oracle.gui.wizards.DropFunctionWizard;
import pl.mpak.orbada.oracle.services.OracleDbInfoProvider;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableCellRendererFilter;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.QueryUtil;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.timer.Timer;
import pl.mpak.util.variant.Variant;

public class FunctionsPanelView
extends JPanel
implements IRootTabObjectInfo {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName;
    private String tabTitle;
    private SqlFilter filter;
    private boolean viewClosing = false;
    private ISettings settings;
    private Timer timer;
    private OrbadaTabbedPane tabbedPane;
    private boolean refreshing = false;
    private ToolButton buttonActions;
    private ToolButton buttonCompile;
    private ToolButton buttonFilter;
    private ToolButton buttonFreezeObject;
    private ToolButton buttonRefresh;
    private ToolButton buttonSelectSchema;
    private Action cmCallFunction;
    private Action cmCompile;
    private Action cmCompileAll;
    private Action cmCompileAllInvalid;
    private Action cmCreateFunction;
    private Action cmDropFunction;
    private Action cmFilter;
    private Action cmFreezeObject;
    private Action cmRefresh;
    private Action cmSelectSchema;
    private JMenuItem jMenuItem1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JPopupMenu menuActions;
    private JMenuItem menuCompileAll;
    private JMenuItem menuCompileAllInvalid;
    private JMenuItem menuCreateFunction;
    private JMenuItem menuDropFunction;
    private JPanel panelTables;
    private JSplitPane split;
    private QueryTableStatusBar statusBarTables;
    private ViewTable tableFunctions;
    private JToolBar toolBarTables;

    public FunctionsPanelView(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.tabTitle = this.accesibilities.getTabTitle();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.timer = new Timer(250L){
            {
                this.setEnabled(false);
            }

            public void run() {
                this.setEnabled(false);
                FunctionsPanelView.this.refreshTabbedPanes();
            }
        };
        OrbadaOraclePlugin.getRefreshQueue().add(this.timer);
        this.tabbedPane = new FunctionTabbedPane(this.accesibilities);
        this.split.setRightComponent((Component)this.tabbedPane);
        this.settings = this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-functions-panel");
        this.split.setDividerLocation(this.settings.getValue("split-location", Long.valueOf(this.split.getDividerLocation())).intValue());
        this.currentSchemaName = OracleDbInfoProvider.getCurrentSchema(this.getDatabase());
        this.tableFunctions.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
            int lastIndex = -1;

            public void valueChanged(ListSelectionEvent e) {
                if (!FunctionsPanelView.this.refreshing) {
                    FunctionSourcePanel panel = (FunctionSourcePanel)FunctionsPanelView.this.tabbedPane.getComponent(FunctionSourcePanel.class);
                    if (panel != null && this.lastIndex != FunctionsPanelView.this.tableFunctions.getSelectedRow() && !panel.canClose()) {
                        FunctionsPanelView.this.tableFunctions.changeSelection(this.lastIndex, FunctionsPanelView.this.tableFunctions.getSelectedColumn());
                        return;
                    }
                    this.lastIndex = FunctionsPanelView.this.tableFunctions.getSelectedRow();
                    FunctionsPanelView.this.timer.restart();
                }
            }
        });
        this.tableFunctions.getQuery().setDatabase(this.getDatabase());
        this.tableFunctions.addColumn((TableColumn)new QueryTableColumn("object_name", this.stringManager.getString("function-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
        this.tableFunctions.addColumn((TableColumn)new QueryTableColumn("status", this.stringManager.getString("status"), 60, (TableCellRenderer)new QueryTableCellRenderer(new QueryTableCellRendererFilter(){

            public void cellRendererPerformed(JTable table, Component renderer, Object value, boolean isSelected, boolean hasFocus) {
                if (StringUtil.nvl((String)((String)value), (String)"").equals("VALID")) {
                    ((JLabel)renderer).setForeground(SwingUtil.Color.GREEN);
                } else if (StringUtil.nvl((String)((String)value), (String)"").equals("INVALID")) {
                    ((JLabel)renderer).setForeground(Color.RED);
                } else if (StringUtil.nvl((String)((String)value), (String)"").equals("DEBUG")) {
                    ((JLabel)renderer).setForeground(SwingUtil.Color.NAVY);
                }
            }
        })));
        this.tableFunctions.addColumn((TableColumn)new QueryTableColumn("created", this.stringManager.getString("she-created"), 110));
        SqlFilterDef def = new SqlFilterDef();
        def.add(new SqlFilterDefComponent("object_name", this.stringManager.getString("function-name"), (String[])null));
        def.add(new SqlFilterDefComponent("status = 'INVALID'", this.stringManager.getString("invalid")));
        this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-functions-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        SwingUtil.addAction((JComponent)this.tableFunctions, (javax.swing.Action)this.cmCompile);
        SwingUtil.addAction((JComponent)this.tableFunctions, (javax.swing.Action)this.cmCallFunction);
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableFunctions, (JButton)this.buttonActions, this.menuActions, "oracle-functions-actions");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                FunctionsPanelView.this.tableFunctions.requestFocusInWindow();
            }
        });
    }

    public void setCurrentSchemaName(String schemaName) {
        if (!this.currentSchemaName.equals(schemaName)) {
            this.currentSchemaName = schemaName;
            if (!this.currentSchemaName.equalsIgnoreCase(OracleDbInfoProvider.getCurrentSchema(this.getDatabase()))) {
                this.accesibilities.setTabTitle(this.tabTitle + " (" + this.currentSchemaName + ")");
            } else {
                this.accesibilities.setTabTitle(this.tabTitle);
            }
        }
    }

    private void refreshTabbedPanes() {
        String objectName = "";
        int rowIndex = this.tableFunctions.getSelectedRow();
        if (rowIndex >= 0 && this.tableFunctions.getQuery().isActive()) {
            try {
                this.tableFunctions.getQuery().getRecord(rowIndex);
                objectName = this.tableFunctions.getQuery().fieldByName("object_name").getString();
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
        this.tabbedPane.refresh(null, this.currentSchemaName, objectName);
    }

    private void refreshTableListTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                FunctionsPanelView.this.refresh();
            }
        });
    }

    public void refresh() {
        if (!this.isVisible() || this.viewClosing) {
            return;
        }
        try {
            String objectName = null;
            if (this.tableFunctions.getQuery().isActive() && this.tableFunctions.getSelectedRow() >= 0) {
                this.tableFunctions.getQuery().getRecord(this.tableFunctions.getSelectedRow());
                objectName = this.tableFunctions.getQuery().fieldByName("object_name").getString();
            }
            this.refresh(objectName);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(String objectName) {
        this.refreshing = true;
        try {
            int column = this.tableFunctions.getSelectedColumn();
            int index = Math.max(0, this.tableFunctions.getSelectedRow());
            this.tableFunctions.getQuery().close();
            this.tableFunctions.getQuery().setSqlText(Sql.getFunctionList(this.filter.getSqlText(), OracleDbInfoProvider.instance.getMajorVersion(this.getDatabase())));
            this.tableFunctions.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
            this.tableFunctions.getQuery().paramByName("function_type").setString("FUNCTION");
            this.tableFunctions.getQuery().open();
            if (objectName != null && this.tableFunctions.getQuery().locate("object_name", new Variant(objectName))) {
                this.tableFunctions.changeSelection(this.tableFunctions.getQuery().getCurrentRecord().getIndex(), column);
            } else if (!this.tableFunctions.getQuery().isEmpty()) {
                this.tableFunctions.changeSelection(Math.min(index, this.tableFunctions.getRowCount() - 1), column);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            this.refreshing = false;
            this.refreshTabbedPanes();
        }
    }

    public boolean canClose() {
        return this.tabbedPane.canClose();
    }

    public void close() throws IOException {
        this.timer.cancel();
        this.settings.setValue("split-location", Long.valueOf(this.split.getDividerLocation()));
        this.viewClosing = true;
        this.tabbedPane.close();
        this.tableFunctions.getQuery().close();
        this.accesibilities = null;
        this.settings.store();
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmSelectSchema = new Action();
        this.cmFilter = new Action();
        this.menuActions = new JPopupMenu();
        this.jMenuItem1 = new JMenuItem();
        this.menuCreateFunction = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.menuCompileAll = new JMenuItem();
        this.menuCompileAllInvalid = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.menuDropFunction = new JMenuItem();
        this.cmCompile = new Action();
        this.cmFreezeObject = new Action();
        this.cmDropFunction = new Action();
        this.cmCreateFunction = new Action();
        this.cmCompileAll = new Action();
        this.cmCompileAllInvalid = new Action();
        this.cmCallFunction = new Action();
        this.split = new JSplitPane();
        this.panelTables = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableFunctions = new ViewTable();
        this.jPanel1 = new JPanel();
        this.toolBarTables = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonSelectSchema = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.buttonFreezeObject = new ToolButton();
        this.jSeparator1 = new JSeparator();
        this.buttonCompile = new ToolButton();
        this.buttonActions = new ToolButton();
        this.jPanel2 = new JPanel();
        this.statusBarTables = new QueryTableStatusBar();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FunctionsPanelView.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmSelectSchema.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/users16.gif"));
        this.cmSelectSchema.setText(this.stringManager.getString("cmSelectSchema-text"));
        this.cmSelectSchema.setTooltip(this.stringManager.getString("cmSelectSchema-hint"));
        this.cmSelectSchema.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FunctionsPanelView.this.cmSelectSchemaActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/filter16.gif"));
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FunctionsPanelView.this.cmFilterActionPerformed(evt);
            }
        });
        this.jMenuItem1.setAction((javax.swing.Action)this.cmCallFunction);
        this.menuActions.add(this.jMenuItem1);
        this.menuCreateFunction.setAction((javax.swing.Action)this.cmCreateFunction);
        this.menuActions.add(this.menuCreateFunction);
        this.menuActions.add(this.jSeparator3);
        this.menuCompileAll.setAction((javax.swing.Action)this.cmCompileAll);
        this.menuActions.add(this.menuCompileAll);
        this.menuCompileAllInvalid.setAction((javax.swing.Action)this.cmCompileAllInvalid);
        this.menuActions.add(this.menuCompileAllInvalid);
        this.menuActions.add(this.jSeparator2);
        this.menuDropFunction.setAction((javax.swing.Action)this.cmDropFunction);
        this.menuActions.add(this.menuDropFunction);
        this.cmCompile.setActionCommandKey("cmCompile");
        this.cmCompile.setShortCut(KeyStroke.getKeyStroke(10, 2));
        this.cmCompile.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/db_sql_execute16.gif"));
        this.cmCompile.setText(this.stringManager.getString("cmCompile-text"));
        this.cmCompile.setTooltip(this.stringManager.getString("cmCompile-hint"));
        this.cmCompile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FunctionsPanelView.this.cmCompileActionPerformed(evt);
            }
        });
        this.cmFreezeObject.setActionCommandKey("cmFreezeObject");
        this.cmFreezeObject.setShortCut(KeyStroke.getKeyStroke(114, 0));
        this.cmFreezeObject.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/freeze.gif"));
        this.cmFreezeObject.setText(this.stringManager.getString("cmFreezeObject-text"));
        this.cmFreezeObject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FunctionsPanelView.this.cmFreezeObjectActionPerformed(evt);
            }
        });
        this.cmDropFunction.setActionCommandKey("cmDropFunction");
        this.cmDropFunction.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDropFunction.setText(this.stringManager.getString("cmDropFunction-text"));
        this.cmDropFunction.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FunctionsPanelView.this.cmDropFunctionActionPerformed(evt);
            }
        });
        this.cmCreateFunction.setActionCommandKey("cmCreateFunction");
        this.cmCreateFunction.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/function.gif"));
        this.cmCreateFunction.setText(this.stringManager.getString("cmCreateFunction-text"));
        this.cmCreateFunction.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FunctionsPanelView.this.cmCreateFunctionActionPerformed(evt);
            }
        });
        this.cmCompileAll.setActionCommandKey("cmCompileAll");
        this.cmCompileAll.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/db_sql_execute_all.gif"));
        this.cmCompileAll.setText(this.stringManager.getString("cmCompileAll-text"));
        this.cmCompileAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FunctionsPanelView.this.cmCompileAllActionPerformed(evt);
            }
        });
        this.cmCompileAllInvalid.setActionCommandKey("cmCompileAllInvalid");
        this.cmCompileAllInvalid.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/db_sql_execute_all_invalid.gif"));
        this.cmCompileAllInvalid.setText(this.stringManager.getString("cmCompileAllInvalid-text"));
        this.cmCompileAllInvalid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FunctionsPanelView.this.cmCompileAllInvalidActionPerformed(evt);
            }
        });
        this.cmCallFunction.setActionCommandKey("cmCallFunction");
        this.cmCallFunction.setShortCut(KeyStroke.getKeyStroke(120, 0));
        this.cmCallFunction.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/call.gif"));
        this.cmCallFunction.setText(this.stringManager.getString("cmCallFunction-text"));
        this.cmCallFunction.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FunctionsPanelView.this.cmCallFunctionActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                FunctionsPanelView.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.split.setBorder(null);
        this.split.setDividerLocation(200);
        this.split.setContinuousLayout(true);
        this.split.setOneTouchExpandable(true);
        this.panelTables.setPreferredSize(new Dimension(250, 100));
        this.panelTables.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableFunctions);
        this.panelTables.add((Component)this.jScrollPane1, "Center");
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarTables.setFloatable(false);
        this.toolBarTables.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonRefresh);
        this.buttonSelectSchema.setAction((javax.swing.Action)this.cmSelectSchema);
        this.buttonSelectSchema.setHorizontalTextPosition(0);
        this.buttonSelectSchema.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonSelectSchema);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonFilter);
        this.buttonFreezeObject.setAction((javax.swing.Action)this.cmFreezeObject);
        this.buttonFreezeObject.setHorizontalTextPosition(0);
        this.buttonFreezeObject.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonFreezeObject);
        this.jSeparator1.setOrientation(1);
        this.toolBarTables.add(this.jSeparator1);
        this.buttonCompile.setAction((javax.swing.Action)this.cmCompile);
        this.buttonCompile.setHorizontalTextPosition(0);
        this.buttonCompile.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonCompile);
        this.toolBarTables.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBarTables);
        this.panelTables.add((Component)this.jPanel1, "North");
        this.jPanel2.setLayout(new BorderLayout());
        this.statusBarTables.setShowFieldType(false);
        this.statusBarTables.setShowFieldValue(false);
        this.statusBarTables.setShowOpenTime(false);
        this.statusBarTables.setTable((QueryTable)this.tableFunctions);
        this.jPanel2.add((Component)this.statusBarTables, "South");
        this.panelTables.add((Component)this.jPanel2, "South");
        this.split.setLeftComponent(this.panelTables);
        this.add((Component)this.split, "Center");
    }

    private void formComponentShown(ComponentEvent evt) {
        if (!this.tableFunctions.getQuery().isActive()) {
            this.refreshTableListTask();
        }
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmSelectSchemaActionPerformed(ActionEvent evt) {
        Query query = this.getDatabase().createQuery();
        try {
            query.open(Sql.getSchemaList());
            Vector vl = QueryUtil.staticData((String)"{schema_name}", (Query)query);
            Point point = this.buttonSelectSchema.getLocationOnScreen();
            point.y += this.buttonSelectSchema.getHeight();
            SimpleSelectDialog.select((Window)SwingUtil.getWindowComponent((Component)this), (int)point.x, (int)point.y, (Vector)vl, (int)vl.indexOf(this.currentSchemaName), (SimpleSelectDialog.CallBack)new SimpleSelectDialog.CallBack(){

                public void selected(Object o) {
                    FunctionsPanelView.this.setCurrentSchemaName(o.toString());
                    FunctionsPanelView.this.refresh();
                }
            });
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void cmCompileActionPerformed(ActionEvent evt) {
        if (this.tableFunctions.getSelectedRow() >= 0) {
            try {
                this.tableFunctions.getQuery().getRecord(this.tableFunctions.getSelectedRow());
                String objectName = this.tableFunctions.getQuery().fieldByName("object_name").getString();
                this.getDatabase().executeCommand("ALTER FUNCTION " + SQLUtil.createSqlName((String)this.currentSchemaName, (String)objectName) + " COMPILE" + (OracleDbInfoProvider.instance.isDebugClauseNeeded(this.getDatabase()) ? " DEBUG" : ""));
                this.refresh();
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
    }

    private void cmFreezeObjectActionPerformed(ActionEvent evt) {
        if (this.tableFunctions.getSelectedRow() >= 0) {
            try {
                this.tableFunctions.getQuery().getRecord(this.tableFunctions.getSelectedRow());
                String objectName = this.tableFunctions.getQuery().fieldByName("object_name").getString();
                this.accesibilities.createView((ViewProvider)new FunctionFreezeViewService(this.accesibilities, this.currentSchemaName, objectName));
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmDropFunctionActionPerformed(ActionEvent evt) {
        if (this.tableFunctions.getSelectedRow() >= 0) {
            try {
                this.tableFunctions.getQuery().getRecord(this.tableFunctions.getSelectedRow());
                String packageName = this.tableFunctions.getQuery().fieldByName("object_name").getString();
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new DropFunctionWizard(this.getDatabase(), this.currentSchemaName, packageName), (boolean)true) != null) {
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
    }

    private void cmCreateFunctionActionPerformed(ActionEvent evt) {
        SqlCodeWizardDialog.WizardResult result = SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateFunctionWizard(this.getDatabase(), this.currentSchemaName), (boolean)true);
        if (result != null) {
            this.refresh((String)result.getResultMap().get("object_name"));
        }
    }

    private void cmCompileAllActionPerformed(ActionEvent evt) {
        SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CompileAllObjectsWizard(this.getDatabase(), this.currentSchemaName, "FUNCTION", null), (boolean)true);
    }

    private void cmCompileAllInvalidActionPerformed(ActionEvent evt) {
        SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CompileAllObjectsWizard(this.getDatabase(), this.currentSchemaName, "FUNCTION", "INVALID"), (boolean)true);
    }

    private void cmCallFunctionActionPerformed(ActionEvent evt) {
        if (this.tableFunctions.getSelectedRow() >= 0) {
            try {
                this.tableFunctions.getQuery().getRecord(this.tableFunctions.getSelectedRow());
                SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CallObjectWizard(this.getDatabase(), this.currentSchemaName, this.tableFunctions.getQuery().fieldByName("object_name").getString(), null), (boolean)true);
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
    }
}

