/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.gadgets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Closeable;
import java.io.IOException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.gui.freezing.FreezeFactory;
import pl.mpak.orbada.oracle.gui.freezing.FreezeViewService;
import pl.mpak.orbada.oracle.util.DragSourceOracleObject;
import pl.mpak.orbada.oracle.util.OracleObject;
import pl.mpak.orbada.plugins.IDatabaseObject;
import pl.mpak.orbada.plugins.IGadgetAccesibilities;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.ListRowChangeKeyListener;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ComboBox;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.Configurable;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.Titleable;

public class QuickSearchObject
extends JPanel
implements Titleable,
Closeable,
Configurable {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private IGadgetAccesibilities accesibilities;
    private ToolButton buttonFind;
    private ToolButton buttonFreeze;
    private JCheckBox checkAllSchemas;
    private JCheckBox checkDataObjects;
    private JCheckBox checkJavaObjects;
    private JCheckBox checkOtherObjects;
    private JCheckBox checkPlSqlObjects;
    private Action cmFind;
    private Action cmFreezeObject;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JList listFound;
    private ComboBox textSearch;

    public QuickSearchObject(IGadgetAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.listFound.setModel(new DefaultListModel());
        this.listFound.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof IDatabaseObject) {
                    IDatabaseObject ido = (IDatabaseObject)value;
                    this.setIcon(ido.getObjectIcon());
                    if (QuickSearchObject.this.accesibilities.getDatabase().getUserProperties().getProperty("schema-name", QuickSearchObject.this.accesibilities.getDatabase().getUserName().toUpperCase()).equals(ido.getSchemaName())) {
                        this.setText(ido.getObjectName());
                    } else {
                        this.setText(ido.getSqlObjectName());
                    }
                }
                return this;
            }
        });
        ((JTextField)this.textSearch.getEditor().getEditorComponent()).addKeyListener((KeyListener)new ListRowChangeKeyListener(this.listFound));
        SwingUtil.addAction((JComponent)((JTextField)this.textSearch.getEditor().getEditorComponent()), (javax.swing.Action)this.cmFind);
        SwingUtil.addAction((JComponent)((JTextField)this.textSearch.getEditor().getEditorComponent()), (javax.swing.Action)this.cmFreezeObject);
        SwingUtil.addAction((JComponent)this.listFound, (javax.swing.Action)this.cmFreezeObject);
        ISettings settings = this.accesibilities.getApplication().getSettings(this.accesibilities.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-quick-search-object");
        this.checkAllSchemas.setSelected(settings.getValue("all-schemas", Boolean.valueOf(this.checkAllSchemas.isSelected())));
        this.checkJavaObjects.setSelected(settings.getValue("java-objects", Boolean.valueOf(this.checkJavaObjects.isSelected())));
        this.checkDataObjects.setSelected(settings.getValue("data-objects", Boolean.valueOf(this.checkDataObjects.isSelected())));
        this.checkPlSqlObjects.setSelected(settings.getValue("plsql-objects", Boolean.valueOf(this.checkPlSqlObjects.isSelected())));
        this.checkOtherObjects.setSelected(settings.getValue("other-objects", Boolean.valueOf(this.checkOtherObjects.isSelected())));
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this.listFound, 3, new DragSourceOracleObject(this.listFound));
    }

    private void addTextToList(String text) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.textSearch.getModel();
        int index = model.getIndexOf(text);
        if (index != -1) {
            model.removeElementAt(index);
        }
        model.insertElementAt(text, 0);
        if (model.getSize() > 50) {
            model.removeElementAt(model.getSize() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findObject() {
        Query query = this.accesibilities.getDatabase().createQuery();
        try {
            String find = this.textSearch.getText();
            this.addTextToList(find);
            boolean filterSelected = false;
            String filter = "";
            if (!(this.checkJavaObjects.isSelected() && this.checkDataObjects.isSelected() && this.checkPlSqlObjects.isSelected() && this.checkOtherObjects.isSelected())) {
                if (this.checkJavaObjects.isSelected()) {
                    filter = filter + "(OBJECT_TYPE like 'JAVA%')";
                    filterSelected = true;
                }
                if (this.checkDataObjects.isSelected()) {
                    if (filterSelected) {
                        filter = filter + " or ";
                    }
                    filter = filter + "(OBJECT_TYPE in ('TABLE', 'VIEW', 'MATERIALIZED VIEW'))";
                    filterSelected = true;
                }
                if (this.checkPlSqlObjects.isSelected()) {
                    if (filterSelected) {
                        filter = filter + " or ";
                    }
                    filter = filter + "(OBJECT_TYPE in ('PACKAGE', 'FUNCTION', 'PROCEDURE', 'TYPE', 'TRIGGER'))";
                    filterSelected = true;
                }
                if (this.checkOtherObjects.isSelected()) {
                    if (filterSelected) {
                        filter = filter + " or ";
                    }
                    filter = filter + "(OBJECT_TYPE in ('SEQUENCE', 'DIRECTORY', 'INDEX', 'DATABASE LINK', 'SYNONYM', 'LIBRARY', 'INDEXTYPE', 'EVALUATION CONTEXT', 'CONSUMER GROUP', 'OPERATOR'))";
                    filterSelected = true;
                }
            }
            query.setSqlText(Sql.getObjectsSearch(filterSelected ? "(" + filter + ")" : null));
            if (!this.checkAllSchemas.isSelected()) {
                query.paramByName("schema_name").setString(this.accesibilities.getDatabase().getUserProperties().getProperty("schema-name", this.accesibilities.getDatabase().getUserName().toUpperCase()));
            }
            query.paramByName("object_name").setString(find);
            query.open();
            DefaultListModel model = (DefaultListModel)this.listFound.getModel();
            model.clear();
            while (!query.eof()) {
                try {
                    model.addElement(new OracleObject(query));
                }
                catch (Exception ex) {
                    ExceptionUtil.processException((Throwable)ex);
                }
                query.next();
            }
            this.textSearch.setSelectedItem((Object)find);
        }
        catch (Exception ex) {
            MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
        finally {
            query.close();
        }
    }

    public String getTitle() {
        return String.format(this.stringManager.getString("QuickSearchObject-title"), this.accesibilities.getDatabase().getPublicName());
    }

    public void close() throws IOException {
        ISettings settings = this.accesibilities.getApplication().getSettings(this.accesibilities.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-quick-search-object");
        settings.setValue("all-schemas", Boolean.valueOf(this.checkAllSchemas.isSelected()));
        settings.setValue("java-objects", Boolean.valueOf(this.checkJavaObjects.isSelected()));
        settings.setValue("data-objects", Boolean.valueOf(this.checkDataObjects.isSelected()));
        settings.setValue("plsql-objects", Boolean.valueOf(this.checkPlSqlObjects.isSelected()));
        settings.setValue("other-objects", Boolean.valueOf(this.checkOtherObjects.isSelected()));
        settings.store();
    }

    public boolean configure() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isConfig() {
        return false;
    }

    private void initComponents() {
        this.cmFind = new Action();
        this.cmFreezeObject = new Action();
        this.jPanel1 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jPanel5 = new JPanel();
        this.buttonFind = new ToolButton();
        this.buttonFreeze = new ToolButton();
        this.textSearch = new ComboBox();
        this.jPanel2 = new JPanel();
        this.checkAllSchemas = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.checkPlSqlObjects = new JCheckBox();
        this.checkDataObjects = new JCheckBox();
        this.checkJavaObjects = new JCheckBox();
        this.checkOtherObjects = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.listFound = new JList(){

            public String getToolTipText(MouseEvent e) {
                int index = this.locationToIndex(e.getPoint());
                if (index > -1) {
                    ListModel lm = this.getModel();
                    IDatabaseObject ido = (IDatabaseObject)lm.getElementAt(index);
                    return "<html>" + ido.getObjectType() + " <b>" + ido.getSqlObjectName() + "</b> " + ido.getStatus();
                }
                return null;
            }
        };
        this.cmFind.setActionCommandKey("cmFind");
        this.cmFind.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmFind.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/find_source.gif"));
        this.cmFind.setText(this.stringManager.getString("cmFind-text"));
        this.cmFind.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                QuickSearchObject.this.cmFindActionPerformed(evt);
            }
        });
        this.cmFreezeObject.setActionCommandKey("cmFreezeObject");
        this.cmFreezeObject.setShortCut(KeyStroke.getKeyStroke(114, 0));
        this.cmFreezeObject.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/freeze.gif"));
        this.cmFreezeObject.setText(this.stringManager.getString("cmFreezeObject-text"));
        this.cmFreezeObject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                QuickSearchObject.this.cmFreezeObjectActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                QuickSearchObject.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout(0, 2));
        this.jPanel1.setLayout(new BorderLayout(2, 2));
        this.jPanel4.setLayout(new BorderLayout());
        this.jPanel5.setLayout(new FlowLayout(1, 2, 0));
        this.buttonFind.setAction((javax.swing.Action)this.cmFind);
        this.buttonFind.setPreferredSize(new Dimension(24, 24));
        this.jPanel5.add((Component)this.buttonFind);
        this.buttonFreeze.setAction((javax.swing.Action)this.cmFreezeObject);
        this.buttonFreeze.setPreferredSize(new Dimension(24, 24));
        this.jPanel5.add((Component)this.buttonFreeze);
        this.jPanel4.add((Component)this.jPanel5, "East");
        this.textSearch.setEditable(true);
        this.jPanel4.add((Component)this.textSearch, "Center");
        this.jPanel1.add((Component)this.jPanel4, "North");
        this.jPanel2.setLayout(new GridBagLayout());
        this.checkAllSchemas.setText(this.stringManager.getString("in-all-schemas"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.checkAllSchemas, gridBagConstraints);
        this.jPanel3.setLayout(new GridLayout(2, 2));
        this.checkPlSqlObjects.setSelected(true);
        this.checkPlSqlObjects.setText(this.stringManager.getString("pl-sql-obejcts"));
        this.jPanel3.add(this.checkPlSqlObjects);
        this.checkDataObjects.setSelected(true);
        this.checkDataObjects.setText(this.stringManager.getString("objects-with-data"));
        this.jPanel3.add(this.checkDataObjects);
        this.checkJavaObjects.setSelected(true);
        this.checkJavaObjects.setText(this.stringManager.getString("java-objects"));
        this.jPanel3.add(this.checkJavaObjects);
        this.checkOtherObjects.setSelected(true);
        this.checkOtherObjects.setText(this.stringManager.getString("other-objects"));
        this.jPanel3.add(this.checkOtherObjects);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.jPanel2.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel1.add((Component)this.jPanel2, "South");
        this.add((Component)this.jPanel1, "First");
        this.listFound.setSelectionMode(0);
        this.listFound.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                QuickSearchObject.this.listFoundMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.listFound);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private void formComponentShown(ComponentEvent evt) {
        this.textSearch.requestFocusInWindow();
    }

    private void cmFindActionPerformed(ActionEvent evt) {
        this.findObject();
    }

    private void cmFreezeObjectActionPerformed(ActionEvent evt) {
        if (this.listFound.getSelectedIndex() >= 0) {
            try {
                IDatabaseObject ido = (IDatabaseObject)this.listFound.getModel().getElementAt(this.listFound.getSelectedIndex());
                FreezeViewService service = new FreezeFactory().createInstance(ido.getObjectType(), ido.getSchemaName(), ido.getObjectName());
                if (service != null) {
                    this.accesibilities.getPerspectiveAccesibilities().createView((ViewProvider)service);
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void listFoundMouseClicked(MouseEvent evt) {
        if (this.listFound.getSelectedValue() != null && evt.getClickCount() == 2 && evt.getButton() == 1) {
            this.cmFreezeObject.performe();
        }
    }
}

