/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.indexes;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.OrbadaTabbedPane;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.gui.util.SimpleSelectDialog;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.gui.indexes.IndexColumnsPanel;
import pl.mpak.orbada.oracle.gui.indexes.IndexDetailsPanel;
import pl.mpak.orbada.oracle.gui.indexes.IndexPartitionsPanel;
import pl.mpak.orbada.oracle.gui.indexes.IndexSizePanel;
import pl.mpak.orbada.oracle.gui.indexes.IndexSourcePanel;
import pl.mpak.orbada.oracle.gui.wizards.CoalasceIndexWizard;
import pl.mpak.orbada.oracle.gui.wizards.CreateIndexWizard;
import pl.mpak.orbada.oracle.gui.wizards.DropIndexWizard;
import pl.mpak.orbada.oracle.gui.wizards.RenameIndexWizard;
import pl.mpak.orbada.oracle.services.OracleDbInfoProvider;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.orbada.universal.gui.wizards.CreateIndexWizardPanel;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableCellRendererFilter;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.QueryUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.timer.Timer;
import pl.mpak.util.variant.Variant;

public class IndexesPanelView
extends JPanel
implements IRootTabObjectInfo {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName;
    private String tabTitle;
    private SqlFilter filter;
    private boolean viewClosing = false;
    private ISettings settings;
    private Timer timer;
    private OrbadaTabbedPane tabbedPane;
    private boolean refreshing = false;
    private ToolButton buttonActions;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private ToolButton buttonSelectSchema;
    private Action cmCoalasceIndex;
    private Action cmCreateIndex;
    private Action cmDropIndex;
    private Action cmFilter;
    private Action cmRefresh;
    private Action cmRenameIndex;
    private Action cmSelectSchema;
    private Action cmSimpleCreateIndex;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator3;
    private JPopupMenu menuActions;
    private JMenuItem menuCoalasceIndex;
    private JMenuItem menuCreateIndex;
    private JMenuItem menuDropIndex;
    private JMenuItem menuRenameIndex;
    private JMenuItem menuSimpleCreateIndex;
    private JPanel panelTables;
    private JSplitPane splitTables;
    private QueryTableStatusBar statusBarTables;
    private ViewTable tableIndexes;
    private JToolBar toolBarTables;

    public IndexesPanelView(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.tabTitle = this.accesibilities.getTabTitle();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.timer = new Timer(250L){
            {
                this.setEnabled(false);
            }

            public void run() {
                this.setEnabled(false);
                IndexesPanelView.this.refreshTabbedPanes();
            }
        };
        OrbadaOraclePlugin.getRefreshQueue().add(this.timer);
        this.tabbedPane = new OrbadaTabbedPane("INDEX", new Component[]{new IndexColumnsPanel(this.accesibilities), new IndexDetailsPanel(this.accesibilities), new IndexSizePanel(this.accesibilities), new IndexPartitionsPanel(this.accesibilities), new IndexSourcePanel(this.accesibilities)});
        this.splitTables.setRightComponent((Component)this.tabbedPane);
        this.settings = this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-indexes-panel");
        this.splitTables.setDividerLocation(this.settings.getValue("split-location", Long.valueOf(this.splitTables.getDividerLocation())).intValue());
        this.currentSchemaName = OracleDbInfoProvider.getCurrentSchema(this.getDatabase());
        this.tableIndexes.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!IndexesPanelView.this.refreshing) {
                    IndexesPanelView.this.timer.restart();
                }
            }
        });
        this.tableIndexes.getQuery().setDatabase(this.getDatabase());
        this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("index_name", this.stringManager.getString("index-name"), 200, (TableCellRenderer)new QueryTableCellRenderer(1)));
        this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("table_name", this.stringManager.getString("table-name"), 150));
        this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("uniqueness", this.stringManager.getString("uniqueness"), 50));
        this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("status", this.stringManager.getString("status"), 60, (TableCellRenderer)new QueryTableCellRenderer(new QueryTableCellRendererFilter(){

            public void cellRendererPerformed(JTable table, Component renderer, Object value, boolean isSelected, boolean hasFocus) {
                if (StringUtil.nvl((String)((String)value), (String)"").equals("VALID")) {
                    ((JLabel)renderer).setForeground(SwingUtil.Color.GREEN);
                } else if (StringUtil.nvl((String)((String)value), (String)"").equals("INVALID")) {
                    ((JLabel)renderer).setForeground(Color.RED);
                }
            }
        })));
        this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("index_type", this.stringManager.getString("index-type"), 60));
        this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("constraint", this.stringManager.getString("constraint"), 60));
        this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("initial_extent", this.stringManager.getString("initial-extent"), 70));
        this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("next_extent", this.stringManager.getString("next-extent"), 70));
        this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("min_extents", this.stringManager.getString("min-extent"), 70));
        this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("max_extents", this.stringManager.getString("max-extent"), 70));
        this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("pct_increase", this.stringManager.getString("pct-increase"), 50));
        this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("pct_free", this.stringManager.getString("pct-free"), 50));
        this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("tablespace_name", this.stringManager.getString("tablespace-name"), 100));
        SqlFilterDef def = new SqlFilterDef();
        def.add(new SqlFilterDefComponent("i.index_name", this.stringManager.getString("index-name"), (String[])null));
        def.add(new SqlFilterDefComponent("i.tablespace_name", this.stringManager.getString("tablespace-name"), (String[])null));
        def.add(new SqlFilterDefComponent("i.index_type", this.stringManager.getString("index-type"), new String[]{"", "'NORMAL'"}));
        def.add(new SqlFilterDefComponent("i.uniqueness = 'UNIQUE'", this.stringManager.getString("unique")));
        this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-indexes-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableIndexes, (JButton)this.buttonActions, this.menuActions, "oracle-indexes-actions");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                IndexesPanelView.this.tableIndexes.requestFocusInWindow();
            }
        });
    }

    public void setCurrentSchemaName(String schemaName) {
        if (!this.currentSchemaName.equals(schemaName)) {
            this.currentSchemaName = schemaName;
            if (!this.currentSchemaName.equalsIgnoreCase(OracleDbInfoProvider.getCurrentSchema(this.getDatabase()))) {
                this.accesibilities.setTabTitle(this.tabTitle + " (" + this.currentSchemaName + ")");
            } else {
                this.accesibilities.setTabTitle(this.tabTitle);
            }
        }
    }

    private void refreshTabbedPanes() {
        String indexName = "";
        int rowIndex = this.tableIndexes.getSelectedRow();
        if (rowIndex >= 0 && this.tableIndexes.getQuery().isActive()) {
            try {
                this.tableIndexes.getQuery().getRecord(rowIndex);
                indexName = this.tableIndexes.getQuery().fieldByName("index_name").getString();
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
        this.tabbedPane.refresh(null, this.currentSchemaName, indexName);
    }

    private void refreshTableListTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                IndexesPanelView.this.refresh();
            }
        });
    }

    public void refresh() {
        if (!this.isVisible() || this.viewClosing) {
            return;
        }
        try {
            String indexName = null;
            if (this.tableIndexes.getQuery().isActive() && this.tableIndexes.getSelectedRow() >= 0) {
                this.tableIndexes.getQuery().getRecord(this.tableIndexes.getSelectedRow());
                indexName = this.tableIndexes.getQuery().fieldByName("INDEX_NAME").getString();
            }
            this.refresh(indexName);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(String objectName) {
        this.refreshing = true;
        try {
            int column = this.tableIndexes.getSelectedColumn();
            int index = Math.max(0, this.tableIndexes.getSelectedRow());
            this.tableIndexes.getQuery().close();
            this.tableIndexes.getQuery().setSqlText(Sql.getAllIndexList(this.filter.getSqlText()));
            this.tableIndexes.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
            this.tableIndexes.getQuery().open();
            if (objectName != null && this.tableIndexes.getQuery().locate("INDEX_NAME", new Variant(objectName))) {
                this.tableIndexes.changeSelection(this.tableIndexes.getQuery().getCurrentRecord().getIndex(), column);
            } else if (!this.tableIndexes.getQuery().isEmpty()) {
                this.tableIndexes.changeSelection(Math.min(index, this.tableIndexes.getRowCount() - 1), column);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            this.refreshing = false;
            this.refreshTabbedPanes();
        }
    }

    public boolean canClose() {
        return this.tabbedPane.canClose();
    }

    public void close() throws IOException {
        this.timer.cancel();
        this.settings.setValue("split-location", Long.valueOf(this.splitTables.getDividerLocation()));
        this.viewClosing = true;
        this.tabbedPane.close();
        this.tableIndexes.getQuery().close();
        this.accesibilities = null;
        this.settings.store();
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmSelectSchema = new Action();
        this.cmFilter = new Action();
        this.menuActions = new JPopupMenu();
        this.menuCreateIndex = new JMenuItem();
        this.menuCoalasceIndex = new JMenuItem();
        this.menuRenameIndex = new JMenuItem();
        this.menuSimpleCreateIndex = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.menuDropIndex = new JMenuItem();
        this.cmDropIndex = new Action();
        this.cmSimpleCreateIndex = new Action();
        this.cmCreateIndex = new Action();
        this.cmCoalasceIndex = new Action();
        this.cmRenameIndex = new Action();
        this.splitTables = new JSplitPane();
        this.panelTables = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableIndexes = new ViewTable();
        this.jPanel1 = new JPanel();
        this.toolBarTables = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonSelectSchema = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator1 = new JSeparator();
        this.buttonActions = new ToolButton();
        this.jPanel2 = new JPanel();
        this.statusBarTables = new QueryTableStatusBar();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IndexesPanelView.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmSelectSchema.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/users16.gif"));
        this.cmSelectSchema.setText(this.stringManager.getString("cmSelectSchema-text"));
        this.cmSelectSchema.setTooltip(this.stringManager.getString("cmSelectSchema-hint"));
        this.cmSelectSchema.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IndexesPanelView.this.cmSelectSchemaActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/filter16.gif"));
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IndexesPanelView.this.cmFilterActionPerformed(evt);
            }
        });
        this.menuCreateIndex.setAction((javax.swing.Action)this.cmCreateIndex);
        this.menuActions.add(this.menuCreateIndex);
        this.menuCoalasceIndex.setAction((javax.swing.Action)this.cmCoalasceIndex);
        this.menuActions.add(this.menuCoalasceIndex);
        this.menuRenameIndex.setAction((javax.swing.Action)this.cmRenameIndex);
        this.menuActions.add(this.menuRenameIndex);
        this.menuSimpleCreateIndex.setAction((javax.swing.Action)this.cmSimpleCreateIndex);
        this.menuActions.add(this.menuSimpleCreateIndex);
        this.menuActions.add(this.jSeparator3);
        this.menuDropIndex.setAction((javax.swing.Action)this.cmDropIndex);
        this.menuActions.add(this.menuDropIndex);
        this.cmDropIndex.setActionCommandKey("cmDropIndex");
        this.cmDropIndex.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDropIndex.setText(this.stringManager.getString("cmDropIndex-text"));
        this.cmDropIndex.setTooltip(this.stringManager.getString("cmDropIndex-hint"));
        this.cmDropIndex.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IndexesPanelView.this.cmDropIndexActionPerformed(evt);
            }
        });
        this.cmSimpleCreateIndex.setActionCommandKey("cmSimpleCreateIndex");
        this.cmSimpleCreateIndex.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/index.gif"));
        this.cmSimpleCreateIndex.setText(this.stringManager.getString("cmSimpleCreateIndex-text"));
        this.cmSimpleCreateIndex.setTooltip(this.stringManager.getString("cmSimpleCreateIndex-hint"));
        this.cmSimpleCreateIndex.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IndexesPanelView.this.cmSimpleCreateIndexActionPerformed(evt);
            }
        });
        this.cmCreateIndex.setActionCommandKey("cmCreateIndex");
        this.cmCreateIndex.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/index.gif"));
        this.cmCreateIndex.setText(this.stringManager.getString("cmCreateIndex-text"));
        this.cmCreateIndex.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IndexesPanelView.this.cmCreateIndexActionPerformed(evt);
            }
        });
        this.cmCoalasceIndex.setActionCommandKey("cmCoalasceIndex");
        this.cmCoalasceIndex.setText(this.stringManager.getString("cmCoalasceIndex-text"));
        this.cmCoalasceIndex.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IndexesPanelView.this.cmCoalasceIndexActionPerformed(evt);
            }
        });
        this.cmRenameIndex.setActionCommandKey("cmCoalasceIndex");
        this.cmRenameIndex.setText(this.stringManager.getString("cmRenameIndex-text"));
        this.cmRenameIndex.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IndexesPanelView.this.cmRenameIndexActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                IndexesPanelView.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.splitTables.setBorder(null);
        this.splitTables.setDividerLocation(200);
        this.splitTables.setContinuousLayout(true);
        this.splitTables.setOneTouchExpandable(true);
        this.panelTables.setPreferredSize(new Dimension(250, 100));
        this.panelTables.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableIndexes);
        this.panelTables.add((Component)this.jScrollPane1, "Center");
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarTables.setFloatable(false);
        this.toolBarTables.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonRefresh);
        this.buttonSelectSchema.setAction((javax.swing.Action)this.cmSelectSchema);
        this.buttonSelectSchema.setHorizontalTextPosition(0);
        this.buttonSelectSchema.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonSelectSchema);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonFilter);
        this.jSeparator1.setOrientation(1);
        this.toolBarTables.add(this.jSeparator1);
        this.toolBarTables.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBarTables);
        this.panelTables.add((Component)this.jPanel1, "North");
        this.jPanel2.setLayout(new BorderLayout());
        this.statusBarTables.setShowFieldType(false);
        this.statusBarTables.setShowFieldValue(false);
        this.statusBarTables.setShowOpenTime(false);
        this.statusBarTables.setTable((QueryTable)this.tableIndexes);
        this.jPanel2.add((Component)this.statusBarTables, "South");
        this.panelTables.add((Component)this.jPanel2, "South");
        this.splitTables.setLeftComponent(this.panelTables);
        this.add((Component)this.splitTables, "Center");
    }

    private void formComponentShown(ComponentEvent evt) {
        if (!this.tableIndexes.getQuery().isActive()) {
            this.refreshTableListTask();
        }
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmSelectSchemaActionPerformed(ActionEvent evt) {
        Query query = this.getDatabase().createQuery();
        try {
            query.open(Sql.getSchemaList());
            Vector vl = QueryUtil.staticData((String)"{schema_name}", (Query)query);
            Point point = this.buttonSelectSchema.getLocationOnScreen();
            point.y += this.buttonSelectSchema.getHeight();
            SimpleSelectDialog.select((Window)SwingUtil.getWindowComponent((Component)this), (int)point.x, (int)point.y, (Vector)vl, (int)vl.indexOf(this.currentSchemaName), (SimpleSelectDialog.CallBack)new SimpleSelectDialog.CallBack(){

                public void selected(Object o) {
                    IndexesPanelView.this.setCurrentSchemaName(o.toString());
                    IndexesPanelView.this.refresh();
                }
            });
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refreshTableListTask();
    }

    private void cmDropIndexActionPerformed(ActionEvent evt) {
        if (this.tableIndexes.getSelectedRow() >= 0) {
            try {
                this.tableIndexes.getQuery().getRecord(this.tableIndexes.getSelectedRow());
                String indexName = this.tableIndexes.getQuery().fieldByName("index_name").getString();
                String tableName = this.tableIndexes.getQuery().fieldByName("table_name").getString();
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new DropIndexWizard(this.getDatabase(), this.currentSchemaName, tableName, indexName), (boolean)true) != null) {
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
    }

    private void cmSimpleCreateIndexActionPerformed(ActionEvent evt) {
        if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateIndexWizardPanel(this.getDatabase(), this.currentSchemaName, null), (boolean)true) != null) {
            this.refresh();
        }
    }

    private void cmCreateIndexActionPerformed(ActionEvent evt) {
        if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateIndexWizard(this.getDatabase(), this.currentSchemaName, null), (boolean)true) != null) {
            this.refresh();
        }
    }

    private void cmCoalasceIndexActionPerformed(ActionEvent evt) {
        if (this.tableIndexes.getSelectedRow() >= 0) {
            try {
                this.tableIndexes.getQuery().getRecord(this.tableIndexes.getSelectedRow());
                String indexName = this.tableIndexes.getQuery().fieldByName("index_name").getString();
                String tableName = this.tableIndexes.getQuery().fieldByName("table_name").getString();
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CoalasceIndexWizard(this.getDatabase(), this.currentSchemaName, tableName, indexName), (boolean)true) != null) {
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
    }

    private void cmRenameIndexActionPerformed(ActionEvent evt) {
        if (this.tableIndexes.getSelectedRow() >= 0) {
            try {
                this.tableIndexes.getQuery().getRecord(this.tableIndexes.getSelectedRow());
                String indexName = this.tableIndexes.getQuery().fieldByName("index_name").getString();
                String tableName = this.tableIndexes.getQuery().fieldByName("table_name").getString();
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new RenameIndexWizard(this.getDatabase(), this.currentSchemaName, tableName, indexName), (boolean)true) != null) {
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
    }
}

