/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.javas;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class JavaInnersPanel
extends JPanel
implements ITabObjectInfo {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName = "";
    private String currentObjectName = "";
    private boolean requestRefresh = false;
    private boolean closing = false;
    private SqlFilter filter;
    private ToolButton buttonActions;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private Action cmFilter;
    private Action cmRefresh;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JPopupMenu menuActions;
    private QueryTableStatusBar statusBar;
    private ViewTable tableInners;
    private JToolBar toolBarColumns;

    public JavaInnersPanel(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.tableInners.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableInners.addColumn((TableColumn)new QueryTableColumn("inner_index", this.stringManager.getString("pos"), 30));
            this.tableInners.addColumn((TableColumn)new QueryTableColumn("simple_name", this.stringManager.getString("class"), 300, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableInners.addColumn((TableColumn)new QueryTableColumn("accessibility", this.stringManager.getString("accessibility"), 80, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.GREEN)));
            this.tableInners.addColumn((TableColumn)new QueryTableColumn("is_interface", this.stringManager.getString("is-interface"), 30));
            SqlFilterDef def = new SqlFilterDef();
            def.add(new SqlFilterDefComponent("simple_name", this.stringManager.getString("class"), (String[])null));
            def.add(new SqlFilterDefComponent("accessibility", this.stringManager.getString("accessibility"), new String[]{"'PUBLIC'", "'PRIVATE'", "'PROTECTED'"}));
            def.add(new SqlFilterDefComponent("is_interface = 'YES'", this.stringManager.getString("are-interface")));
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-java-inners-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableInners, (JButton)this.buttonActions, this.menuActions, "oracle-java-inners-actions");
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public String getTitle() {
        return this.stringManager.getString("JavaInnersPanel-title");
    }

    private void refreshTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                JavaInnersPanel.this.refresh();
            }
        });
    }

    public void refresh() {
        try {
            String innerName = null;
            this.requestRefresh = false;
            if (this.tableInners.getQuery().isActive() && this.tableInners.getSelectedRow() >= 0) {
                this.tableInners.getQuery().getRecord(this.tableInners.getSelectedRow());
                innerName = this.tableInners.getQuery().fieldByName("simple_name").getString();
            }
            this.tableInners.getQuery().close();
            this.tableInners.getQuery().setSqlText(Sql.getJavaInnerList(this.filter.getSqlText()));
            this.tableInners.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
            this.tableInners.getQuery().paramByName("object_name").setString(this.currentObjectName);
            this.tableInners.getQuery().open();
            if (!this.tableInners.getQuery().isEmpty()) {
                if (innerName != null && this.tableInners.getQuery().locate("simple_name", new Variant(innerName))) {
                    this.tableInners.changeSelection(this.tableInners.getQuery().getCurrentRecord().getIndex(), 0);
                } else {
                    this.tableInners.changeSelection(0, 0);
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public void refresh(String catalogName, String schemaName, String objectName) {
        if (!this.currentSchemaName.equals(schemaName) || !this.currentObjectName.equals(objectName) || this.requestRefresh) {
            this.currentSchemaName = schemaName;
            this.currentObjectName = objectName;
            if (this.isVisible()) {
                this.refresh();
            } else {
                this.requestRefresh = true;
            }
        }
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.closing = true;
        this.tableInners.getQuery().close();
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.menuActions = new JPopupMenu();
        this.statusBar = new QueryTableStatusBar();
        this.jPanel1 = new JPanel();
        this.toolBarColumns = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.jScrollPane1 = new JScrollPane();
        this.tableInners = new ViewTable();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JavaInnersPanel.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JavaInnersPanel.this.cmFilterActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                JavaInnersPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.statusBar.setShowFieldType(false);
        this.statusBar.setShowOpenTime(false);
        this.statusBar.setTable((QueryTable)this.tableInners);
        this.add((Component)this.statusBar, "Last");
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarColumns.setFloatable(false);
        this.toolBarColumns.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.buttonRefresh);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.buttonFilter);
        this.toolBarColumns.add(this.jSeparator1);
        this.toolBarColumns.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBarColumns);
        this.add((Component)this.jPanel1, "North");
        this.jScrollPane1.setViewportView((Component)this.tableInners);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void formComponentShown(ComponentEvent evt) {
        if (this.requestRefresh && !this.closing) {
            this.refreshTask();
        }
    }
}

