/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.javas;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.timer.Timer;
import pl.mpak.util.variant.Variant;

public class JavaMethodsPanel
extends JPanel
implements ITabObjectInfo {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName = "";
    private String currentObjectName = "";
    private boolean requestRefresh = false;
    private boolean closing = false;
    private SqlFilter filter;
    private Timer timer;
    private ISettings settings;
    private ToolButton buttonActions;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private Action cmFilter;
    private Action cmRefresh;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JToolBar.Separator jSeparator1;
    private JPopupMenu menuActions;
    private JSplitPane splitArguments;
    private JSplitPane splitMethods;
    private QueryTableStatusBar statusBar;
    private ViewTable tableArguments;
    private ViewTable tableMethods;
    private ViewTable tableThrows;
    private JToolBar toolBarColumns;

    public JavaMethodsPanel(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.timer = new Timer(250L){
            {
                this.setEnabled(false);
            }

            public void run() {
                this.setEnabled(false);
                JavaMethodsPanel.this.refreshMethodInfo();
            }
        };
        OrbadaOraclePlugin.getRefreshQueue().add(this.timer);
        this.settings = this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-java-source-methods-panel");
        this.splitMethods.setDividerLocation(this.settings.getValue("split-methods-location", Long.valueOf(this.splitMethods.getDividerLocation())).intValue());
        this.splitArguments.setDividerLocation(this.settings.getValue("split-arguments-location", Long.valueOf(this.splitArguments.getDividerLocation())).intValue());
        this.tableMethods.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                JavaMethodsPanel.this.timer.restart();
            }
        });
        this.tableMethods.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableMethods.addColumn((TableColumn)new QueryTableColumn("method_index", this.stringManager.getString("pos"), 30));
            this.tableMethods.addColumn((TableColumn)new QueryTableColumn("accessibility", this.stringManager.getString("accessibility"), 80, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.GREEN)));
            this.tableMethods.addColumn((TableColumn)new QueryTableColumn("method_name", this.stringManager.getString("method-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableMethods.addColumn((TableColumn)new QueryTableColumn("return_type", this.stringManager.getString("return-type"), 150));
            SqlFilterDef def = new SqlFilterDef();
            def.add(new SqlFilterDefComponent("method_name", this.stringManager.getString("method-name"), (String[])null));
            def.add(new SqlFilterDefComponent("accessibility", this.stringManager.getString("accessibility"), (String[])null));
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-java-source-methods-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        this.tableArguments.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableArguments.getQuery().setSqlText(Sql.getJavaMethodArgumentList(null));
            this.tableArguments.addColumn((TableColumn)new QueryTableColumn("argument_position", this.stringManager.getString("pos"), 30));
            this.tableArguments.addColumn((TableColumn)new QueryTableColumn("argument_type", this.stringManager.getString("argument-type"), 250));
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        this.tableThrows.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableThrows.getQuery().setSqlText(Sql.getJavaMethodThrowList(null));
            this.tableThrows.addColumn((TableColumn)new QueryTableColumn("exception_index", this.stringManager.getString("pos"), 30));
            this.tableThrows.addColumn((TableColumn)new QueryTableColumn("exception_class", this.stringManager.getString("exception-class"), 250));
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableMethods, (JButton)this.buttonActions, this.menuActions, "oracle-java-methods-actions");
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public String getTitle() {
        return this.stringManager.getString("JavaMethodsPanel-title");
    }

    private void refreshMethodInfo() {
        int rowIndex = this.tableMethods.getSelectedRow();
        if (rowIndex >= 0 && this.tableMethods.getQuery().isActive()) {
            try {
                this.tableMethods.getQuery().getRecord(rowIndex);
                this.tableArguments.getQuery().close();
                this.tableArguments.getQuery().paramByName("method_index").setString(this.tableMethods.getQuery().fieldByName("method_index").getString());
                this.tableArguments.getQuery().open();
                this.tableThrows.getQuery().close();
                this.tableThrows.getQuery().paramByName("method_index").setString(this.tableMethods.getQuery().fieldByName("method_index").getString());
                this.tableThrows.getQuery().open();
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    private void refreshTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                JavaMethodsPanel.this.refresh();
            }
        });
    }

    public void refresh() {
        try {
            String attrName = null;
            this.requestRefresh = false;
            if (this.tableMethods.getQuery().isActive() && this.tableMethods.getSelectedRow() >= 0) {
                this.tableMethods.getQuery().getRecord(this.tableMethods.getSelectedRow());
                attrName = this.tableMethods.getQuery().fieldByName("method_name").getString();
            }
            this.tableArguments.getQuery().close();
            this.tableMethods.getQuery().close();
            this.tableMethods.getQuery().setSqlText(Sql.getJavaMethodList(this.filter.getSqlText()));
            this.tableMethods.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
            this.tableMethods.getQuery().paramByName("object_name").setString(this.currentObjectName);
            this.tableMethods.getQuery().open();
            this.tableArguments.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
            this.tableArguments.getQuery().paramByName("object_name").setString(this.currentObjectName);
            this.tableThrows.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
            this.tableThrows.getQuery().paramByName("object_name").setString(this.currentObjectName);
            if (!this.tableMethods.getQuery().isEmpty()) {
                if (attrName != null && this.tableMethods.getQuery().locate("method_name", new Variant(attrName))) {
                    this.tableMethods.changeSelection(this.tableMethods.getQuery().getCurrentRecord().getIndex(), 0);
                } else {
                    this.tableMethods.changeSelection(0, 0);
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public void refresh(String catalogName, String schemaName, String objectName) {
        if (!this.currentSchemaName.equals(schemaName) || !this.currentObjectName.equals(objectName) || this.requestRefresh) {
            this.currentSchemaName = schemaName;
            this.currentObjectName = objectName;
            if (this.isVisible()) {
                this.refresh();
            } else {
                this.requestRefresh = true;
            }
        }
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.settings.setValue("split-methods-location", Long.valueOf(this.splitMethods.getDividerLocation()));
        this.settings.setValue("split-arguments-location", Long.valueOf(this.splitArguments.getDividerLocation()));
        this.settings.store();
        this.timer.cancel();
        this.closing = true;
        this.tableMethods.getQuery().close();
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.menuActions = new JPopupMenu();
        this.statusBar = new QueryTableStatusBar();
        this.jPanel1 = new JPanel();
        this.toolBarColumns = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.splitMethods = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.tableMethods = new ViewTable();
        this.splitArguments = new JSplitPane();
        this.jScrollPane2 = new JScrollPane();
        this.tableArguments = new ViewTable();
        this.jScrollPane3 = new JScrollPane();
        this.tableThrows = new ViewTable();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JavaMethodsPanel.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JavaMethodsPanel.this.cmFilterActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                JavaMethodsPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.statusBar.setShowFieldType(false);
        this.statusBar.setShowOpenTime(false);
        this.statusBar.setTable((QueryTable)this.tableMethods);
        this.add((Component)this.statusBar, "Last");
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarColumns.setFloatable(false);
        this.toolBarColumns.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.buttonRefresh);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.buttonFilter);
        this.toolBarColumns.add(this.jSeparator1);
        this.toolBarColumns.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBarColumns);
        this.add((Component)this.jPanel1, "North");
        this.splitMethods.setBorder(null);
        this.splitMethods.setDividerLocation(250);
        this.splitMethods.setOrientation(0);
        this.splitMethods.setContinuousLayout(true);
        this.splitMethods.setOneTouchExpandable(true);
        this.jScrollPane1.setViewportView((Component)this.tableMethods);
        this.splitMethods.setLeftComponent(this.jScrollPane1);
        this.splitArguments.setBorder(null);
        this.splitArguments.setDividerLocation(300);
        this.splitArguments.setContinuousLayout(true);
        this.splitArguments.setOneTouchExpandable(true);
        this.jScrollPane2.setViewportView((Component)this.tableArguments);
        this.splitArguments.setLeftComponent(this.jScrollPane2);
        this.jScrollPane3.setViewportView((Component)this.tableThrows);
        this.splitArguments.setRightComponent(this.jScrollPane3);
        this.splitMethods.setRightComponent(this.splitArguments);
        this.add((Component)this.splitMethods, "Center");
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void formComponentShown(ComponentEvent evt) {
        if (this.requestRefresh && !this.closing) {
            this.refreshTask();
        }
    }
}

