/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.jobs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.ComboBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.script.SimpleSQLScript;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class JobEditWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private Long job;
    private ArrayList<Interval> intervalList;
    private ToolButton buttonInterval;
    private ToolButton buttonSzeduler;
    private JCheckBox checkCommit;
    private JCheckBox checkForce;
    private Action cmSheduler;
    private ComboBox comboInterval;
    private ComboBox comboNextDate;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private TextField textInstance;
    private OrbadaSyntaxTextArea textWhat;

    public JobEditWizard(Database database, Long job) {
        this.database = database;
        this.job = job;
        this.intervalList = new ArrayList();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.intervalList.add(new Interval(this.stringManager.getString("immediately"), ""));
        this.intervalList.add(new Interval(this.stringManager.getString("per-minute"), "sysdate +1/60/24"));
        this.intervalList.add(new Interval(this.stringManager.getString("half-an-hour"), "sysdate +0.5/24"));
        this.intervalList.add(new Interval(this.stringManager.getString("per-hour"), "sysdate +1/24"));
        this.intervalList.add(new Interval(this.stringManager.getString("for-2-weeks"), "sysdate +2/24"));
        this.intervalList.add(new Interval(this.stringManager.getString("o-clock"), "trunc(sysdate +1/24, 'hh')"));
        this.intervalList.add(new Interval(this.stringManager.getString("15-minutes-after-the-hour"), "trunc(sysdate +1/24, 'hh') +15/60/24"));
        this.intervalList.add(new Interval(this.stringManager.getString("on-the-1st-night"), "trunc(sysdate) +1/24"));
        this.intervalList.add(new Interval(this.stringManager.getString("about-6-am"), "trunc(sysdate) +6/24"));
        this.intervalList.add(new Interval(this.stringManager.getString("the-next-day-at-3rd-10"), "trunc(sysdate)+1+3/24 +10/60/24"));
        this.intervalList.add(new Interval(this.stringManager.getString("1st-day-of-the-month-on-the-1st-night"), "add_months(trunc(sysdate,'MM'),1) +1/24"));
        DefaultListCellRenderer renderer = new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof Interval) {
                    this.setText(((Interval)value).title);
                }
                return this;
            }
        };
        this.comboNextDate.setModel(new DefaultComboBoxModel<Object>(this.intervalList.toArray()));
        this.comboNextDate.setRenderer((ListCellRenderer)renderer);
        this.comboInterval.setModel(new DefaultComboBoxModel<Object>(this.intervalList.toArray()));
        this.comboInterval.setRenderer((ListCellRenderer)renderer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wizardShow() {
        this.textWhat.setDatabase(this.database);
        if (this.job != null) {
            Query query = this.database.createQuery();
            try {
                if ("true".equalsIgnoreCase(this.database.getUserProperties().getProperty("dba-role"))) {
                    query.setSqlText("select * from dba_jobs where job = :JOB");
                } else {
                    query.setSqlText("select INTERVAL, WHAT, INSTANCE from user_jobs where job = :JOB");
                }
                query.paramByName("JOB").setLong(this.job.longValue());
                query.open();
                if (!query.fieldByName("INSTANCE").isNull() && query.fieldByName("INSTANCE").getLong() != 0L) {
                    this.textInstance.setText(query.fieldByName("INSTANCE").getString());
                }
                this.textWhat.setText(query.fieldByName("WHAT").getString());
                ((JTextField)this.comboNextDate.getEditor().getEditorComponent()).setText(query.fieldByName("INTERVAL").getString());
                ((JTextField)this.comboInterval.getEditor().getEditorComponent()).setText(query.fieldByName("INTERVAL").getString());
            }
            catch (Exception ex) {
                MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
            finally {
                query.close();
            }
        }
    }

    public String getDialogTitle() {
        return this.job == null ? this.stringManager.getString("new-task") : this.stringManager.getString("edit-task");
    }

    public String getTabTitle() {
        return this.stringManager.getString("JobEditWizard-title");
    }

    public String getSqlCode() {
        String nextDate = ((JTextField)this.comboNextDate.getEditor().getEditorComponent()).getText();
        String interval = StringUtil.replaceString((String)((JTextField)this.comboInterval.getEditor().getEditorComponent()).getText(), (String)"'", (String)"''");
        String what = StringUtil.replaceString((String)this.textWhat.getText(), (String)"'", (String)"''");
        StringBuffer sb = new StringBuffer();
        if (this.job == null) {
            sb.append("DECLARE\n");
            sb.append("  JOB NUMBER;\n");
            sb.append("BEGIN\n");
            sb.append("  DBMS_JOB.SUBMIT(\n");
            sb.append("    JOB => JOB,\n");
            sb.append("    WHAT => '" + what + "'");
            if (!"".equals(nextDate)) {
                sb.append(",\n    NEXT_DATE => " + nextDate);
            }
            if (!"".equals(interval)) {
                sb.append(",\n    INTERVAL => '" + interval + "'");
            }
            if (!"".equals(this.textInstance.getText())) {
                sb.append(",\n    INSTANCE => " + this.textInstance.getText());
                if (this.checkForce.isSelected()) {
                    sb.append(",\n    FORCE => TRUE");
                }
            }
            sb.append("\n  );\n");
            sb.append("  DBMS_OUTPUT.PUT_LINE(JOB);\n");
            sb.append("END;\n/\n");
        } else {
            sb.append("BEGIN\n");
            sb.append("  DBMS_JOB.CHANGE(\n");
            sb.append("    JOB => " + this.job + ",\n");
            sb.append("    WHAT => '" + what + "',\n");
            sb.append("    NEXT_DATE => " + ("".equals(nextDate) ? "SYSDATE" : nextDate) + ",\n");
            sb.append("    INTERVAL => '" + interval + "'");
            if (!"".equals(this.textInstance.getText())) {
                sb.append(",\n    INSTANCE => " + this.textInstance.getText());
                if (this.checkForce.isSelected()) {
                    sb.append(",\n    FORCE => TRUE");
                }
            }
            sb.append("\n  );\n");
            sb.append("END;\n/\n");
        }
        if (this.checkCommit.isSelected()) {
            sb.append("COMMIT\n/\n");
        }
        return sb.toString();
    }

    public boolean execute() {
        SimpleSQLScript script = new SimpleSQLScript(this.database);
        if (!script.executeScript(this.getSqlCode())) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)script.getErrors(), (int)1, (int)0);
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.cmSheduler = new Action();
        this.jLabel1 = new JLabel();
        this.comboNextDate = new ComboBox();
        this.buttonSzeduler = new ToolButton();
        this.jLabel2 = new JLabel();
        this.comboInterval = new ComboBox();
        this.buttonInterval = new ToolButton();
        this.jLabel3 = new JLabel();
        this.checkCommit = new JCheckBox();
        this.textWhat = new OrbadaSyntaxTextArea();
        this.jLabel4 = new JLabel();
        this.textInstance = new TextField();
        this.checkForce = new JCheckBox();
        this.cmSheduler.setActionCommandKey("cmSheduler");
        this.cmSheduler.setEnabled(false);
        this.cmSheduler.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/shedule.gif"));
        this.cmSheduler.setText(this.stringManager.getString("cmSheduler-text"));
        this.setPreferredSize(new Dimension(400, 300));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText(this.stringManager.getString("execution-time-dd"));
        this.comboNextDate.setEditable(true);
        this.buttonSzeduler.setAction((javax.swing.Action)this.cmSheduler);
        this.buttonSzeduler.setPreferredSize(new Dimension(24, 24));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("interval-time-dd"));
        this.comboInterval.setEditable(true);
        this.buttonInterval.setAction((javax.swing.Action)this.cmSheduler);
        this.buttonInterval.setPreferredSize(new Dimension(24, 24));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("pl-sql-command-dd"));
        this.checkCommit.setSelected(true);
        this.checkCommit.setText(this.stringManager.getString("commit-changes"));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText(this.stringManager.getString("instance-no-dd"));
        this.checkForce.setText(this.stringManager.getString("check-if-runing"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, -1, 117, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.textWhat, -1, 259, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent((Component)this.comboInterval, -1, 229, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.buttonInterval, -2, -1, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent((Component)this.comboNextDate, -1, 229, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.buttonSzeduler, -2, -1, -2)).addComponent(this.checkCommit).addGroup(layout.createSequentialGroup().addComponent((Component)this.textInstance, -2, 41, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkForce))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.buttonSzeduler, -2, -1, -2).addComponent(this.jLabel1).addComponent((Component)this.comboNextDate, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.buttonInterval, -2, -1, -2).addComponent((Component)this.comboInterval, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent((Component)this.textWhat, -1, 171, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent((Component)this.textInstance, -2, -1, -2).addComponent(this.checkForce)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkCommit).addContainerGap()));
    }

    private class Interval {
        public String title;
        public String sqlCode;

        public Interval(String title, String sqlCode) {
            this.title = title;
            this.sqlCode = sqlCode;
        }

        public String getSqlCode() {
            return this.sqlCode;
        }

        public String getTitle() {
            return this.title;
        }

        public String toString() {
            return this.sqlCode;
        }
    }
}

