/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.jobs;

import java.awt.Component;
import java.awt.Container;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.script.SimpleSQLScript;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class JobRemoveWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private Long job;
    private JCheckBox checkCommit;

    public JobRemoveWizard(Database database, Long job) {
        this.database = database;
        this.job = job;
        this.initComponents();
        this.init();
    }

    private void init() {
    }

    public void wizardShow() {
    }

    public String getDialogTitle() {
        return this.stringManager.getString("JobRemoveWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("JobRemoveWizard-tab-title");
    }

    public String getSqlCode() {
        StringBuffer sb = new StringBuffer();
        sb.append("BEGIN\n");
        if ("true".equalsIgnoreCase(this.database.getUserProperties().getProperty("dba-role"))) {
            sb.append("  DBMS_IJOB.REMOVE(\n");
        } else {
            sb.append("  DBMS_JOB.REMOVE(\n");
        }
        sb.append("    JOB => " + this.job + "\n");
        sb.append("  );\n");
        sb.append("END;\n/\n");
        if (this.checkCommit.isSelected()) {
            sb.append("COMMIT\n/\n");
        }
        return sb.toString();
    }

    public boolean execute() {
        SimpleSQLScript script = new SimpleSQLScript(this.database);
        if (!script.executeScript(this.getSqlCode())) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)script.getErrors(), (int)1, (int)0);
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.checkCommit = new JCheckBox();
        this.checkCommit.setSelected(true);
        this.checkCommit.setText(this.stringManager.getString("commit-changes"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.checkCommit).addContainerGap(227, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.checkCommit).addContainerGap(270, Short.MAX_VALUE)));
    }
}

