/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.jobs;

import java.awt.Component;
import java.awt.Container;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.script.SimpleSQLScript;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class JobRunWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private Long job;
    private JCheckBox checkForce;

    public JobRunWizard(Database database, Long job) {
        this.database = database;
        this.job = job;
        this.initComponents();
        this.init();
    }

    private void init() {
    }

    public void wizardShow() {
    }

    public String getDialogTitle() {
        return this.stringManager.getString("JobRunWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("JobRunWizard-tab-title");
    }

    public String getSqlCode() {
        StringBuffer sb = new StringBuffer();
        sb.append("BEGIN\n");
        sb.append("  DBMS_JOB.RUN(\n");
        sb.append("    JOB => " + this.job);
        if (this.checkForce.isSelected()) {
            sb.append(",\n    FORCE => TRUE");
        }
        sb.append("\n  );\n");
        sb.append("END;\n/\n");
        return sb.toString();
    }

    public boolean execute() {
        SimpleSQLScript script = new SimpleSQLScript(this.database);
        if (!script.executeScript(this.getSqlCode())) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)script.getErrors(), (int)1, (int)0);
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.checkForce = new JCheckBox();
        this.checkForce.setText(this.stringManager.getString("check-if-instance-runing"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.checkForce).addContainerGap(177, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.checkForce).addContainerGap(270, Short.MAX_VALUE)));
    }
}

