/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.jobs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.gui.jobs.JobEditWizard;
import pl.mpak.orbada.oracle.gui.jobs.JobRemoveWizard;
import pl.mpak.orbada.oracle.gui.jobs.JobRunWizard;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Command;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.timer.Timer;
import pl.mpak.util.variant.Variant;

public class JobsPanelView
extends JPanel
implements IRootTabObjectInfo {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private IViewAccesibilities accesibilities;
    private SqlFilter filter;
    private boolean viewClosing = false;
    private Timer timer;
    private Query sysdate;
    private ToolButton buttonActions;
    private ToolButton buttonBroken;
    private ToolButton buttonEditJob;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private ToolButton buttonRemoveJob;
    private ToolButton buttonRunJob;
    private ToolButton buttonSubmitJob;
    private Action cmBrokenJob;
    private Action cmEditJob;
    private Action cmFilter;
    private Action cmRefresh;
    private Action cmRemoveJob;
    private Action cmRunJob;
    private Action cmSubmitJob;
    private JComboBox comboRefresh;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JLabel labelRefresh;
    private JLabel labelSysdate;
    private JPopupMenu menuActions;
    private QueryTableStatusBar statusBar;
    private ViewTable tableJobs;
    private JToolBar toolBar;

    public JobsPanelView(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.timer = new Timer(1000L){
            {
                this.setEnabled(false);
            }

            public void run() {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        JobsPanelView.this.refresh();
                    }
                });
            }
        };
        OrbadaOraclePlugin.getRefreshQueue().add(this.timer);
        this.tableJobs.getQuery().setDatabase(this.getDatabase());
        try {
            this.sysdate = this.getDatabase().createQuery("select sysdate from dual", false);
            final QueryTableCellRenderer renderer = new QueryTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (!isSelected) {
                        try {
                            if (!JobsPanelView.this.tableJobs.getQuery().fieldByName("this_date").isNull()) {
                                label.setBackground(new Color(200, 255, 200));
                            } else if ("Y".equals(JobsPanelView.this.tableJobs.getQuery().fieldByName("broken").getString())) {
                                label.setBackground(new Color(255, 200, 200));
                            }
                        }
                        catch (Exception ex) {
                            label.setText(label.getText() + " [" + ex.getMessage() + "]");
                        }
                    }
                    return label;
                }
            };
            this.tableJobs.addColumn((TableColumn)new QueryTableColumn("job", this.stringManager.getString("job-no"), 60, (TableCellRenderer)renderer));
            this.tableJobs.addColumn((TableColumn)new QueryTableColumn("schema_name", this.stringManager.getString("schema-name"), 100, (TableCellRenderer)renderer));
            this.tableJobs.addColumn((TableColumn)new QueryTableColumn("last_date", this.stringManager.getString("last-date"), 120, (TableCellRenderer)renderer));
            this.tableJobs.addColumn((TableColumn)new QueryTableColumn("this_date", this.stringManager.getString("this-date"), 120, (TableCellRenderer)renderer));
            this.tableJobs.addColumn((TableColumn)new QueryTableColumn("next_date", this.stringManager.getString("next-date"), 120, (TableCellRenderer)renderer));
            this.tableJobs.addColumn((TableColumn)new QueryTableColumn("total_time", this.stringManager.getString("total-time"), 70, (TableCellRenderer)renderer));
            this.tableJobs.addColumn((TableColumn)new QueryTableColumn("broken", this.stringManager.getString("broken"), 50, (TableCellRenderer)new QueryTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JLabel label = (JLabel)renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    try {
                        label.setHorizontalAlignment(0);
                        if ("Y".equals(JobsPanelView.this.tableJobs.getQuery().fieldByName("broken").getString())) {
                            label.setText(JobsPanelView.this.stringManager.getString("yes"));
                        } else {
                            label.setText("-");
                        }
                    }
                    catch (Exception ex) {
                        label.setText(label.getText() + " [" + ex.getMessage() + "]");
                    }
                    return label;
                }
            }));
            this.tableJobs.addColumn((TableColumn)new QueryTableColumn("failures", this.stringManager.getString("failures"), 50, (TableCellRenderer)renderer));
            this.tableJobs.addColumn((TableColumn)new QueryTableColumn("what", this.stringManager.getString("job-what"), 350, (TableCellRenderer)renderer));
            this.tableJobs.addColumn((TableColumn)new QueryTableColumn("interval", this.stringManager.getString("interval"), 350, (TableCellRenderer)renderer));
            this.tableJobs.addColumn((TableColumn)new QueryTableColumn("nls_env", this.stringManager.getString("nls-env"), 350, (TableCellRenderer)renderer));
            SqlFilterDef def = new SqlFilterDef();
            def.add(new SqlFilterDefComponent("broken = 'Y'", this.stringManager.getString("are-broken")));
            def.add(new SqlFilterDefComponent("schema_name", this.stringManager.getString("schema-name"), (String[])null));
            def.add(new SqlFilterDefComponent("what", this.stringManager.getString("job-what"), (String[])null));
            def.add(new SqlFilterDefComponent("this_date is not null", this.stringManager.getString("are-this-date")));
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-jobs-view-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableJobs, (JButton)this.buttonActions, this.menuActions, "oracle-jobs-actions");
    }

    private void refreshListTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                JobsPanelView.this.refresh();
            }
        });
    }

    public void refresh() {
        if (!SwingUtil.isVisible((Component)this) || this.viewClosing) {
            return;
        }
        try {
            String objectName = null;
            if (this.tableJobs.getQuery().isActive() && this.tableJobs.getSelectedRow() >= 0) {
                this.tableJobs.getQuery().getRecord(this.tableJobs.getSelectedRow());
                objectName = this.tableJobs.getQuery().fieldByName("job").getString();
            }
            this.refresh(objectName);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(String objectName) {
        block6: {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    JobsPanelView.this.labelRefresh.setEnabled(true);
                }
            });
            try {
                this.sysdate.refresh();
                this.labelSysdate.setText(" " + this.sysdate.fieldByName("sysdate").getString());
                int column = this.tableJobs.getSelectedColumn();
                int index = Math.max(0, this.tableJobs.getSelectedRow());
                this.tableJobs.getQuery().close();
                this.tableJobs.getQuery().setSqlText(Sql.getJobList(this.filter.getSqlText(), "true".equalsIgnoreCase(this.accesibilities.getDatabase().getUserProperties().getProperty("dba-role"))));
                this.tableJobs.getQuery().open();
                if (this.tableJobs.getQuery().getOpeningTime() > this.getRefreshTime() * 1000000L) {
                    this.comboRefresh.setSelectedIndex(this.comboRefresh.getSelectedIndex() + 1);
                }
                if (objectName != null && this.tableJobs.getQuery().locate("job", new Variant(objectName))) {
                    this.tableJobs.changeSelection(this.tableJobs.getQuery().getCurrentRecord().getIndex(), column);
                    break block6;
                }
                if (this.tableJobs.getQuery().isEmpty()) break block6;
                this.tableJobs.changeSelection(Math.min(index, this.tableJobs.getRowCount() - 1), column);
            }
            catch (Exception ex) {
                try {
                    ExceptionUtil.processException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            JobsPanelView.this.labelRefresh.setEnabled(false);
                        }
                    });
                    throw throwable;
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        }
        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    private long getRefreshTime() {
        if (this.comboRefresh.getSelectedIndex() == 0) {
            return 1000000L;
        }
        return (long)(Double.parseDouble(this.comboRefresh.getSelectedItem().toString()) * 1000.0);
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.timer.cancel();
        this.viewClosing = true;
        this.sysdate.close();
        this.tableJobs.getQuery().close();
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.menuActions = new JPopupMenu();
        this.cmSubmitJob = new Action();
        this.cmEditJob = new Action();
        this.cmRemoveJob = new Action();
        this.cmRunJob = new Action();
        this.cmBrokenJob = new Action();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableJobs = new ViewTable();
        this.statusBar = new QueryTableStatusBar();
        this.jPanel2 = new JPanel();
        this.toolBar = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.buttonSubmitJob = new ToolButton();
        this.buttonEditJob = new ToolButton();
        this.buttonBroken = new ToolButton();
        this.buttonRunJob = new ToolButton();
        this.jSeparator4 = new JToolBar.Separator();
        this.buttonRemoveJob = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jLabel1 = new JLabel();
        this.comboRefresh = new JComboBox();
        this.jLabel2 = new JLabel();
        this.labelRefresh = new JLabel();
        this.labelSysdate = new JLabel();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JobsPanelView.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JobsPanelView.this.cmFilterActionPerformed(evt);
            }
        });
        this.cmSubmitJob.setActionCommandKey("cmSubmitJob");
        this.cmSubmitJob.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/new16.gif"));
        this.cmSubmitJob.setText(this.stringManager.getString("cmSubmitJob-text"));
        this.cmSubmitJob.setTooltip(this.stringManager.getString("cmSubmitJob-hint"));
        this.cmSubmitJob.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JobsPanelView.this.cmSubmitJobActionPerformed(evt);
            }
        });
        this.cmEditJob.setActionCommandKey("cmEditJob");
        this.cmEditJob.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/edit16.gif"));
        this.cmEditJob.setText(this.stringManager.getString("cmEditJob-text"));
        this.cmEditJob.setTooltip(this.stringManager.getString("cmEditJob-hint"));
        this.cmEditJob.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JobsPanelView.this.cmEditJobActionPerformed(evt);
            }
        });
        this.cmRemoveJob.setActionCommandKey("cmRemoveJob");
        this.cmRemoveJob.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmRemoveJob.setText(this.stringManager.getString("cmRemoveJob-text"));
        this.cmRemoveJob.setTooltip(this.stringManager.getString("cmRemoveJob-hint"));
        this.cmRemoveJob.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JobsPanelView.this.cmRemoveJobActionPerformed(evt);
            }
        });
        this.cmRunJob.setActionCommandKey("cmRunJob");
        this.cmRunJob.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/db_sql_execute16.gif"));
        this.cmRunJob.setText(this.stringManager.getString("cmRunJob-text"));
        this.cmRunJob.setTooltip(this.stringManager.getString("cmRunJob-hint"));
        this.cmRunJob.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JobsPanelView.this.cmRunJobActionPerformed(evt);
            }
        });
        this.cmBrokenJob.setActionCommandKey("cmBrokenJob");
        this.cmBrokenJob.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/green_bdot.gif"));
        this.cmBrokenJob.setText(this.stringManager.getString("cmBrokenJob-text"));
        this.cmBrokenJob.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JobsPanelView.this.cmBrokenJobActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                JobsPanelView.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableJobs);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.statusBar.setShowFieldType(false);
        this.statusBar.setShowOpenTime(false);
        this.statusBar.setTable((QueryTable)this.tableJobs);
        this.jPanel1.add((Component)this.statusBar, "South");
        this.add((Component)this.jPanel1, "Center");
        this.jPanel2.setLayout(new FlowLayout(0, 0, 0));
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonRefresh);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonFilter);
        this.toolBar.add(this.jSeparator3);
        this.buttonSubmitJob.setAction((javax.swing.Action)this.cmSubmitJob);
        this.buttonSubmitJob.setHorizontalTextPosition(0);
        this.buttonSubmitJob.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonSubmitJob);
        this.buttonEditJob.setAction((javax.swing.Action)this.cmEditJob);
        this.buttonEditJob.setHorizontalTextPosition(0);
        this.buttonEditJob.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonEditJob);
        this.buttonBroken.setAction((javax.swing.Action)this.cmBrokenJob);
        this.buttonBroken.setHorizontalTextPosition(0);
        this.buttonBroken.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonBroken);
        this.buttonRunJob.setAction((javax.swing.Action)this.cmRunJob);
        this.buttonRunJob.setHorizontalTextPosition(0);
        this.buttonRunJob.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonRunJob);
        this.toolBar.add(this.jSeparator4);
        this.buttonRemoveJob.setAction((javax.swing.Action)this.cmRemoveJob);
        this.buttonRemoveJob.setHorizontalTextPosition(0);
        this.buttonRemoveJob.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonRemoveJob);
        this.toolBar.add(this.jSeparator1);
        this.toolBar.add((Component)this.buttonActions);
        this.toolBar.add(this.jSeparator2);
        this.jLabel1.setText(this.stringManager.getString("refresh-dd"));
        this.toolBar.add(this.jLabel1);
        this.comboRefresh.setModel(new DefaultComboBoxModel<String>(new String[]{"off", "0.5", "1", "5", "10", "30", "60", "120"}));
        this.comboRefresh.setPreferredSize(new Dimension(60, 22));
        this.comboRefresh.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                JobsPanelView.this.comboRefreshItemStateChanged(evt);
            }
        });
        this.toolBar.add(this.comboRefresh);
        this.jLabel2.setText(" s ");
        this.toolBar.add(this.jLabel2);
        this.labelRefresh.setIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/orange_bdot.gif"));
        this.toolBar.add(this.labelRefresh);
        this.labelSysdate.setText("SYSDATE");
        this.labelSysdate.setToolTipText("<html><font color=gray>SELECT</font>&nbsp;<b>SYSDATE</b>&nbsp;<font color=gray>FROM DUAL</font>");
        this.toolBar.add(this.labelSysdate);
        this.jPanel2.add(this.toolBar);
        this.add((Component)this.jPanel2, "North");
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void formComponentShown(ComponentEvent evt) {
        if (!this.tableJobs.getQuery().isActive()) {
            this.refreshListTask();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void comboRefreshItemStateChanged(ItemEvent evt) {
        if (this.comboRefresh.getSelectedItem() != null) {
            if (this.comboRefresh.getSelectedIndex() > 0) {
                this.timer.setInterval((long)((int)this.getRefreshTime()));
                this.timer.setEnabled(true);
            } else {
                this.timer.setEnabled(false);
            }
        }
    }

    private void cmSubmitJobActionPerformed(ActionEvent evt) {
        SqlCodeWizardDialog.show((SqlCodeWizardPanel)new JobEditWizard(this.getDatabase(), null), (boolean)true);
    }

    private void cmEditJobActionPerformed(ActionEvent evt) {
        if (this.tableJobs.getSelectedRow() >= 0) {
            try {
                this.tableJobs.getQuery().getRecord(this.tableJobs.getSelectedRow());
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new JobEditWizard(this.getDatabase(), this.tableJobs.getQuery().fieldByName("JOB").getLong()), (boolean)true) != null) {
                    this.refresh();
                }
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    private void cmRemoveJobActionPerformed(ActionEvent evt) {
        if (this.tableJobs.getSelectedRow() >= 0) {
            try {
                this.tableJobs.getQuery().getRecord(this.tableJobs.getSelectedRow());
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new JobRemoveWizard(this.getDatabase(), this.tableJobs.getQuery().fieldByName("JOB").getLong()), (boolean)true) != null) {
                    this.refresh();
                }
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    private void cmRunJobActionPerformed(ActionEvent evt) {
        if (this.tableJobs.getSelectedRow() >= 0) {
            try {
                this.tableJobs.getQuery().getRecord(this.tableJobs.getSelectedRow());
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new JobRunWizard(this.getDatabase(), this.tableJobs.getQuery().fieldByName("JOB").getLong()), (boolean)true) != null) {
                    this.refresh();
                }
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    private void cmBrokenJobActionPerformed(ActionEvent evt) {
        if (this.tableJobs.getSelectedRow() >= 0) {
            try {
                this.tableJobs.getQuery().getRecord(this.tableJobs.getSelectedRow());
                Command command = this.getDatabase().createCommand();
                if ("true".equalsIgnoreCase(this.getDatabase().getUserProperties().getProperty("dba-role"))) {
                    command.setSqlText("BEGIN\n  DBMS_IJOB.BROKEN(:JOB, &STATE);\n  COMMIT;\nEND;");
                } else {
                    command.setSqlText("BEGIN\n  DBMS_JOB.BROKEN(:JOB, &STATE);\n  COMMIT;\nEND;");
                }
                command.paramByName("JOB").setLong(this.tableJobs.getQuery().fieldByName("JOB").getLong());
                command.paramByName("&STATE").setString("Y".equalsIgnoreCase(this.tableJobs.getQuery().fieldByName("BROKEN").getString()) ? "FALSE" : "TRUE");
                command.execute();
                this.refresh();
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }
}

