/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.mviews;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.VerticalQueryTablePanel;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.gui.wizards.mview.CreateMViewIndexWizard;
import pl.mpak.orbada.oracle.gui.wizards.mview.DropMViewIndexWizard;
import pl.mpak.orbada.oracle.gui.wizards.mview.RebuildMViewIndexWizard;
import pl.mpak.orbada.oracle.gui.wizards.mview.RenameMViewIndexWizard;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableColumnModel;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class MViewIndexesPanel
extends JPanel
implements ITabObjectInfo {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName = "";
    private String currentTableName = "";
    private boolean requestRefresh = false;
    private boolean closing = false;
    private SqlFilter filter;
    private VerticalQueryTablePanel indexInfoPanel;
    private ISettings settings;
    private ToolButton buttonActions;
    private JToggleButton buttonExpressionColumn;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private Action cmCreateIndex;
    private Action cmDropIndex;
    private Action cmExpressionColumn;
    private Action cmFilter;
    private Action cmRebuildIndex;
    private Action cmRefresh;
    private Action cmRenameIndex;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JSeparator jSeparator3;
    private JPopupMenu menuActions;
    private JMenuItem menuCreateIndex;
    private JMenuItem menuDropIndex;
    private JMenuItem menuRebuildIndex;
    private JMenuItem menuRenameIndex;
    private JSplitPane splitIndex;
    private QueryTableStatusBar statusBarIndexes;
    private ViewTable tableIndexes;
    private JToolBar toolBarIndexes;

    public MViewIndexesPanel(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.settings = this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-mview-index-panel");
        this.indexInfoPanel = new VerticalQueryTablePanel(this.getDatabase());
        this.splitIndex.setBottomComponent((Component)this.indexInfoPanel);
        this.splitIndex.setDividerLocation(this.settings.getValue("split-location", Long.valueOf(this.splitIndex.getDividerLocation())).intValue());
        this.buttonExpressionColumn.setSelected(this.settings.getValue("expression-column", Boolean.valueOf(this.buttonExpressionColumn.isSelected())));
        this.tableIndexes.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
            private String indexName;

            public void valueChanged(ListSelectionEvent e) {
                int rowIndex = MViewIndexesPanel.this.tableIndexes.getSelectedRow();
                if (rowIndex >= 0 && MViewIndexesPanel.this.tableIndexes.getQuery().isActive()) {
                    try {
                        MViewIndexesPanel.this.tableIndexes.getQuery().getRecord(rowIndex);
                        if (this.indexName == null || !MViewIndexesPanel.this.tableIndexes.getQuery().fieldByName("index_name").getString().equals(this.indexName)) {
                            this.indexName = MViewIndexesPanel.this.tableIndexes.getQuery().fieldByName("index_name").getString();
                            MViewIndexesPanel.this.indexInfoPanel.refresh(Sql.getIndexInfo(MViewIndexesPanel.this.currentSchemaName, this.indexName));
                        }
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                }
            }
        });
        this.tableIndexes.getQuery().setDatabase(this.getDatabase());
        try {
            this.prepareTableColumns();
            SqlFilterDef def = new SqlFilterDef();
            def.add(new SqlFilterDefComponent("uidx.index_name", this.stringManager.getString("index-name"), (String[])null));
            def.add(new SqlFilterDefComponent("uic.column_name", this.stringManager.getString("column-name"), (String[])null));
            def.add(new SqlFilterDefComponent("uidx.tablespace_name", this.stringManager.getString("tablespace-name"), (String[])null));
            def.add(new SqlFilterDefComponent("uidx.index_type", this.stringManager.getString("index-type"), new String[]{"", "'NORMAL'"}));
            def.add(new SqlFilterDefComponent("uidx.uniqueness = 'UNIQUE'", this.stringManager.getString("unique")));
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-mview-indexes-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableIndexes, (JButton)this.buttonActions, this.menuActions, "oracle-mview-indexes-actions");
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public String getTitle() {
        return this.stringManager.getString("MViewIndexesPanel-title");
    }

    private void prepareTableColumns() {
        this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("index_name", this.stringManager.getString("index-name"), 200, (TableCellRenderer)new QueryTableCellRenderer(1)));
        this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("column_position", this.stringManager.getString("pos"), 30));
        this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("column_name", this.stringManager.getString("column-name"), 100));
        if (this.buttonExpressionColumn.isSelected()) {
            this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("column_expression", this.stringManager.getString("expression"), 100));
        }
        this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("uniqueness", this.stringManager.getString("uniqueness"), 50));
        this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("status", this.stringManager.getString("status"), 60));
        this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("index_type", this.stringManager.getString("index-type"), 60));
        this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("initial_extent", this.stringManager.getString("initial-extent"), 70));
        this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("next_extent", this.stringManager.getString("next-extent"), 70));
        this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("min_extents", this.stringManager.getString("min-extent"), 70));
        this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("max_extents", this.stringManager.getString("max-extent"), 70));
        this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("pct_increase", this.stringManager.getString("pct-increase"), 50));
        this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("pct_free", this.stringManager.getString("pct-free"), 50));
        this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("tablespace_name", this.stringManager.getString("tablespace-name"), 100));
        this.tableIndexes.revalidate();
    }

    private void refreshTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                MViewIndexesPanel.this.refresh();
            }
        });
    }

    public void refresh() {
        try {
            this.requestRefresh = false;
            this.tableIndexes.getQuery().close();
            this.tableIndexes.getQuery().setSqlText(Sql.getIndexList(this.filter.getSqlText(), this.buttonExpressionColumn.isSelected()));
            this.tableIndexes.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
            this.tableIndexes.getQuery().paramByName("table_name").setString(this.currentTableName);
            this.tableIndexes.getQuery().open();
            if (!this.tableIndexes.getQuery().isEmpty()) {
                this.tableIndexes.changeSelection(0, 0);
            }
        }
        catch (Exception ex) {
            MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
        }
    }

    public void refresh(String catalogName, String schemaName, String objectName) {
        if (!this.currentSchemaName.equals(schemaName) || !this.currentTableName.equals(objectName) || this.requestRefresh) {
            this.currentSchemaName = schemaName;
            this.currentTableName = objectName;
            if (this.isVisible()) {
                this.refresh();
            } else {
                this.requestRefresh = true;
            }
        }
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.closing = true;
        this.settings.setValue("split-location", Long.valueOf(this.splitIndex.getDividerLocation()));
        this.settings.setValue("expression-column", Boolean.valueOf(this.buttonExpressionColumn.isSelected()));
        this.settings.store();
        this.tableIndexes.getQuery().close();
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.cmDropIndex = new Action();
        this.menuActions = new JPopupMenu();
        this.menuCreateIndex = new JMenuItem();
        this.menuRebuildIndex = new JMenuItem();
        this.menuRenameIndex = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.menuDropIndex = new JMenuItem();
        this.cmExpressionColumn = new Action();
        this.cmCreateIndex = new Action();
        this.cmRebuildIndex = new Action();
        this.cmRenameIndex = new Action();
        this.statusBarIndexes = new QueryTableStatusBar();
        this.jPanel1 = new JPanel();
        this.toolBarIndexes = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.buttonExpressionColumn = new JToggleButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.splitIndex = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.tableIndexes = new ViewTable();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MViewIndexesPanel.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MViewIndexesPanel.this.cmFilterActionPerformed(evt);
            }
        });
        this.cmDropIndex.setActionCommandKey("cmDropIndex");
        this.cmDropIndex.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDropIndex.setText(this.stringManager.getString("cmDropIndex-text"));
        this.cmDropIndex.setTooltip(this.stringManager.getString("cmDropIndex-hint"));
        this.cmDropIndex.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MViewIndexesPanel.this.cmDropIndexActionPerformed(evt);
            }
        });
        this.menuCreateIndex.setAction((javax.swing.Action)this.cmCreateIndex);
        this.menuActions.add(this.menuCreateIndex);
        this.menuRebuildIndex.setAction((javax.swing.Action)this.cmRebuildIndex);
        this.menuActions.add(this.menuRebuildIndex);
        this.menuRenameIndex.setAction((javax.swing.Action)this.cmRenameIndex);
        this.menuActions.add(this.menuRenameIndex);
        this.menuActions.add(this.jSeparator3);
        this.menuDropIndex.setAction((javax.swing.Action)this.cmDropIndex);
        this.menuActions.add(this.menuDropIndex);
        this.cmExpressionColumn.setActionCommandKey("cmExpressionColumn");
        this.cmExpressionColumn.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/expression.gif"));
        this.cmExpressionColumn.setText(this.stringManager.getString("cmExpressionColumn-text"));
        this.cmExpressionColumn.setTooltip(this.stringManager.getString("cmExpressionColumn-hint"));
        this.cmExpressionColumn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MViewIndexesPanel.this.cmExpressionColumnActionPerformed(evt);
            }
        });
        this.cmCreateIndex.setActionCommandKey("cmCreateIndex");
        this.cmCreateIndex.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/create_index16.gif"));
        this.cmCreateIndex.setText(this.stringManager.getString("cmCreateIndex-text"));
        this.cmCreateIndex.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MViewIndexesPanel.this.cmCreateIndexActionPerformed(evt);
            }
        });
        this.cmRebuildIndex.setActionCommandKey("cmRebuildIndex");
        this.cmRebuildIndex.setText(this.stringManager.getString("cmRebuildIndex-text"));
        this.cmRebuildIndex.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MViewIndexesPanel.this.cmRebuildIndexActionPerformed(evt);
            }
        });
        this.cmRenameIndex.setActionCommandKey("cmRenameIndex");
        this.cmRenameIndex.setText(this.stringManager.getString("cmRenameIndex-text"));
        this.cmRenameIndex.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MViewIndexesPanel.this.cmRenameIndexActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                MViewIndexesPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.statusBarIndexes.setShowFieldType(false);
        this.statusBarIndexes.setShowOpenTime(false);
        this.statusBarIndexes.setTable((QueryTable)this.tableIndexes);
        this.add((Component)this.statusBarIndexes, "Last");
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarIndexes.setFloatable(false);
        this.toolBarIndexes.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarIndexes.add((Component)this.buttonRefresh);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarIndexes.add((Component)this.buttonFilter);
        this.buttonExpressionColumn.setAction((javax.swing.Action)this.cmExpressionColumn);
        this.buttonExpressionColumn.setFocusable(false);
        this.buttonExpressionColumn.setHideActionText(true);
        this.buttonExpressionColumn.setHorizontalTextPosition(0);
        this.buttonExpressionColumn.setPreferredSize(new Dimension(26, 26));
        this.buttonExpressionColumn.setVerticalTextPosition(3);
        this.toolBarIndexes.add(this.buttonExpressionColumn);
        this.toolBarIndexes.add(this.jSeparator1);
        this.toolBarIndexes.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBarIndexes);
        this.add((Component)this.jPanel1, "North");
        this.splitIndex.setBorder(null);
        this.splitIndex.setDividerLocation(350);
        this.splitIndex.setOrientation(0);
        this.splitIndex.setContinuousLayout(true);
        this.splitIndex.setOneTouchExpandable(true);
        this.jScrollPane1.setViewportView((Component)this.tableIndexes);
        this.splitIndex.setLeftComponent(this.jScrollPane1);
        this.add((Component)this.splitIndex, "Center");
    }

    private void cmDropIndexActionPerformed(ActionEvent evt) {
        if (this.tableIndexes.getSelectedRow() >= 0) {
            try {
                this.tableIndexes.getQuery().getRecord(this.tableIndexes.getSelectedRow());
                String indexName = this.tableIndexes.getQuery().fieldByName("index_name").getString();
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new DropMViewIndexWizard(this.getDatabase(), this.currentSchemaName, this.currentTableName, indexName), (boolean)true) != null) {
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void formComponentShown(ComponentEvent evt) {
        if (this.requestRefresh && !this.closing) {
            this.refreshTask();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void cmExpressionColumnActionPerformed(ActionEvent evt) {
        ((QueryTableColumnModel)this.tableIndexes.getColumnModel()).clearColumns();
        this.refresh();
        this.prepareTableColumns();
    }

    private void cmCreateIndexActionPerformed(ActionEvent evt) {
        if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateMViewIndexWizard(this.getDatabase(), this.currentSchemaName, this.currentTableName), (boolean)true) != null) {
            this.refresh();
        }
    }

    private void cmRebuildIndexActionPerformed(ActionEvent evt) {
        if (this.tableIndexes.getSelectedRow() >= 0) {
            try {
                this.tableIndexes.getQuery().getRecord(this.tableIndexes.getSelectedRow());
                String indexName = this.tableIndexes.getQuery().fieldByName("index_name").getString();
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new RebuildMViewIndexWizard(this.getDatabase(), this.currentSchemaName, this.currentTableName, indexName), (boolean)true) != null) {
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
    }

    private void cmRenameIndexActionPerformed(ActionEvent evt) {
        if (this.tableIndexes.getSelectedRow() >= 0) {
            try {
                this.tableIndexes.getQuery().getRecord(this.tableIndexes.getSelectedRow());
                String indexName = this.tableIndexes.getQuery().fieldByName("index_name").getString();
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new RenameMViewIndexWizard(this.getDatabase(), this.currentSchemaName, this.currentTableName, indexName), (boolean)true) != null) {
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
    }
}

