/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.mviews;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.OrbadaTabbedPane;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.gui.util.SimpleSelectDialog;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.gui.freezing.MViewFreezeViewService;
import pl.mpak.orbada.oracle.gui.mviews.MViewSourcePanel;
import pl.mpak.orbada.oracle.gui.mviews.MViewTabbedPane;
import pl.mpak.orbada.oracle.gui.wizards.mview.CacheMViewWizard;
import pl.mpak.orbada.oracle.gui.wizards.mview.CompressMViewWizard;
import pl.mpak.orbada.oracle.gui.wizards.mview.CopyMViewAsTableWizard;
import pl.mpak.orbada.oracle.gui.wizards.mview.DropMViewWizard;
import pl.mpak.orbada.oracle.gui.wizards.mview.LoggingMViewWizard;
import pl.mpak.orbada.oracle.gui.wizards.mview.QueryRewriteMViewWizard;
import pl.mpak.orbada.oracle.gui.wizards.mview.RefreshMethodMViewWizard;
import pl.mpak.orbada.oracle.gui.wizards.mview.RefreshTypeMViewWizard;
import pl.mpak.orbada.oracle.gui.wizards.mview.RowMovementMViewWizard;
import pl.mpak.orbada.oracle.gui.wizards.mview.ShrinkMViewWizard;
import pl.mpak.orbada.oracle.services.OracleDbInfoProvider;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableCellRendererFilter;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.QueryUtil;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.timer.Timer;
import pl.mpak.util.variant.Variant;

public class MViewsPanelView
extends JPanel
implements IRootTabObjectInfo {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName;
    private String tabTitle;
    private SqlFilter filter;
    private boolean viewClosing = false;
    private ISettings settings;
    private Timer timer;
    private OrbadaTabbedPane tabbedPane;
    private boolean refreshing = false;
    private ToolButton buttonActions;
    private ToolButton buttonCompile;
    private ToolButton buttonFilter;
    private ToolButton buttonFreezeObject;
    private ToolButton buttonRefresh;
    private ToolButton buttonSelectSchema;
    private Action cmCacheMView;
    private Action cmCompile;
    private Action cmCompressMView;
    private Action cmCopyViewAsTable;
    private Action cmDropView;
    private Action cmFilter;
    private Action cmFreezeObject;
    private Action cmLoggingMView;
    private Action cmQueryRewriteMView;
    private Action cmRecordCount;
    private Action cmRefresh;
    private Action cmRefreshMethodMView;
    private Action cmRefreshTypeMView;
    private Action cmRowMovementMView;
    private Action cmSelectSchema;
    private Action cmShrinkMView;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JPopupMenu menuActions;
    private JMenuItem menuCacheMView;
    private JMenuItem menuCompressMView;
    private JMenuItem menuCopyView;
    private JMenuItem menuDropView;
    private JMenuItem menuLoggingMView;
    private JMenuItem menuQueryRewriteMView;
    private JMenuItem menuRecordCount;
    private JMenuItem menuRefreshMethodMView;
    private JMenuItem menuRefreshTypeMView;
    private JMenuItem menuRowMovementMView;
    private JMenuItem menuShrinkMView;
    private JPanel panelViews;
    private JSplitPane split;
    private QueryTableStatusBar statusBar;
    private ViewTable tableViews;
    private JToolBar toolBar;

    public MViewsPanelView(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.tabTitle = this.accesibilities.getTabTitle();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.timer = new Timer(250L){
            {
                this.setEnabled(false);
            }

            public void run() {
                this.setEnabled(false);
                MViewsPanelView.this.refreshTabbedPanes();
            }
        };
        OrbadaOraclePlugin.getRefreshQueue().add(this.timer);
        this.tabbedPane = new MViewTabbedPane(this.accesibilities);
        this.split.setRightComponent((Component)this.tabbedPane);
        this.settings = this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-mviews-panel");
        this.split.setDividerLocation(this.settings.getValue("split-location", Long.valueOf(this.split.getDividerLocation())).intValue());
        this.currentSchemaName = OracleDbInfoProvider.getCurrentSchema(this.getDatabase());
        this.tableViews.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
            int lastIndex = -1;

            public void valueChanged(ListSelectionEvent e) {
                if (!MViewsPanelView.this.refreshing) {
                    MViewSourcePanel panel = (MViewSourcePanel)MViewsPanelView.this.tabbedPane.getComponent(MViewSourcePanel.class);
                    if (panel != null && this.lastIndex != MViewsPanelView.this.tableViews.getSelectedRow() && !panel.canClose()) {
                        MViewsPanelView.this.tableViews.changeSelection(this.lastIndex, MViewsPanelView.this.tableViews.getSelectedColumn());
                        return;
                    }
                    this.lastIndex = MViewsPanelView.this.tableViews.getSelectedRow();
                    MViewsPanelView.this.timer.restart();
                }
            }
        });
        this.tableViews.getQuery().setDatabase(this.getDatabase());
        this.tableViews.addColumn((TableColumn)new QueryTableColumn("view_name", this.stringManager.getString("view-name"), 130, (TableCellRenderer)new QueryTableCellRenderer(1)));
        this.tableViews.addColumn((TableColumn)new QueryTableColumn("status", this.stringManager.getString("status"), 50, (TableCellRenderer)new QueryTableCellRenderer(new QueryTableCellRendererFilter(){

            public void cellRendererPerformed(JTable table, Component renderer, Object value, boolean isSelected, boolean hasFocus) {
                if (StringUtil.nvl((String)((String)value), (String)"").equals("VALID")) {
                    ((JLabel)renderer).setForeground(SwingUtil.Color.GREEN);
                } else if (StringUtil.nvl((String)((String)value), (String)"").equals("INVALID")) {
                    ((JLabel)renderer).setForeground(Color.RED);
                }
            }
        })));
        this.tableViews.addColumn((TableColumn)new QueryTableColumn("created", this.stringManager.getString("created"), 110));
        SqlFilterDef def = new SqlFilterDef();
        def.add(new SqlFilterDefComponent("o.object_name", this.stringManager.getString("view-name"), (String[])null));
        def.add(new SqlFilterDefComponent("o.status = 'INVALID'", this.stringManager.getString("invalid")));
        this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-mviews-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        SwingUtil.addAction((JComponent)this.tableViews, (javax.swing.Action)this.cmCompile);
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableViews, (JButton)this.buttonActions, this.menuActions, "oracle-mviews-actions");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                MViewsPanelView.this.tableViews.requestFocusInWindow();
            }
        });
    }

    public void setCurrentSchemaName(String schemaName) {
        if (!this.currentSchemaName.equals(schemaName)) {
            this.currentSchemaName = schemaName;
            if (!this.currentSchemaName.equalsIgnoreCase(OracleDbInfoProvider.getCurrentSchema(this.getDatabase()))) {
                this.accesibilities.setTabTitle(this.tabTitle + " (" + this.currentSchemaName + ")");
            } else {
                this.accesibilities.setTabTitle(this.tabTitle);
            }
        }
    }

    private void refreshTabbedPanes() {
        String viewName = "";
        int rowIndex = this.tableViews.getSelectedRow();
        if (rowIndex >= 0 && this.tableViews.getQuery().isActive()) {
            try {
                this.tableViews.getQuery().getRecord(rowIndex);
                viewName = this.tableViews.getQuery().fieldByName("view_name").getString();
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
        this.tabbedPane.refresh(null, this.currentSchemaName, viewName);
    }

    private void refreshTableListTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                MViewsPanelView.this.refresh();
            }
        });
    }

    public void refresh() {
        if (!this.isVisible() || this.viewClosing) {
            return;
        }
        try {
            String viewName = null;
            if (this.tableViews.getQuery().isActive() && this.tableViews.getSelectedRow() >= 0) {
                this.tableViews.getQuery().getRecord(this.tableViews.getSelectedRow());
                viewName = this.tableViews.getQuery().fieldByName("view_name").getString();
            }
            this.refresh(viewName);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(String objectName) {
        this.refreshing = true;
        try {
            int column = this.tableViews.getSelectedColumn();
            int index = Math.max(0, this.tableViews.getSelectedRow());
            this.tableViews.getQuery().close();
            this.tableViews.getQuery().setSqlText(Sql.getMViewList(this.filter.getSqlText()));
            this.tableViews.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
            this.tableViews.getQuery().open();
            if (objectName != null && this.tableViews.getQuery().locate("view_name", new Variant(objectName))) {
                this.tableViews.changeSelection(this.tableViews.getQuery().getCurrentRecord().getIndex(), column);
            } else if (!this.tableViews.getQuery().isEmpty()) {
                this.tableViews.changeSelection(Math.min(index, this.tableViews.getRowCount() - 1), column);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            this.refreshing = false;
            this.refreshTabbedPanes();
        }
    }

    public boolean canClose() {
        return this.tabbedPane.canClose();
    }

    public void close() throws IOException {
        this.timer.cancel();
        this.settings.setValue("split-location", Long.valueOf(this.split.getDividerLocation()));
        this.viewClosing = true;
        this.tabbedPane.close();
        this.tableViews.getQuery().close();
        this.accesibilities = null;
        this.settings.store();
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmSelectSchema = new Action();
        this.cmFilter = new Action();
        this.cmDropView = new Action();
        this.menuActions = new JPopupMenu();
        this.menuRecordCount = new JMenuItem();
        this.menuCopyView = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.menuCacheMView = new JMenuItem();
        this.menuCompressMView = new JMenuItem();
        this.menuQueryRewriteMView = new JMenuItem();
        this.menuLoggingMView = new JMenuItem();
        this.menuRefreshMethodMView = new JMenuItem();
        this.menuRefreshTypeMView = new JMenuItem();
        this.menuShrinkMView = new JMenuItem();
        this.menuRowMovementMView = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.menuDropView = new JMenuItem();
        this.cmRecordCount = new Action();
        this.cmCopyViewAsTable = new Action();
        this.cmFreezeObject = new Action();
        this.cmCompile = new Action();
        this.cmCacheMView = new Action();
        this.cmCompressMView = new Action();
        this.cmQueryRewriteMView = new Action();
        this.cmLoggingMView = new Action();
        this.cmRefreshMethodMView = new Action();
        this.cmRefreshTypeMView = new Action();
        this.cmShrinkMView = new Action();
        this.cmRowMovementMView = new Action();
        this.split = new JSplitPane();
        this.panelViews = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableViews = new ViewTable();
        this.jPanel1 = new JPanel();
        this.toolBar = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonSelectSchema = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.buttonFreezeObject = new ToolButton();
        this.jSeparator1 = new JSeparator();
        this.buttonCompile = new ToolButton();
        this.buttonActions = new ToolButton();
        this.jPanel2 = new JPanel();
        this.statusBar = new QueryTableStatusBar();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MViewsPanelView.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmSelectSchema.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/users16.gif"));
        this.cmSelectSchema.setText(this.stringManager.getString("cmSelectSchema-text"));
        this.cmSelectSchema.setTooltip(this.stringManager.getString("cmSelectSchema-hint"));
        this.cmSelectSchema.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MViewsPanelView.this.cmSelectSchemaActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/filter16.gif"));
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MViewsPanelView.this.cmFilterActionPerformed(evt);
            }
        });
        this.cmDropView.setActionCommandKey("cmDropView");
        this.cmDropView.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDropView.setText(this.stringManager.getString("cmDropView-text"));
        this.cmDropView.setTooltip(this.stringManager.getString("cmDropView-hint"));
        this.cmDropView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MViewsPanelView.this.cmDropViewActionPerformed(evt);
            }
        });
        this.menuRecordCount.setAction((javax.swing.Action)this.cmRecordCount);
        this.menuActions.add(this.menuRecordCount);
        this.menuCopyView.setAction((javax.swing.Action)this.cmCopyViewAsTable);
        this.menuActions.add(this.menuCopyView);
        this.menuActions.add(this.jSeparator2);
        this.menuCacheMView.setAction((javax.swing.Action)this.cmCacheMView);
        this.menuActions.add(this.menuCacheMView);
        this.menuCompressMView.setAction((javax.swing.Action)this.cmCompressMView);
        this.menuActions.add(this.menuCompressMView);
        this.menuQueryRewriteMView.setAction((javax.swing.Action)this.cmQueryRewriteMView);
        this.menuActions.add(this.menuQueryRewriteMView);
        this.menuLoggingMView.setAction((javax.swing.Action)this.cmLoggingMView);
        this.menuActions.add(this.menuLoggingMView);
        this.menuRefreshMethodMView.setAction((javax.swing.Action)this.cmRefreshMethodMView);
        this.menuActions.add(this.menuRefreshMethodMView);
        this.menuRefreshTypeMView.setAction((javax.swing.Action)this.cmRefreshTypeMView);
        this.menuActions.add(this.menuRefreshTypeMView);
        this.menuShrinkMView.setAction((javax.swing.Action)this.cmShrinkMView);
        this.menuActions.add(this.menuShrinkMView);
        this.menuRowMovementMView.setAction((javax.swing.Action)this.cmRowMovementMView);
        this.menuActions.add(this.menuRowMovementMView);
        this.menuActions.add(this.jSeparator3);
        this.menuDropView.setAction((javax.swing.Action)this.cmDropView);
        this.menuActions.add(this.menuDropView);
        this.cmRecordCount.setActionCommandKey("cmRecordCount");
        this.cmRecordCount.setText(this.stringManager.getString("cmRecordCount-text"));
        this.cmRecordCount.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MViewsPanelView.this.cmRecordCountActionPerformed(evt);
            }
        });
        this.cmCopyViewAsTable.setActionCommandKey("cmCopyViewAsTable");
        this.cmCopyViewAsTable.setText(this.stringManager.getString("cmCopyViewAsTable-text"));
        this.cmCopyViewAsTable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MViewsPanelView.this.cmCopyViewAsTableActionPerformed(evt);
            }
        });
        this.cmFreezeObject.setActionCommandKey("cmFreezeObject");
        this.cmFreezeObject.setShortCut(KeyStroke.getKeyStroke(114, 0));
        this.cmFreezeObject.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/freeze.gif"));
        this.cmFreezeObject.setText(this.stringManager.getString("cmFreezeObject-text"));
        this.cmFreezeObject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MViewsPanelView.this.cmFreezeObjectActionPerformed(evt);
            }
        });
        this.cmCompile.setActionCommandKey("cmCompile");
        this.cmCompile.setShortCut(KeyStroke.getKeyStroke(10, 2));
        this.cmCompile.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/db_sql_execute16.gif"));
        this.cmCompile.setText(this.stringManager.getString("cmCompile-text"));
        this.cmCompile.setTooltip(this.stringManager.getString("cmCompile-hint"));
        this.cmCompile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MViewsPanelView.this.cmCompileActionPerformed(evt);
            }
        });
        this.cmCacheMView.setActionCommandKey("cmCacheMView");
        this.cmCacheMView.setText(this.stringManager.getString("cmCacheMView-text"));
        this.cmCacheMView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MViewsPanelView.this.cmCacheMViewActionPerformed(evt);
            }
        });
        this.cmCompressMView.setActionCommandKey("cmCompressMView");
        this.cmCompressMView.setText(this.stringManager.getString("cmCompressMView-text"));
        this.cmCompressMView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MViewsPanelView.this.cmCompressMViewActionPerformed(evt);
            }
        });
        this.cmQueryRewriteMView.setActionCommandKey("cmQueryRewriteMView");
        this.cmQueryRewriteMView.setText(this.stringManager.getString("cmQueryRewriteMView-text"));
        this.cmQueryRewriteMView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MViewsPanelView.this.cmQueryRewriteMViewActionPerformed(evt);
            }
        });
        this.cmLoggingMView.setActionCommandKey("cmLoggingMView");
        this.cmLoggingMView.setText(this.stringManager.getString("cmLoggingMView-text"));
        this.cmLoggingMView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MViewsPanelView.this.cmLoggingMViewActionPerformed(evt);
            }
        });
        this.cmRefreshMethodMView.setActionCommandKey("cmRefreshMethodMView");
        this.cmRefreshMethodMView.setText(this.stringManager.getString("cmRefreshMethodMView-text"));
        this.cmRefreshMethodMView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MViewsPanelView.this.cmRefreshMethodMViewActionPerformed(evt);
            }
        });
        this.cmRefreshTypeMView.setActionCommandKey("cmRefreshTypeMView");
        this.cmRefreshTypeMView.setText(this.stringManager.getString("cmRefreshTypeMView-text"));
        this.cmRefreshTypeMView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MViewsPanelView.this.cmRefreshTypeMViewActionPerformed(evt);
            }
        });
        this.cmShrinkMView.setActionCommandKey("cmShrinkMView");
        this.cmShrinkMView.setText(this.stringManager.getString("cmShrinkMView-text"));
        this.cmShrinkMView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MViewsPanelView.this.cmShrinkMViewActionPerformed(evt);
            }
        });
        this.cmRowMovementMView.setActionCommandKey("cmRowMovementMView");
        this.cmRowMovementMView.setText(this.stringManager.getString("cmRowMovementMView-text"));
        this.cmRowMovementMView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MViewsPanelView.this.cmRowMovementMViewActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                MViewsPanelView.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.split.setBorder(null);
        this.split.setDividerLocation(200);
        this.split.setContinuousLayout(true);
        this.split.setOneTouchExpandable(true);
        this.panelViews.setPreferredSize(new Dimension(250, 100));
        this.panelViews.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableViews);
        this.panelViews.add((Component)this.jScrollPane1, "Center");
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonRefresh);
        this.buttonSelectSchema.setAction((javax.swing.Action)this.cmSelectSchema);
        this.buttonSelectSchema.setHorizontalTextPosition(0);
        this.buttonSelectSchema.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonSelectSchema);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonFilter);
        this.buttonFreezeObject.setAction((javax.swing.Action)this.cmFreezeObject);
        this.buttonFreezeObject.setHorizontalTextPosition(0);
        this.buttonFreezeObject.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonFreezeObject);
        this.jSeparator1.setOrientation(1);
        this.toolBar.add(this.jSeparator1);
        this.buttonCompile.setAction((javax.swing.Action)this.cmCompile);
        this.buttonCompile.setHorizontalTextPosition(0);
        this.buttonCompile.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonCompile);
        this.toolBar.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBar);
        this.panelViews.add((Component)this.jPanel1, "North");
        this.jPanel2.setLayout(new BorderLayout());
        this.statusBar.setShowFieldType(false);
        this.statusBar.setShowFieldValue(false);
        this.statusBar.setShowOpenTime(false);
        this.statusBar.setTable((QueryTable)this.tableViews);
        this.jPanel2.add((Component)this.statusBar, "South");
        this.panelViews.add((Component)this.jPanel2, "South");
        this.split.setLeftComponent(this.panelViews);
        this.add((Component)this.split, "Center");
    }

    private void cmDropViewActionPerformed(ActionEvent evt) {
        if (this.tableViews.getSelectedRow() >= 0) {
            try {
                this.tableViews.getQuery().getRecord(this.tableViews.getSelectedRow());
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new DropMViewWizard(this.getDatabase(), this.currentSchemaName, this.tableViews.getQuery().fieldByName("view_name").getString()), (boolean)true) != null) {
                    this.refresh(null);
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void formComponentShown(ComponentEvent evt) {
        if (!this.tableViews.getQuery().isActive()) {
            this.refreshTableListTask();
        }
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmSelectSchemaActionPerformed(ActionEvent evt) {
        Query query = this.getDatabase().createQuery();
        try {
            query.open(Sql.getSchemaList());
            Vector vl = QueryUtil.staticData((String)"{schema_name}", (Query)query);
            Point point = this.buttonSelectSchema.getLocationOnScreen();
            point.y += this.buttonSelectSchema.getHeight();
            SimpleSelectDialog.select((Window)SwingUtil.getWindowComponent((Component)this), (int)point.x, (int)point.y, (Vector)vl, (int)vl.indexOf(this.currentSchemaName), (SimpleSelectDialog.CallBack)new SimpleSelectDialog.CallBack(){

                public void selected(Object o) {
                    MViewsPanelView.this.setCurrentSchemaName(o.toString());
                    MViewsPanelView.this.refresh();
                }
            });
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmRecordCountActionPerformed(ActionEvent evt) {
        if (this.tableViews.getSelectedRow() >= 0) {
            Query query = this.getDatabase().createQuery();
            try {
                this.tableViews.getQuery().getRecord(this.tableViews.getSelectedRow());
                String schemaName = this.tableViews.getQuery().fieldByName("schema_name").getString();
                String view_name = this.tableViews.getQuery().fieldByName("view_name").getString();
                query.open("select count( 0 ) cnt from " + SQLUtil.createSqlName((String)schemaName, (String)view_name));
                MessageBox.show((Component)this, (String)this.stringManager.getString("record-count"), (String)String.format(this.stringManager.getString("view-record-count-info"), SQLUtil.createSqlName((String)schemaName, (String)view_name), query.fieldByName("cnt").getString()), (int)1, (int)1);
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
            finally {
                query.close();
            }
        }
    }

    private void cmCopyViewAsTableActionPerformed(ActionEvent evt) {
        if (this.tableViews.getSelectedRow() >= 0) {
            try {
                this.tableViews.getQuery().getRecord(this.tableViews.getSelectedRow());
                String viewName = this.tableViews.getQuery().fieldByName("view_name").getString();
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CopyMViewAsTableWizard(this.getDatabase(), this.currentSchemaName, viewName), (boolean)true) != null) {
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmFreezeObjectActionPerformed(ActionEvent evt) {
        if (this.tableViews.getSelectedRow() >= 0) {
            try {
                this.tableViews.getQuery().getRecord(this.tableViews.getSelectedRow());
                String viewName = this.tableViews.getQuery().fieldByName("view_name").getString();
                this.accesibilities.createView((ViewProvider)new MViewFreezeViewService(this.accesibilities, this.currentSchemaName, viewName));
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmCompileActionPerformed(ActionEvent evt) {
        if (this.tableViews.getSelectedRow() >= 0) {
            try {
                this.tableViews.getQuery().getRecord(this.tableViews.getSelectedRow());
                String viewName = this.tableViews.getQuery().fieldByName("view_name").getString();
                this.getDatabase().executeCommand("ALTER MATERIALIZED VIEW " + SQLUtil.createSqlName((String)this.currentSchemaName, (String)viewName) + " COMPILE");
                this.refresh();
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
    }

    private void cmCacheMViewActionPerformed(ActionEvent evt) {
        if (this.tableViews.getSelectedRow() >= 0) {
            try {
                this.tableViews.getQuery().getRecord(this.tableViews.getSelectedRow());
                String viewName = this.tableViews.getQuery().fieldByName("view_name").getString();
                SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CacheMViewWizard(this.getDatabase(), this.currentSchemaName, viewName), (boolean)true);
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmCompressMViewActionPerformed(ActionEvent evt) {
        if (this.tableViews.getSelectedRow() >= 0) {
            try {
                this.tableViews.getQuery().getRecord(this.tableViews.getSelectedRow());
                String viewName = this.tableViews.getQuery().fieldByName("view_name").getString();
                SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CompressMViewWizard(this.getDatabase(), this.currentSchemaName, viewName), (boolean)true);
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmQueryRewriteMViewActionPerformed(ActionEvent evt) {
        if (this.tableViews.getSelectedRow() >= 0) {
            try {
                this.tableViews.getQuery().getRecord(this.tableViews.getSelectedRow());
                String viewName = this.tableViews.getQuery().fieldByName("view_name").getString();
                SqlCodeWizardDialog.show((SqlCodeWizardPanel)new QueryRewriteMViewWizard(this.getDatabase(), this.currentSchemaName, viewName), (boolean)true);
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmLoggingMViewActionPerformed(ActionEvent evt) {
        if (this.tableViews.getSelectedRow() >= 0) {
            try {
                this.tableViews.getQuery().getRecord(this.tableViews.getSelectedRow());
                String viewName = this.tableViews.getQuery().fieldByName("view_name").getString();
                SqlCodeWizardDialog.show((SqlCodeWizardPanel)new LoggingMViewWizard(this.getDatabase(), this.currentSchemaName, viewName), (boolean)true);
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmRefreshMethodMViewActionPerformed(ActionEvent evt) {
        if (this.tableViews.getSelectedRow() >= 0) {
            try {
                this.tableViews.getQuery().getRecord(this.tableViews.getSelectedRow());
                String viewName = this.tableViews.getQuery().fieldByName("view_name").getString();
                SqlCodeWizardDialog.show((SqlCodeWizardPanel)new RefreshMethodMViewWizard(this.getDatabase(), this.currentSchemaName, viewName), (boolean)true);
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmRefreshTypeMViewActionPerformed(ActionEvent evt) {
        if (this.tableViews.getSelectedRow() >= 0) {
            try {
                this.tableViews.getQuery().getRecord(this.tableViews.getSelectedRow());
                String viewName = this.tableViews.getQuery().fieldByName("view_name").getString();
                SqlCodeWizardDialog.show((SqlCodeWizardPanel)new RefreshTypeMViewWizard(this.getDatabase(), this.currentSchemaName, viewName), (boolean)true);
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmShrinkMViewActionPerformed(ActionEvent evt) {
        if (this.tableViews.getSelectedRow() >= 0) {
            try {
                this.tableViews.getQuery().getRecord(this.tableViews.getSelectedRow());
                String viewName = this.tableViews.getQuery().fieldByName("view_name").getString();
                SqlCodeWizardDialog.show((SqlCodeWizardPanel)new ShrinkMViewWizard(this.getDatabase(), this.currentSchemaName, viewName), (boolean)true);
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmRowMovementMViewActionPerformed(ActionEvent evt) {
        if (this.tableViews.getSelectedRow() >= 0) {
            try {
                this.tableViews.getQuery().getRecord(this.tableViews.getSelectedRow());
                String viewName = this.tableViews.getQuery().fieldByName("view_name").getString();
                SqlCodeWizardDialog.show((SqlCodeWizardPanel)new RowMovementMViewWizard(this.getDatabase(), this.currentSchemaName, viewName), (boolean)true);
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }
}

